package com.yeejoin.amos.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * <pre>
 *  跨域处理
 * </pre>
 *
 * @author SmartRay
 * @version CrossDomainFilter.java v0.1
 * @time  2016-9-7 9:48:10 
 */
@Component(value = "crossDomainFilter")
@EnableScheduling
@Order(0)
public class CrossDomainFilter implements Filter
{
    public void destroy()
    {
    }

    public void doFilter(ServletRequest req, ServletResponse res,
                         FilterChain chain) throws IOException, ServletException
    {
        HttpServletResponse response = (HttpServletResponse) res;
        // 允许所有域进行访问
        response.setHeader("Access-Control-Allow-Origin", "*");
        // 允许的方法
        response.setHeader("Access-Control-Allow-Methods","GET,POST,DELETE,OPTIONS,PUT");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers","Origin, X-Requested-With, X-Access-Token, X-Api-Key, Content-Type, Accept, Cache-Control,appKey, product, token, channelType");
        chain.doFilter(req, res);
    }

    public void init(FilterConfig arg0) throws ServletException
    {
    }

}
