package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 管控级别
 */
public enum  ManageLevelEum {
    company("单位级",1),
    department("部门级",2),
    group("班组级",3),
    person("个人级",4);

    private String name;
    private int manageLevel;
    ManageLevelEum(String name,int manageLevel){
        this.name = name;
        this.manageLevel = manageLevel;
    }

    public static List<Map> getManageLevelEumList(){
        List<Map> eumList = new ArrayList<>();
        for(ManageLevelEum eum :ManageLevelEum.values()){
            Map<String,Object> param = new HashMap<>();
            param.put("key",eum.getManageLevel());
            param.put("label",eum.getName());
            eumList.add(param);
        }
        return eumList;
    }

    public static String getNameByManageLevel(int level){
        String name = "";
        for(ManageLevelEum eum : ManageLevelEum.values()){
            if(level == eum.getManageLevel()){
                name = eum.getName();
                break;
            }
        }
        return name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getManageLevel() {
        return manageLevel;
    }

    public void setManageLevel(int manageLevel) {
        this.manageLevel = manageLevel;
    }
}
