package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.util.Date;


/**
 * The persistent class for the alarm database table.
 */
@Entity
@Table(name = "f_alarm")
@NamedQuery(name = "Alarm.findAll", query = "SELECT a FROM Alarm a")
public class Alarm extends BasicEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 消防设备id
     */
    private Long fireEquipmentId;
    /**
     * 消防设备名称
     */
    private String fireEquipmentName;
    /**
     * 消防设备编码
     */
    private String fireEquipmentCode;
    /**
     * 消防点位id
     */
    private Long fireEquipmentPointId;
    /**
     * 消防点位名称
     */
    private String fireEquipmentPointName;
    /**
     * 消防点位编码
     */
    private String fireEquipmentPointCode;
    /**
     * 消防点位上传值
     */
    private String fireEquipmentPointValue;
    /**
     * 发生频率
     */
    private int frequency = 1;
    /**
     * 告警状态
     */
    private Boolean status = true;
    /**
     * 报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）
     */
    private String type;
    /**
     * 创建时间
     */
    private Date createDate = new Date();
    /**
     * 更新时间
     */
    private Date updateDate = new Date();
    /**
     * 告警恢复时间
     */
    private Date recoveryDate;


    @Column(name = "org_code")
    private String orgCode;

    public Alarm() {
    }

    public Long getFireEquipmentId() {
        return this.fireEquipmentId;
    }

    public void setFireEquipmentId(Long fireEquipmentId) {
        this.fireEquipmentId = fireEquipmentId;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getFireEquipmentName() {
		return fireEquipmentName;
	}

	public void setFireEquipmentName(String fireEquipmentName) {
		this.fireEquipmentName = fireEquipmentName;
	}

	public String getFireEquipmentCode() {
		return fireEquipmentCode;
	}

	public void setFireEquipmentCode(String fireEquipmentCode) {
		this.fireEquipmentCode = fireEquipmentCode;
	}

	public Long getFireEquipmentPointId() {
		return fireEquipmentPointId;
	}

	public void setFireEquipmentPointId(Long fireEquipmentPointId) {
		this.fireEquipmentPointId = fireEquipmentPointId;
	}

	public String getFireEquipmentPointName() {
		return fireEquipmentPointName;
	}

	public void setFireEquipmentPointName(String fireEquipmentPointName) {
		this.fireEquipmentPointName = fireEquipmentPointName;
	}

	public String getFireEquipmentPointCode() {
		return fireEquipmentPointCode;
	}

	public void setFireEquipmentPointCode(String fireEquipmentPointCode) {
		this.fireEquipmentPointCode = fireEquipmentPointCode;
	}

	public String getFireEquipmentPointValue() {
		return fireEquipmentPointValue;
	}

	public void setFireEquipmentPointValue(String fireEquipmentPointValue) {
		this.fireEquipmentPointValue = fireEquipmentPointValue;
	}

	public int getFrequency() {
		return frequency;
	}

	public void setFrequency(int frequency) {
		this.frequency = frequency;
	}

	public Boolean getStatus() {
		return status;
	}

	public void setStatus(Boolean status) {
		this.status = status;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public Date getRecoveryDate() {
		return recoveryDate;
	}

	public void setRecoveryDate(Date recoveryDate) {
		this.recoveryDate = recoveryDate;
	}
}