package com.yeejoin.amos.fas.dao.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;

import javax.persistence.*;
import java.math.BigDecimal;


/**
 * The persistent class for the rpn_change_log database table.
 */
@Entity
@Table(name = "f_rpn_change_log")
@NamedQuery(name = "RpnChangeLog.findAll", query = "SELECT r FROM RpnChangeLog r")
public class RpnChangeLog extends BasicEntity {
    private static final long serialVersionUID = 1L;

    private String remark;

    @Column(name = "risk_source_id")
    private Long riskSourceId;

    @Column(name = "fmea_id")
    private Long fmeaId;

    private BigDecimal rpn;

    private BigDecimal rpni;

    @Column(name = "trigger_by")
    private Long triggerBy;

    /**
     * 触发变化类型（巡检、告警、评价、删除）
     */
    @Column(name = "trigger_type")
    private String triggerType;

    private int type;

    public String getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }

    private RiskSource riskSource;

    public RpnChangeLog() {
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getRiskSourceId() {
        return this.riskSourceId;
    }

    public void setRiskSourceId(Long riskSourceId) {
        this.riskSourceId = riskSourceId;
    }

    public BigDecimal getRpn() {
        return this.rpn;
    }

    public void setRpn(BigDecimal rpn) {
        this.rpn = rpn;
    }

    public BigDecimal getRpni() {
        return this.rpni;
    }

    public void setRpni(BigDecimal rpni) {
        this.rpni = rpni;
    }

    public Long getTriggerBy() {
        return this.triggerBy;
    }

    public void setTriggerBy(Long triggerBy) {
        this.triggerBy = triggerBy;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @ManyToOne
    @JoinColumn(name = "riskSourceId", referencedColumnName = "id", updatable = false, insertable = false)
    public RiskSource getRiskSource() {
        return riskSource;
    }

    @JsonBackReference
    public void setRiskSource(RiskSource riskSource) {
        this.riskSource = riskSource;
    }

    public Long getFmeaId() {
        return fmeaId;
    }

    public void setFmeaId(Long fmeaId) {
        this.fmeaId = fmeaId;
    }
}