package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.IFireStationService;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.FireStation;
import com.yeejoin.amos.fas.dao.entity.FireStationFireEquipment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

@RestController
@RequestMapping(value = "/api/firestation")
@Api(tags = "消防小室API")
public class FireStationController extends BaseController {

	@Autowired
	IFireStationService iFireStationService;

	@ApiOperation(httpMethod = "POST", value = "添加消防小室", notes = "添加消防小室")
	@RequestMapping(value = "", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse create(@RequestBody FireStation fireStation) throws Exception {

		if (fireStation == null || StringUtils.isEmpty(fireStation.getName())
				|| StringUtils.isEmpty(fireStation.getAddress()) || StringUtils.isEmpty(fireStation.getPosition3d())
				|| StringUtils.isEmpty(fireStation.getCode()))
			throw new Exception("数据校验失败.");
		ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
		fireStation.setCreateBy("0");
		fireStation.setCreateDate(new Date());
		fireStation.setOrgCode(compCode);
		return CommonResponseUtil.success(iFireStationService.save(fireStation));
	}

	@ApiOperation(httpMethod = "POST", value = "绑定消防设备", notes = "绑定消防设备")
	@RequestMapping(value = "/fireequipmenet", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse createFireRelation(@RequestBody List<FireStationFireEquipment> fireStationFireEquipments)
			throws Exception {

		if (CollectionUtils.isEmpty(fireStationFireEquipments))
			throw new Exception("数据校验失败.");

		for (FireStationFireEquipment fireStationFireEquipment : fireStationFireEquipments) {
			fireStationFireEquipment.setCreateBy("0");
			fireStationFireEquipment.setCreateDate(new Date());
		}
		return CommonResponseUtil.success(iFireStationService.saveStationFireEquipment(fireStationFireEquipments));
	}

	@ApiOperation(httpMethod = "DELETE", value = "解除绑定消防设备", notes = "解除绑定消防设备")
	@RequestMapping(value = "/fireequipmenet", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
	public CommonResponse deleteFireEqRelation(@RequestBody List<FireStationFireEquipment> fireStationFireEquipments)
			throws Exception {

		if (CollectionUtils.isEmpty(fireStationFireEquipments))
			throw new Exception("数据校验失败.");
		iFireStationService.deleteStationFireEquipment(fireStationFireEquipments);
		return CommonResponseUtil.success("SUCCESS");
	}

	@ApiOperation(httpMethod = "PUT", value = "编辑消防小室", notes = "编辑消防小室")
	@RequestMapping(value = "/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
	public CommonResponse udpate(@PathVariable Long id, @RequestBody FireStation fireStation) {
		fireStation.setId(id);
		return CommonResponseUtil.success(iFireStationService.save(fireStation));
	}

	@ApiOperation(httpMethod = "GET", value = "查询单个消防小室", notes = "查询单个消防小室")
	@RequestMapping(value = "/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse query(@PathVariable Long id) {

		return CommonResponseUtil.success(iFireStationService.queryOne(id));
	}

	@ApiOperation(httpMethod = "GET", value = "分页查询已经绑定的消防设备列表", notes = "分页查询已经绑定的消防设备列表")
	@RequestMapping(value = "/{id}/fireequipmenet/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse queryForEuqimentList(@PathVariable Long id, @RequestParam int pageNumber,
			@RequestParam int pageSize) {
		CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
		return CommonResponseUtil.success(iFireStationService.queryForFireEquemtPage(id, commonPageable));
	}

	@ApiOperation(httpMethod = "DELETE", value = "删除消防小室", notes = "查询单个消防小室")
	@RequestMapping(value = "/{ids}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
	public CommonResponse delete(@PathVariable String ids) throws Exception {
		String[] idArray = ids.split(",");
		return CommonResponseUtil.success(iFireStationService.delete(idArray));
	}

	@ApiOperation(httpMethod = "GET", value = "分页查询消防小室", notes = "分页查询消防小室")
	@RequestMapping(value = "/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse forPage(
			@ApiParam(value = "名称模糊查询", required = false) @RequestParam(required = false) String name,
			@ApiParam(value = "编号模糊查询", required = false) @RequestParam(required = false) String code,
			@ApiParam(value = "编号模糊查询", required = false) @RequestParam(required = false) String type,
			@RequestParam int pageNumber, @RequestParam int pageSize) {
		CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
		return CommonResponseUtil.success(iFireStationService.queryForPage(StringUtils.trimToNull(name),
				StringUtils.trimToNull(code), StringUtils.trimToNull(type), commonPageable));
	}

	//@Authorization(ingore = true)
	@ApiOperation(httpMethod = "GET", value = "列表查询消防小室", notes = "分页查询消防小室")
	@RequestMapping(value = "/list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse forList(
			@ApiParam(value = "名称模糊查询", required = false) @RequestParam(required = false) String name,
			@ApiParam(value = "编号模糊查询", required = false) @RequestParam(required = false) String code,
			@ApiParam(value = "编号模糊查询", required = false) @RequestParam(required = false) String type

	) {
		return CommonResponseUtil.success(iFireStationService.queryForList(StringUtils.trimToNull(name),
				StringUtils.trimToNull(code), StringUtils.trimToNull(type)));
	}

	//@Authorization(ingore = true)
	@ApiOperation(httpMethod = "POST", value = "添加消防小室及上传图片", notes = "添加消防小室及上传图片")
	@RequestMapping(value = "createAndSaveImg", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse createAndSaveImg(@RequestParam(value = "file", required = false) MultipartFile[] file,
			FireStation fireStation) throws Exception {

		if (fireStation == null || StringUtils.isEmpty(fireStation.getName())
				|| StringUtils.isEmpty(fireStation.getAddress()) 
//				|| StringUtils.isEmpty(fireStation.getPosition3d())
				|| StringUtils.isEmpty(fireStation.getCode()))
			throw new Exception("数据校验失败.");
		ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
		fireStation.setCreateBy("0");
		fireStation.setCreateDate(new Date());
		fireStation.setOrgCode(compCode);
		return CommonResponseUtil.success(iFireStationService.saveAndUpd(fireStation, file));
	}
	
	/**
	 * 查询消防小室关联设备信息
	 * @param id
	 * @return
	 */
	@ApiOperation(httpMethod = "GET", value = "分页查询已经绑定的消防设备列表", notes = "分页查询已经绑定的消防设备列表")
	@RequestMapping(value = "/fireEquipments/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse queryForEuqimentListById(@PathVariable Long id) {
		return CommonResponseUtil.success(iFireStationService.queryForEuqimentListById(id));
	}

}
