package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IRiskLevelService;
import com.yeejoin.amos.fas.business.util.CommonPageParamUtil;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.common.enums.ManageLevelEum;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.RiskLevel;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/riskLevel")
@Api("风险等级api")
public class RiskLevelController extends BaseController {

    private final Logger log = LoggerFactory.getLogger(RiskLevelController.class);

    @Autowired
    IRiskLevelService iRiskLevelService;

    /**
     * 风险等级分页查询
     */
    @ApiOperation(httpMethod = "POST", value = "风险等级查询", notes = "风险等级查询")
    @RequestMapping(value = "/pagelist", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRiskLevelPage(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                             @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> list = iRiskLevelService.queryRiskLevelPage(getToken(),getProduct(),getAppKey(),param);
        return CommonResponseUtil.success(list);
    }


    /**
     * 风险等级查询，不分页
     */
    @ApiOperation(httpMethod = "GET", value = "风险等级查询不分页", notes = "风险等级查询不分页")
    @RequestMapping(value = "/all-list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRiskLevel(@ApiParam(value = "模型id") @RequestParam(required = false) Long id) {
        List<RiskLevel> list = iRiskLevelService.queryRiskLevel(id);
        return CommonResponseUtil.success(list);
    }

    /**
     * 风险等级新增及维护
     */
    @ApiOperation(httpMethod = "POST", value = "风险等级新增及维护", notes = "风险等级新增及维护")
    @RequestMapping(value = "/editRiskLevel", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse checkPlanAdd(@ApiParam(value = "风险等级对象", required = true) @RequestBody RiskLevel param) {
        try {
            Long count = iRiskLevelService.countRepeatData(param);
            if (count > 0) {
                return CommonResponseUtil.failure("风险等级重复：" + param.getLevel() + "级");
            }
            AgencyUserModel user = getUserInfo();
			ReginParams reginParams =getSelectedOrgInfo();
			String compCode=getOrgCode(reginParams);
            HashMap<String, Object> map = new HashMap<>();
            map.put("org_code", compCode);
            map.put("user_id", user.getUserId());
            map.put("param", param);
            iRiskLevelService.editRiskLevel(map);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险等级编辑失败：" + e.getMessage());
        }
    }

    /**
     * 风险等级删除（支持批量）
     */
    @ApiOperation(httpMethod = "POST", value = "删除风险等级", notes = "删除风险等级")
    @RequestMapping(value = "/deleteRiskLevelById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deletePlanById(@ApiParam(value = "风险等级ID", required = true) @RequestBody Long[] param) {
        try {
            iRiskLevelService.detRiskLevel(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage() + ",风险等级删除失败");
        }
    }

    @ApiOperation(value = "风险管控级别查询",notes = "风险管控级别查询")
    @GetMapping(value = "/manageLevel/list")
    public CommonResponse getManageLevelEumList(){
        return CommonResponseUtil.success(ManageLevelEum.getManageLevelEumList());
    }

}
