package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.ContingencyOriginalMapper;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyOriginalDataDao;
import com.yeejoin.amos.fas.business.service.intfc.IContingencyOriginalDataService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.ContingencyOriginalData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class ContingencyOriginalServiceImpl /*extends GenericManagerImpl<ContingencyOriginalData, String>*/ implements IContingencyOriginalDataService
{
	    @Autowired
	    private IContingencyOriginalDataDao repository;

	@Autowired
	private ContingencyOriginalMapper contingencyOriginalMapper;

	/*public ContingencyOriginalServiceImpl(IContingencyOriginalDataDao repository)
	{
		super(repository);
		this.repository = repository;
	}*/




	public ContingencyOriginalData queryByBatchNo(String batchNo)
	{
		return repository.findByBatchNo(batchNo);
	}


	public List<ContingencyOriginalData> queryForContingencyRecord(String contingencyName , String equipmentId, Date createTime)
	{
		List<ContingencyOriginalData> returnList = new ArrayList<>();


		return returnList;
	}


	public Page queryForPage(String  contingencyName, String equipmentId, String  createTime, CommonPageable pageable)
	{
		Long total = contingencyOriginalMapper.queryCountForPage(equipmentId,createTime);
		List<Map> content = contingencyOriginalMapper.queryForPage(equipmentId,createTime,pageable.getOffset(),pageable.getPageSize());
		Page result = new PageImpl(content,pageable,total);
		return result;
	}



}
