package com.yeejoin.amos.fas.business.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipPointMapper;
import com.yeejoin.amos.fas.business.dao.mapper.WaterResourceMapper;
import com.yeejoin.amos.fas.business.entity.mybatis.FireEquipmentEntity;
import com.yeejoin.amos.fas.business.entity.mybatis.FireEquipmentPointEntity;
import com.yeejoin.amos.fas.business.param.FireEquipmentParam;
import com.yeejoin.amos.fas.business.param.FireEquipmentPointParam;
import com.yeejoin.amos.fas.business.param.WaterResourceParam;
import com.yeejoin.amos.fas.business.service.intfc.IExcelService;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipPontService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.dao.entity.WaterResource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service("excelService")
public class ExcelServiceImpl implements IExcelService {

    @Autowired
    private FireEquipMapper fireEquipMapper;

    @Autowired
    private FireEquipPointMapper fireEquipPointMapper;

    @Autowired
    private IFireEquipPontService fireEquipPointService;

    @Autowired
    private WaterResourceMapper waterResourceMapper;

    @Transactional
    @Override
    public void importFireEquipment(List<FireEquipmentParam> list) {
        List<String> codeList = Lists.transform(list, FireEquipmentParam::getCode);
        Set<String> codeSet = Sets.newHashSet(codeList);
        List<FireEquipmentEntity> equipments = fireEquipMapper.listByCodes(codeSet);
        Map<String, FireEquipmentEntity> equipmentMap = Maps.uniqueIndex(equipments, FireEquipmentEntity::getCode);
        List<FireEquipmentParam> saveList = Lists.newArrayList();
        List<FireEquipmentParam> updateList = Lists.newArrayList();
        list.forEach(fireEquipment -> {
            String code = fireEquipment.getCode();
            FireEquipmentEntity fireEquipmentEntity = equipmentMap.get(code);
            if (fireEquipmentEntity == null) {
                saveList.add(fireEquipment);
            } else {
                fireEquipment.setId(fireEquipmentEntity.getId());
                updateList.add(fireEquipment);
            }
        });
        if (!CollectionUtils.isEmpty(saveList)) {
            fireEquipMapper.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            fireEquipMapper.updateBatch(updateList);
        }
    }

    @Transactional
    @Override
    public void importFireEquipmentPoint(List<FireEquipmentPointParam> list) {
        Set<String> equipmentCodeSet = Sets.newHashSet(Lists.transform(list, FireEquipmentPointParam::getFireEquipmentCode));
        List<FireEquipmentEntity> equipments = fireEquipMapper.listByCodes(equipmentCodeSet);
        Map<String, FireEquipmentEntity> equipmentMap = Maps.uniqueIndex(equipments, FireEquipmentEntity::getCode);
        Set<String> pointCodeSet = Sets.newHashSet(Lists.transform(list, FireEquipmentPointParam::getCode));
        List<FireEquipmentPointEntity> points = fireEquipPointMapper.listByCodes(pointCodeSet);
        Map<String, FireEquipmentPointEntity> pointMap = Maps.uniqueIndex(points, FireEquipmentPointEntity::getCode);
        List<FireEquipmentPointParam> saveList = Lists.newArrayList();
        List<FireEquipmentPointParam> updateList = Lists.newArrayList();
        list.forEach(point -> {
            String code = point.getCode();
            String equipmentCode = point.getFireEquipmentCode();
            FireEquipmentPointEntity pointEntity = pointMap.get(code);
            FireEquipmentEntity fireEquipmentEntity = equipmentMap.get(equipmentCode);
            if (fireEquipmentEntity != null) {
                point.setFireEquipmentId(fireEquipmentEntity.getId());
            } else {
                point.setFireEquipmentId(0L);
            }
            if (pointEntity == null) {
                saveList.add(point);
            } else {
                point.setId(pointEntity.getId());
                updateList.add(point);
            }
        });
        if (!CollectionUtils.isEmpty(saveList)) {
            fireEquipPointMapper.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            fireEquipPointMapper.updateBatch(updateList);
        }
    }

    @Override
    public List<?> exportPointData(Map<String, Object> paramsMap) {
        CommonResponse result = fireEquipPointService.queryByMap(paramsMap);
        List<FireEquipmentPointEntity> fireEquipmentPoints = ((PageImpl) result.getDataList()).getContent();
        List<FireEquipmentPointParam> pointExcelList = new ArrayList<>();
        for (FireEquipmentPointEntity point : fireEquipmentPoints) {
            FireEquipmentPointParam pointParam = new FireEquipmentPointParam();
            BeanUtils.copyProperties(point, pointParam);
            pointExcelList.add(pointParam);
        }
        return  pointExcelList;
    }

    @Override
    public void importWaterResource(List<WaterResourceParam> list) {
        List<String> codeList = Lists.transform(list, WaterResourceParam::getCode);
        Set<String> codeSet = Sets.newHashSet(codeList);
        List<WaterResource> waterResources = waterResourceMapper.listByCodes(codeSet);
        Map<String, WaterResource> waterResourceMap = Maps.uniqueIndex(waterResources, WaterResource::getCode);
        List<WaterResourceParam> saveList = Lists.newArrayList();
        List<WaterResourceParam> updateList = Lists.newArrayList();
        list.forEach(warerRes -> {
            String code = warerRes.getCode();
            WaterResource waterResource = waterResourceMap.get(code);
            if (waterResource == null) {
                saveList.add(warerRes);
            } else {
                warerRes.setId(waterResource.getId());
                updateList.add(warerRes);
            }
        });
        if (!CollectionUtils.isEmpty(saveList)) {
            waterResourceMapper.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            waterResourceMapper.updateBatch(updateList);
        }
    }
}
