package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.util.Date;


/**
 * The persistent class for the alarm database table.
 */
@Entity
@Table(name = "f_alarm")
@NamedQuery(name = "Alarm.findAll", query = "SELECT a FROM Alarm a")
public class Alarm extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "alarm_time")
    private Date alarmTime;

    /**
     * 指标或者报警信息
     */
    @Lob
    private String metric;


    private String code;

    /**
     * 报警类别
     */
    @Column(name = "alarm_type")
    private String alarmType;

    @Column(name = "fire_equipment_id")
    private Long fireEquipmentId;

    @Column(name = "org_code")
    private String orgCode;

    private String remark;

    public Alarm() {
    }

    public Date getAlarmTime() {
        return this.alarmTime;
    }

    public void setAlarmTime(Date alarmTime) {
        this.alarmTime = alarmTime;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getFireEquipmentId() {
        return this.fireEquipmentId;
    }

    public void setFireEquipmentId(Long fireEquipmentId) {
        this.fireEquipmentId = fireEquipmentId;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getMetric() {
        return metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public String getAlarmType() {
        return alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

}