package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.*;


/**
 * The persistent class for the equipment database table.
 * 
 */
@Entity
@Table(name="f_equipment")
@NamedQuery(name="Equipment.findAll", query="SELECT e FROM Equipment e")
public class Equipment extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	private String address;

	private String building;

	/**
	 * 所属风险区域id
	 */
	@Column(name="risk_source_id")
	private Long riskSourceId;
	/**
	 * 3维坐标
	 */
	private String position3d;
	
	/**
	 * 3维楼层
	 */
	private String floor3d;
	
	/**
	 * 预案配置
	 */
	@Column(name="reserve_plan")
	private String reservePlan;

	/**
	 * 是否室内 0-否 1-是
	 */
	@Column(name="is_indoor")
	private Boolean isIndoor;

	@Column(name="charge_dept_id")
	private int chargeDeptId;

	@Column(name="charge_user_id")
	private int chargeUserId;

	private String code;

	@Column(name="fire_truck_route")
	private String fireTruckRoute;


	public String getFireTruckRoute() {
		return fireTruckRoute;
	}

	public void setFireTruckRoute(String fireTruckRoute) {
		this.fireTruckRoute = fireTruckRoute;
	}

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	private String room;
	
	/**
	 * 关联消防小室id
	 */
	@Column(name="fire_station_id")
	private Long fireStationId;

	

	@Column(name="create_by")
	private String createBy;

	private String name;

	@Column(name="org_code")
	private String orgCode;

	private String remark;

	/**
	 * ue4位置
	 */
	@Lob
	private String ue4Location;

	/**
	 * ue4旋转
	 */
	@Lob
	private String ue4Rotation;

	public Equipment() {
	}

	public String getAddress() {
		return this.address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getBuilding() {
		return this.building;
	}

	public void setBuilding(String building) {
		this.building = building;
	}

	public Long getRiskSourceId() {
		return riskSourceId;
	}

	public void setRiskSourceId(Long riskSourceId) {
		this.riskSourceId = riskSourceId;
	}

	public int getChargeDeptId() {
		return this.chargeDeptId;
	}

	public void setChargeDeptId(int chargeDeptId) {
		this.chargeDeptId = chargeDeptId;
	}

	public int getChargeUserId() {
		return this.chargeUserId;
	}

	public void setChargeUserId(int chargeUserId) {
		this.chargeUserId = chargeUserId;
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	public Long getFireStationId() {
		return fireStationId;
	}

	public void setFireStationId(Long fireStationId) {
		this.fireStationId = fireStationId;
	}
	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}


	public String getRoom() {
		return room;
	}

	public void setRoom(String room) {
		this.room = room;
	}
	
	public String getReservePlan() {
		return reservePlan;
	}

	public void setReservePlan(String reservePlan) {
		this.reservePlan = reservePlan;
	}

	@Column(name = "ue4_location")
	public String getUe4Location() {
		return ue4Location;
	}

	public void setUe4Location(String ue4Location) {
		this.ue4Location = ue4Location;
	}

	@Column(name = "ue4_rotation")
	public String getUe4Rotation() {
		return ue4Rotation;
	}

	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = ue4Rotation;
	}
}