package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;


/**
 * 拓扑图连线
 *
 */
@Entity
@Table(name = "f_topography_line")
public class TopographyLine extends BusinessEntity{

	/**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;
	/**
     * 
     */
    @Column(name = "`from`", columnDefinition = "varchar(32) COMMENT '起点'")
    private String from;
    /**
     * 
     */
    @Column(name = "`to`", columnDefinition = "varchar(32) COMMENT '终点'")
    private String to;
    /**
     * 
     */
    @Column(name = "app_id", columnDefinition = "varchar(32) COMMENT 'appid'")
    private String appId;
    /**
     * 
     */
    @Column(name = "clickable", columnDefinition = "bit COMMENT '可点击'")
    private Boolean clickable;
    /**
     * 
     */
    @Column(name = "has_arrow", columnDefinition = "bit COMMENT '有箭头'")
    private Boolean hasArrow;
    /**
     * 
     */
    @Column(name = "is_dash", columnDefinition = "bit COMMENT '是虚线'")
    private Boolean isDash;
    /**
     * 
     */
    @Column(name = "line_color", columnDefinition = "int COMMENT '线颜色'")
    private Integer lineColor;
    
    @Column(name = "from_port", columnDefinition = "varchar(32) COMMENT '起点'")
    private String fromPort;
    
    @Column(name = "to_port", columnDefinition = "varchar(32) COMMENT '终点'")
    private String toPort;
    
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getFrom() {
		return from;
	}
	public void setFrom(String from) {
		this.from = from;
	}
	public String getTo() {
		return to;
	}
	public void setTo(String to) {
		this.to = to;
	}
	public String getAppId() {
		return appId;
	}
	public void setAppId(String appId) {
		this.appId = appId;
	}
	public Boolean getClickable() {
		return clickable;
	}
	public void setClickable(Boolean clickable) {
		this.clickable = clickable;
	}
	public Boolean getHasArrow() {
		return hasArrow;
	}
	public void setHasArrow(Boolean hasArrow) {
		this.hasArrow = hasArrow;
	}
	public Boolean getIsDash() {
		return isDash;
	}
	public void setIsDash(Boolean isDash) {
		this.isDash = isDash;
	}
	public Integer getLineColor() {
		return lineColor;
	}
	public void setLineColor(Integer lineColor) {
		this.lineColor = lineColor;
	}
	public String getFromPort() {
		return fromPort;
	}
	public void setFromPort(String fromPort) {
		this.fromPort = fromPort;
	}
	public String getToPort() {
		return toPort;
	}
	public void setToPort(String toPort) {
		this.toPort = toPort;
	}
    
	
}
