package com.yeejoin.amos.fas.business.controller;


import com.yeejoin.amos.fas.business.service.intfc.IBizMessageService;
import com.yeejoin.amos.fas.business.service.intfc.IWaterResourceService;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.WaterResource;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

@RestController
@RequestMapping(value = "/api/message")
@Api(tags="水资源API")
public class BizMessageController extends BaseController{


    @Autowired
    IBizMessageService iBizMessageService;

    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET",value = "分页查询消息", notes = "分页查询消息")
    @RequestMapping(value = "/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse forPage(
            @ApiParam(value = "日期") @RequestParam(required = false)String  time,
            @ApiParam(value = "类型") @RequestParam(required = false)String  type,
            @ApiParam(value = "标题") @RequestParam(required = false)String  title,
                                    @RequestParam int pageNumber,
                                    @RequestParam  int pageSize
    ) {

		ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
        CommonPageable commonPageable = new CommonPageable(pageNumber,pageSize);
        return CommonResponseUtil.success(iBizMessageService.queryForPage(StringUtils.trimToNull(time), StringUtils.trimToNull(type), StringUtils.trimToNull(title),StringUtils.trimToNull( compCode), commonPageable));
    }

}
