package com.yeejoin.amos.fas.business.controller;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.fas.business.service.intfc.ITopographyLineService;
import com.yeejoin.amos.fas.business.service.intfc.ITopographyNodeDetailService;
import com.yeejoin.amos.fas.business.service.intfc.ITopographyNodeService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.TopographyLine;
import com.yeejoin.amos.fas.dao.entity.TopographyNode;
import com.yeejoin.amos.fas.dao.entity.TopographyNodeDetail;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/Topography")
@Api(tags="Topography API")
public class TopographyController {
	
	@Autowired
	private ITopographyNodeService nodeService;
	
	@Autowired
	private ITopographyLineService lineService;
	
	@ApiOperation(value = "根据appID查询节点及线", notes = "根据appID查询节点及线")
    @GetMapping(value = "/{appId}")
    public CommonResponse getTextPlanById(@PathVariable(value = "appId") String appId) {
		List<TopographyNode> nodes = nodeService.getNodesByAppId(appId);
    	List<TopographyLine> links = lineService.getLinksByAppId(appId);
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", nodes);
    	results.put("linkData", links);
    	return CommonResponseUtil.success(results);
    }
	
	/**
     * 保存拓扑图
     *
     * @return 
     */
    @PostMapping(value = "/updateTopo", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "保存拓扑图", notes = "保存拓扑图")
    public CommonResponse savedonghuanNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topographyParam) {
    	String appId = topographyParam.getString("appId");
    	//节点
    	JSONArray nodes = topographyParam.getJSONArray("nodeData");
    	List<TopographyNode> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNode.class);
    	HashMap<String, String> convertKeyMap = new HashMap<>();
    	int curSize = nodeService.queryMaxKeyByAppId(appId);
    	for(TopographyNode e:nodeData){
    		if(Integer.valueOf(e.getKey()) < 0) {
    			curSize = curSize + 1 ;
    			String newKey = String.format("%05d", curSize);
    			convertKeyMap.put(e.getKey(), newKey);
    			e.setKey(newKey);
    			e.setAppId(appId);
    			e.setGroup("");
    		}
    	};
    	//线
    	JSONArray links = topographyParam.getJSONArray("linkData");
    	List<TopographyLine> lineData = JSON.parseArray(JSON.toJSONString(links), TopographyLine.class);
    	lineData.forEach(l -> {
    		if(Integer.parseInt(l.getFrom()) < 0) {
    			l.setFrom(convertKeyMap.get(l.getFrom()));
    		}
    		if(Integer.parseInt(l.getTo()) < 0) {
    			l.setTo(convertKeyMap.get(l.getTo()));
    		}
    		if(l.getAppId() == null) {
    			l.setAppId(appId);
    		}
    	});
    	
    	nodeService.saveNodes(nodeData);
    	lineService.saveLines(lineData);
    	
    	//节点详情
    	JSONObject nodeDetailJson = topographyParam.getJSONObject("nodeDetail");
    	if(nodeDetailJson != null) {
    		TopographyNodeDetail nodeDetail = JSON.parseObject(JSON.toJSONString(nodeDetailJson), TopographyNodeDetail.class);
    		String nodekey = nodeDetail.getNodekey();
    		if(nodekey != null && Integer.parseInt(nodekey) < 0) {
    			TopographyNode node = nodeService.queryByKeyAndAppId(convertKeyMap.get(nodekey),appId);
    			nodeDetail.setNodeid(node.getId());
    		}
    		nodeService.saveNodeDetail(nodeDetail);
    	}

    	List<TopographyNode> newNodes = nodeService.getNodesByAppId(appId);
    	List<TopographyLine> newLinks = lineService.getLinksByAppId(appId);
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", newNodes);
    	results.put("linkData", newLinks);
    	return CommonResponseUtil.success(results);
    }

	@ApiOperation(value = "根据nodeid查询节点详情", notes = "根据nodeid查询节点详情")
    @GetMapping(value = "/detail/{nodeid}")
    public CommonResponse getNodeDatilByNodeId(@PathVariable(value = "nodeid") String nodeid) {
    	TopographyNodeDetail detail = nodeService.getNodeDetailById(nodeid);
    	if(detail != null) {
//    		String items = detail.getNodeDetail();
    		return CommonResponseUtil.success(detail);
    	}
    	return CommonResponseUtil.success();
    }
    
    @ApiOperation(value = "保存节点详情", notes = "保存节点详情")
    @PostMapping(value = "/detail")
    public CommonResponse saveNodeDatil(@RequestBody TopographyNodeDetail nodeDetail) {
    	if(nodeDetail.getNodeid() !=null) {
    		TopographyNodeDetail saveNodeDetail = nodeService.saveNodeDetail(nodeDetail);
    		return CommonResponseUtil.success(saveNodeDetail);
    	}else {
    		return CommonResponseUtil.failure("请选择节点！");
    	}
    }
    
    @ApiOperation(value = "删除节点/线", notes = "删除节点/线")
    @DeleteMapping(value = "/{type}/{id}")
    public CommonResponse deleteTopo(@PathVariable("type") String type,@PathVariable("id") String id) {
    	if("Link".equals(type)) {
    		lineService.deleteLine(id);
    	}else {
    		nodeService.deleteNode(id);
    	}
		return CommonResponseUtil.success();
    }
    
}
