package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.bo.BindPointBo;
import com.yeejoin.amos.fas.business.bo.BindRegionBo;
import com.yeejoin.amos.fas.business.service.intfc.IView3dService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yeejoin.amos.fas.business.service.intfc.IRiskSourceService;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.common.enums.ResourceTypeDefEnum;

import io.swagger.annotations.Api;
import java.util.List;

@RestController
@RequestMapping("/api/view3d")
@Api(tags="全景监控api")
public class View3dController extends BaseController {
	@Autowired
	private IRiskSourceService riskSourceService;
	@Autowired
	private IView3dService view3dService;

	@ApiOperation(httpMethod = "POST", value = "点3d坐标设置", notes = "按照点类型3d坐标设置" )
	@PostMapping(value = "/point/bind",produces = "application/json;charset=UTF-8")
	public CommonResponse setPoint3dPosition(@ApiParam(name = "参数",required = true) @RequestBody List<BindPointBo> pointBoList){
		return view3dService.setPoint3dPosition(pointBoList);
	}
	
	@ApiOperation(value = "区域树查询", notes = "区域树查询")
    @GetMapping(value = "/region/tree")
    public CommonResponse getRegionTree() {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		orgCode = "10";
        return CommonResponseUtil.success(riskSourceService.findRegionTree(orgCode));
    }
	
	@ApiOperation(value = "区域详情查询", notes = "区域详情查询")
    @GetMapping(value = "region/detail/{riskSourceId}")
    public CommonResponse getRegionDetail(@PathVariable("riskSourceId") Long riskSourceId) {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		orgCode = "10";
        return CommonResponseUtil.success(riskSourceService.findRegionById(riskSourceId,orgCode));
    }
	
	@ApiOperation(value = "区域绑定", notes = "区域绑定")
	@PostMapping(value="region/bind")
	public CommonResponse batchSaveRegionUe4(@ApiParam(name = "区域参数列表",required = true) @RequestBody List<BindRegionBo> regionBoList) {
		try {			
			riskSourceService.batchSaveRegionUe4(regionBoList);
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
        return CommonResponseUtil.success();
    }
	
	@ApiOperation(value = "点类型查询", notes = "点类型查询")
    @GetMapping(value = "point/type")
    public CommonResponse getPointType() {
        return CommonResponseUtil.success(view3dService.getPointType());
    }
	
	@ApiOperation(value = "按照分类查询点树", notes = "按照分类查询点树")
    @GetMapping(value = "point/tree/{type}")
    public CommonResponse getPointTreeByType(@PathVariable(value="type") String type) {
		if(ResourceTypeDefEnum.containsTypeCode(type)) {		
			ReginParams reginParams =getSelectedOrgInfo();
			String orgCode = this.getOrgCode(reginParams);
			orgCode = "10";
			return CommonResponseUtil.success(view3dService.getPointTreeByType(type,orgCode));
		}
		return CommonResponseUtil.failure(type + " 类型不存在");
    }
	
	@ApiOperation(value = "按照不同类型查询点详情", notes = "按照不同类型查询点详情")
    @GetMapping(value = "point/detail")
    public CommonResponse getPointDetail(String type,Long pointId) {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getPointDetailByTypeAndId(type,pointId,orgCode));
    }
	
	@ApiOperation(value = "一周安全指数趋势查询", notes = "一周安全指数趋势查询")
    @GetMapping(value = "safetyIndex/week")
    public CommonResponse safetyIndexWeek(String type,Long pointId) {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSafetyIndexWeek(orgCode));
    }

    @ApiOperation(value = "今日安全指数查询",notes = "按照日期查询安全指数及分类数据")
	@GetMapping(value = "/statistics/safetyIndex")
	public CommonResponse getSafetyIndexInfoByDate(@RequestParam(name = "date",required = false) String date){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSafetyIndexInfoByDate(orgCode,date));
	}

	@ApiOperation(value = "今日安全指数详情",notes = "今日安全指数详情")
	@GetMapping(value = "/safetyIndex/detail/{type}")
	public CommonResponse getSafetyIndexDetail(@ApiParam(value = "risk-风险异常,check-巡检异常,equip-设备故障") @PathVariable String type){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSafetyIndexDetail(type,orgCode));
	}

	@ApiOperation(value = "查询上线的年日",notes = "查询上线年日：10年101")
	@GetMapping(value = "/online/date")
	public CommonResponse getSystemOnlineDate(){
		//TODO: 多机构暂时不支持
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSystemOnlineDate(orgCode));
	}

}
