package com.yeejoin.amos.fas.business.dao.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.fas.business.bo.CheckErrorBo;
import com.yeejoin.amos.fas.business.bo.RiskPointRpnChangeBo;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;

public interface View3dMapper extends BaseMapper{
	/**
	 * 按类型查询树
	 * @param type
	 * @param orgCode
	 * @return
	 */
	List<RegionTreeResponse> getPointTreeByType(@Param("type")String type,@Param("orgCode")String orgCode);
	
	/**
	 * 获取点详情
	 * @param type
	 * @param pointId
	 * @param orgCode
	 * @return
	 */
	HashMap<String, Object> getPointDetailByTypeAndId(@Param("type")String type, @Param("pointId")Long pointId,@Param("orgCode")String orgCode);

	/**
	 * 统计风险上升异常数量（风险点）-日期+机构
	 * @param param:{type，orgCode}
	 * @return Long
	 */
	Long countUpperRiskPoint(Map<String,Object> param);

	/**
	 * 统计巡检异常数量（不合格、漏检）-日期+机构
	 * @param param{}
	 * @return Long
	 */
	Long countCheckException(Map<String,Object> param);

	/**
	 * 今日安全指数详情
	 * @param params orgCode,date
	 * @return list
	 */
    List<RiskPointRpnChangeBo> getAllErrorRiskPoint(Map<String, Object> params);
    
    /**
     * 一周安全指数趋势查询
     * @param orgCode
     * @return
     */
	HashMap<String, Object> getSafetyIndexWeek(String orgCode);

    /**
     * 今日安全指数详情
     * @param params orgCode,date
     * @return list
     */
	List<CheckErrorBo> getAllErrorPatrolPoint(Map<String, Object> params);

}
