package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.EquipmentFireEquipment;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository("iEquipmentFireEquipmentDao")
public interface IEquipmentFireEquipmentDao extends BaseDao<EquipmentFireEquipment, Long> {

    /**
     * 根据设备ID和配套装备ID查询
     *
     * @param equipmentId
     * @param fireEquipmentId
     * @return
     */
    @Query(value = "select count(1) from f_equipment_fire_equipment WHERE equipment_id = ?1 and fire_equipment_id = ?2", nativeQuery = true)
    int findByEqmtIdAndFireEqmtId(Long equipmentId, Long fireEquipmentId);

}
