package com.yeejoin.amos.fas.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.fas.dao.entity.TopographyNode;

@Repository("iTopographyNodeDao")
public interface ITopographyNodeDao extends BaseDao<TopographyNode, Long> {

	List<TopographyNode> findByAppId(String appId);
	
	@Query(value = "select * from f_topography_node " + " where id in (?1)",nativeQuery = true)
	List<TopographyNode> findAllByIds(@Param("ids") List<String> ids);

	TopographyNode findById(String id);

	TopographyNode findByKeyAndAppId(String nodekey, String appId);

	@Query(value = "select max(`key`) from f_topography_node where app_id = (?1)",nativeQuery = true)
	Integer queryMaxKeyByAppId(String appId);
	
}
