package com.yeejoin.amos.fas.business.feign;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.fas.business.vo.Toke;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.privilege.model.IdPasswordAuthModel;
import com.yeejoin.amos.feign.privilege.model.PermissionModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service("remoteSecurityService")
public class RemoteSecurityService {
	    @Value("${security.password}")
	    private String password;
	    @Value("${security.loginId}")
	    private String loginId;
	    @Value("${security.productWeb}")
	    private String productWeb;
	    @Value("${security.appKeyWeb}")
	    private String appKeyWeb;
	   

  //根据公司名称获取公司人
    public List<CompanyModel> listCompanyTree(String toke,String product,String appKey,String companyName) {
       // CommonResponse commonResponse = iAmosSecurityServer.listCompanyTree();
        //return handleArray(commonResponse, CompanyBo.class);
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<CompanyModel> userModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.companyClient.queryAgencyTree(companyName);
	    	 userModel = (List<CompanyModel>) feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return userModel;
    }

   
    
    //部门id获取部门信息
    public DepartmentModel getDepartmentByDeptId(String toke,String product,String appKey,String deparmentId) {
        if (deparmentId == null || deparmentId.equals("")) {
            return null;
        }
       // CommonResponse commonResponse = iAmosSecurityServer.getDepartmentByDeptId(deparmentId);
       // return handleObj(commonResponse, DepartmentBo.class);
        
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	DepartmentModel departmentModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.departmentClient.seleteOne(Long.valueOf(deparmentId));
			departmentModel = (DepartmentModel) feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return departmentModel;
    }
   //查询指定部门数
    public List<DepartmentModel> listDepartmentsByCompanyId(String toke,String product,String appKey,String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	 List<DepartmentModel> departmentModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.departmentClient.queryDeptTree(null,Long.valueOf(companyId));
			departmentModel = ( List<DepartmentModel>) feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return departmentModel;
        
        //CommonResponse commonResponse = iAmosSecurityServer.listDepartmentsByCompanyId(companyId);
        //return handleArray(commonResponse, DepartmentBo.class);
    }
    // * 根据公司id查询机构用户
    public List<AgencyUserModel> listUserByCompanyId(String toke,String product,String appKey,String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	 List<AgencyUserModel> AgencyUserModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.agencyUserClient.queryByCompanyId(Long.valueOf(companyId),null);
			AgencyUserModel = ( List<AgencyUserModel>) feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return AgencyUserModel;
        
        //CommonResponse commonResponse = iAmosSecurityServer.listUserByCompanyId(companyId);
        //return handleArray(commonResponse, UserModel.class);
    }
    
    // * 根据公司RoleIds
    public List<AgencyUserModel> getUserByRoleIds(String toke,String product,String appKey,String RoleIds) {
    	  if (RoleIds == null || RoleIds.equals("")) {
              return null;
          }
          
          RequestContext.setToken(toke);
      	RequestContext.setProduct(product);
      	RequestContext.setAppKey(appKey);
      	List<AgencyUserModel> agencyUserModel=null;
      	FeignClientResult feignClientResult;
  		try {
  			feignClientResult = Privilege.agencyUserClient.queryByRoleId(RoleIds);
  			agencyUserModel = (List<AgencyUserModel>)feignClientResult.getResult();

  		} catch (InnerInvokException e) {
  			e.printStackTrace();
  		}
          return agencyUserModel;
    }
    
	public Toke come() {
    	IdPasswordAuthModel  dPasswordAuthModel=new IdPasswordAuthModel();
    	dPasswordAuthModel.setLoginId(loginId);
    	dPasswordAuthModel.setPassword(password);
    	Map map=null;
    	FeignClientResult feignClientResult;
    	Toke oked=new Toke();
		try {
			RequestContext.setProduct(productWeb);
			feignClientResult = Privilege.authClient.idpassword(dPasswordAuthModel);
			map = (Map) feignClientResult.getResult();
            if(map!=null){          
            oked.setToke(map.get("token").toString());
            oked.setProduct(productWeb);
            oked.setAppKey(appKeyWeb);            
            }	    	 
		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return oked;
    }
    
    
    
    
    
    
    

/*    public List<UserModel> listUserByRoleIds(String roleIds) {
        CommonResponse commonResponse = iAmosSecurityServer.listUserByRoleIds(roleIds);
        return handleArray(commonResponse, UserModel.class);
    }*/
    //用户id批量获取用户信息
    public List<AgencyUserModel> listUserByUserIds(String toke,String product,String appKey,String userIds) {
       // CommonResponse commonResponse = iAmosSecurityServer.listUserByUserIds(userIds);
        //return handleArray(commonResponse, UserModel.class);
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<AgencyUserModel> agencyUserModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.agencyUserClient.queryByIds(userIds);
			agencyUserModel = (List<AgencyUserModel> ) feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return agencyUserModel;
    }
   //用户id获取用户信息
    public AgencyUserModel getUserById(String toke,String product,String appKey,String  userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
       // CommonResponse commonResponse = iAmosSecurityServer.getUserById(userId);
       // return handleObj(commonResponse, UserModel.class);
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	AgencyUserModel agencyUserModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.agencyUserClient.queryByUserId(userId);
			agencyUserModel = (AgencyUserModel)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return agencyUserModel;
    }
    //根据orgCode查询机构用户
    public List<AgencyUserModel> listUserByOrgCode(String toke,String product,String appKey,String orgCode) {
        if (orgCode == null || orgCode.equals("")) {
            return null;
        }
        
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<AgencyUserModel> agencyUserModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.agencyUserClient.queryByOrgCode(orgCode);
			agencyUserModel = (List<AgencyUserModel>)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return agencyUserModel;
        
        
        
       // CommonResponse commonResponse = iAmosSecurityServer.listUserByOrgCode(orgCode);
       // return handleArray(commonResponse, UserModel.class);
    }
   
    
    
    
    
    //根据orgCode查询机构
    public Map<String, Object>  listByOrgCode(String toke,String product,String appKey,String orgCode) {
        if (orgCode == null || orgCode.equals("")) {
            return null;
        }
        
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	Map<String, Object> agencyUserModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.companyClient.queryByOrgcode(orgCode);
			agencyUserModel = (Map<String, Object>) feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return agencyUserModel;
        
        
        
       // CommonResponse commonResponse = iAmosSecurityServer.listUserByOrgCode(orgCode);
       // return handleArray(commonResponse, UserModel.class);
    }
   
    
    
    
    
    
    
    
    
    
    
    
    // 根据部门id查询机构用户
    public List<AgencyUserModel> listUserByDepartmentId(String toke,String product,String appKey,String departmentId) {
        if (departmentId == null || departmentId.equals("")) {
            return null;
        }
        
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<AgencyUserModel> agencyUserModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.agencyUserClient.queryByDepartmentId(Long.valueOf(departmentId),null);
			agencyUserModel = (List<AgencyUserModel>)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return agencyUserModel;
        
        
        
       // CommonResponse commonResponse = iAmosSecurityServer.listUserByDepartmentId(departmentId);
       // return handleArray(commonResponse, UserModel.class);
    }
    
/*    public UserModel getUserByToken() {
        CommonResponse commonResponse = iAmosSecurityServer.getUserByToken();
        return handleObj(commonResponse, UserModel.class);
    }*/
    //* 获取子公司信息树结构
    public List<CompanyModel> getCompanyTreeByCompanyId(String toke,String product,String appKey,String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<CompanyModel> companyModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.companyClient.querySubAgencyTree(Long.valueOf(companyId));
			companyModel = (List<CompanyModel>)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return companyModel;
        
        
        
        
        //CommonResponse commonResponse = iAmosSecurityServer.getCompanyTreeByCompanyId(companyId);
        //return handleArray(commonResponse, CompanyBo.class);
    }
   //查询指定公司的部门树
    public List<DepartmentModel> getDepartmentTreeByCompanyId(String toke,String product,String appKey,String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<DepartmentModel> departmentModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.departmentClient.queryDeptTree(null,Long.valueOf(companyId));
			departmentModel = (List<DepartmentModel>)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return departmentModel;
       // CommonResponse commonResponse = iAmosSecurityServer.getDepartmentTreeByCompanyId(companyId);
       // return handleArray(commonResponse, DepartmentBo.class);
    }
   //根据id批量获取部门信息
    public List<LinkedHashMap> listDepartmentByDeptIds(String toke,String product,String appKey,String departmentIds) {
        
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<LinkedHashMap> departmentModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.departmentClient.queryDeptByIds(departmentIds);
			departmentModel = (List<LinkedHashMap>)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return departmentModel;
    	
    	
    	
    	
    	
    	//CommonResponse commonResponse = iAmosSecurityServer.listDepartmentByDeptIds(departmentIds);
        //return handleArray(commonResponse, DepartmentBo.class);
    }

    private <T> List<T> handleArray(CommonResponse commonResponse, Class<T> t) {
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONArray.parseArray(jsonStr, t);
        }
        return null;
    }

    private <T> T handleObj(CommonResponse commonResponse, Class<T> t) {
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONObject.parseObject(jsonStr, t);
        }
        return null;
    }
    /**
     * 基础平台全部菜单权限树,用于平台登录前端初始化路由
     */
    public CommonResponse searchPermissionTree(String toke,String product,String appKey,String appType) {
       // CommonResponse commonResponse = iAmosSecurityServer.listPermissionTree(appType);
       // return commonResponse;
    	
    	
    	
    	
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<PermissionModel> dictionarieModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.permissionClient.queryPermissionTree(appType,null,null,null);
			dictionarieModel = (List<PermissionModel>)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
		CommonResponse commonResponse =new  CommonResponse("SUCCESS",dictionarieModel); 
    	
		
    	
    	return commonResponse ;
    	
    	
    	
    }
  //根据Code查询指定的字典信息.
    public JSONArray listDictionaryByDictCode(String toke,String product,String appKey,String dictCode) {
       /* CommonResponse commonResponse = iAmosSecurityServer.listDictionaryByDictCode(dictCode);
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONArray.parseArray(jsonStr);
        }*/
    	
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	List<DictionarieValueModel> dictionarieModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Systemctl.dictionarieClient.dictValues(dictCode);
			dictionarieModel = (List<DictionarieValueModel>)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
		if (dictionarieModel != null ) {
            String jsonStr = JSON.toJSONString(dictionarieModel);
            return JSONArray.parseArray(jsonStr);
        }
    	
    	
    	
        return null;
    }
    
    /**
     * 查询指定公司信息与其部门用户树
     */
    public CompanyModel listUserByCompanyId1(String toke,String product,String appKey,String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        //CommonResponse commonResponse = iAmosSecurityServer.getuserTreeByCompanyId(companyId);
       // String jsonStr = JSON.toJSONString(commonResponse);
        RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	//List<CompanyModel> companyModel=null;
		CompanyModel companyModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.companyClient.withDeptAndUsers(Long.valueOf(companyId));
			companyModel = (CompanyModel)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return companyModel;
        
      //  return JSONObject.parseObject(jsonStr);
        
    }
    

 

    public boolean loginOutFromApp(String toke,String product,String appKey) {
//        CommonResponse commonResponse = iAmosSecurityServer.loginOutFromApp();
//        if (commonResponse != null && commonResponse.isSuccess()) {
//            return true;
//        }
    	
    	
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	boolean flag=false;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.authClient.removeToken();
			flag=true;
		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
		
        return flag;
    }

    public JSONArray listDepartmentUserTree(String toke,String product,String appKey,String companyId) {
       
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    	CompanyModel companyModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.companyClient.withDeptAndUsers(Long.valueOf(companyId));
			companyModel = (CompanyModel)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
		
		if (companyModel != null ) {
			String jsonStr =null;
			
             jsonStr = JSON.toJSONString(companyModel.getChildren());
			
            return JSONArray.parseArray(jsonStr);
        }
        return null;
    	
    	
    	/*CommonResponse commonResponse = iAmosSecurityServer.listDepartmentUserTree(companyId);
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONArray.parseArray(jsonStr);
        }
        return null;*/
    }

    public boolean editPassword(String toke,String product,String appKey,String userId, String oldPassword, String newPassword) {
//        JSONObject request = new JSONObject();
//        
//        
//        request.put("originalPassword", oldPassword);
//        request.put("userId", userId);
//        request.put("password", newPassword);
//        request.put("rePassword", newPassword);
    	boolean flag=false;
    	RequestContext.setToken(toke);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
        AgencyUserModel agencyUserModel=new AgencyUserModel();
        agencyUserModel.setPassword(oldPassword);
        agencyUserModel.setRePassword(newPassword);
        agencyUserModel.setOriginalPassword(newPassword);
        
        AgencyUserModel agencyUserModel2=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult =   Privilege.agencyUserClient.modifyPassword(userId,agencyUserModel);

			agencyUserModel = (AgencyUserModel)feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
       if(agencyUserModel2!=null){
    	   flag=true;
       }
        
//        CommonResponse commonResponse = iAmosSecurityServer.editPassword(userId, request);
//        if (commonResponse != null && commonResponse.isSuccess()) {
//            return true;
//        }
        return false;
    }
}


