package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.fas.business.dao.mapper.RiskSourceMapper;
import com.yeejoin.amos.fas.business.dao.repository.IFmeaDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskFactorDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskLevelDao;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IRiskFactorService;
import com.yeejoin.amos.fas.dao.entity.Fmea;
import com.yeejoin.amos.fas.dao.entity.RiskFactor;
import com.yeejoin.amos.fas.exception.YeeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Service("riskFactorService")
public class RiskFactorServiceImpl implements IRiskFactorService {

    @Autowired
    RiskFactorMapper riskFactorMapper;
    @Autowired
    IRiskFactorDao iRiskFactorDao;
    @Autowired
    IFmeaDao iFmeaDao;

    @Autowired
    RiskSourceMapper riskSourceMapper;
    @Autowired
    IRiskLevelDao iRiskLevelDao;

    @Override
    public Page<HashMap<String, Object>> queryRiskFactorPage(CommonPageInfoParam param) {
        long total = riskFactorMapper.countPageData(param);
        List<HashMap<String, Object>> content = riskFactorMapper.queryRiskFactorPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<>(content, param, total);
        return result;
    }

    @Override
    public List<RiskFactor> queryRiskFactor() {
        return iRiskFactorDao.findAll();
    }

    @Override
    public void editRiskFactor(HashMap<String, Object> map) {
        RiskFactor param = (RiskFactor) map.get("param");
        String orgCode = map.get("org_code") == null ? "" : map.get("org_code").toString();
        String userId = map.get("user_id") == null ? "0" : map.get("user_id").toString();
        String deptId = map.get("dept_id") == null ? "0" : map.get("dept_id").toString();
        param.setOrgCode(orgCode);
        param.setDeptId(Long.parseLong(deptId));
        param.setCreateBy(Integer.parseInt(userId));
        param.setCreateDate(new Date());


        iRiskFactorDao.save(param);
    }




    @Override
    public void detRiskFactor(Long[] param) {
        //1.校验
        for (Long id : param) {
            checkBeforeDet(id);
        }
        //2.删除
        iRiskFactorDao.deleteAllByIds(param);


    }

    /**
     * 删除前校验
     *
     * @param id
     */
    private void checkBeforeDet(Long id) {
        List<Fmea> list = iFmeaDao.findByRiskFactorsId(id);
        if (null != list && list.size() > 0) {
            throw new YeeException("FMEA" + list.get(0).getId() + "在使用中，不能删除");
        }
    }

    @Override
    public Long countRepeatData(RiskFactor param) {
        // TODO Auto-generated method stub
        return riskFactorMapper.countRepeatData(param);
    }

}
