package com.yeejoin.amos.fas.business.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.component.cache.enumeration.CacheType;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.fas.business.bo.BindRegionBo;
import com.yeejoin.amos.fas.business.constants.FasConstant;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipPointMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FmeaEquipmentPointMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FmeaMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FmeaPointInputitemMapper;
import com.yeejoin.amos.fas.business.dao.mapper.ImpAndFireEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.RiskSourceMapper;
import com.yeejoin.amos.fas.business.dao.mongo.EquipCommunicationDao;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyOriginalDataDao;
import com.yeejoin.amos.fas.business.dao.repository.IDictDao;
import com.yeejoin.amos.fas.business.dao.repository.IEvaluationModelDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireEquipmentDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireEquipmentDataDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireEquipmentPointDao;
import com.yeejoin.amos.fas.business.dao.repository.IFmeaDao;
import com.yeejoin.amos.fas.business.dao.repository.IPPointDao;
import com.yeejoin.amos.fas.business.dao.repository.IPreplanPictureDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskFactorDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskLevelDao;
import com.yeejoin.amos.fas.business.dao.repository.IRiskSourceDao;
import com.yeejoin.amos.fas.business.dao.repository.IRpnChangeLogDao;
import com.yeejoin.amos.fas.business.feign.RemoteRuleServer;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.feign.RemoteWebSocketServer;
import com.yeejoin.amos.fas.business.jpush.AppMessagePushService;
import com.yeejoin.amos.fas.business.jpush.JPushTypeEnum;
import com.yeejoin.amos.fas.business.jpush.PushMsgParam;
import com.yeejoin.amos.fas.business.param.AlarmParam;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.param.FmeaBindParam;
import com.yeejoin.amos.fas.business.service.intfc.IContingencyInstance;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentService;
import com.yeejoin.amos.fas.business.service.intfc.IRiskSourceService;
import com.yeejoin.amos.fas.business.service.intfc.Node3dVoService;
import com.yeejoin.amos.fas.business.service.model.CheckInputItemRo;
import com.yeejoin.amos.fas.business.service.model.ContingencyDeviceStatus;
import com.yeejoin.amos.fas.business.service.model.ContingencyRo;
import com.yeejoin.amos.fas.business.service.model.FireEquimentDataRo;
import com.yeejoin.amos.fas.business.service.model.ProtalDataRo;
import com.yeejoin.amos.fas.business.service.model.RiskSourceRo;
import com.yeejoin.amos.fas.business.service.model.RiskSourceRuleRo;
import com.yeejoin.amos.fas.business.util.DateUtils;
import com.yeejoin.amos.fas.business.util.JexlUtil;
import com.yeejoin.amos.fas.business.vo.EquipCommunicationData;
import com.yeejoin.amos.fas.client.invoke.RsDataQueue;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;
import com.yeejoin.amos.fas.core.common.response.RiskSourceTreeResponse;
import com.yeejoin.amos.fas.dao.entity.ContingencyOriginalData;
import com.yeejoin.amos.fas.dao.entity.Dict;
import com.yeejoin.amos.fas.dao.entity.Equipment;
import com.yeejoin.amos.fas.dao.entity.EvaluationModel;
import com.yeejoin.amos.fas.dao.entity.FireEquipment;
import com.yeejoin.amos.fas.dao.entity.FireEquipmentData;
import com.yeejoin.amos.fas.dao.entity.FireEquipmentPoint;
import com.yeejoin.amos.fas.dao.entity.Fmea;
import com.yeejoin.amos.fas.dao.entity.FmeaEquipmentPoint;
import com.yeejoin.amos.fas.dao.entity.FmeaPointInputitem;
import com.yeejoin.amos.fas.dao.entity.PPoint;
import com.yeejoin.amos.fas.dao.entity.PreplanPicture;
import com.yeejoin.amos.fas.dao.entity.RiskFactor;
import com.yeejoin.amos.fas.dao.entity.RiskLevel;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import com.yeejoin.amos.fas.dao.entity.RpnChangeLog;
import com.yeejoin.amos.fas.exception.YeeException;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;


@Service("riskSourceService")
public class RiskSourceServiceImpl implements IRiskSourceService {

    private final Logger log = LoggerFactory.getLogger(RiskSourceServiceImpl.class);

    private static final String DATETYPE_YYYYMMDD = "yyyyMMdd"; //天

    private static final String DATETYPE_YYYYWW = "yyyyWW";//周

    private static final String DATETYPE_YYYYS = "yyyyS";//季节

    private static final String DATETYPE_YYYYMM = "yyyyMM";//月

    private static final String DATETYPE_YYYY = "yyyy";//年

    private static final String PACKAGE_ID = "风险管控/risk";

    //计算风险点rpni对应规则packageid
    private static final String PACKAGE_ID_COUNT_RPNI = "风险管控/countRPNi";

    @Autowired
    private IRiskSourceDao iRiskSourceDao;

    @Autowired
    private AppMessagePushService appMessagePushService;

    @Autowired
    private IFmeaDao iFmeaDao;

    @Autowired
    private IRiskLevelDao riskLevelDao;

    @Autowired
    private IEvaluationModelDao iEvaluationModelDao;

    @Autowired
    private FmeaMapper fmeaMapper;

    @Autowired
    private IRiskFactorDao iRiskFactorDao;

    @Autowired
    private RiskSourceMapper riskSourceMapper;

    @Autowired
    private FireEquipMapper fireEquipMapper;

    @Autowired
    private Node3dVoService node3dVoService;

    @Autowired
    private IFireEquipmentDao iFireEquipmentDao;

    @Autowired
    private ImpAndFireEquipMapper impAndFireEquipMapper;

    @Autowired
    private IPreplanPictureDao iPreplanPictureDao;

    @Autowired
    private FireEquipPointMapper fireEquipPointMapper;

    @Autowired
    private IRiskLevelDao iRiskLevelDao;

    @Autowired
    private IPPointDao iPPointDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private IRpnChangeLogDao iRpnChangeLogDao;

    @Autowired
    IContingencyOriginalDataDao iContingencyOriginalDataDao;

    @Autowired
    IFireEquipmentPointDao iFireEquipmentPointDao;

    @Autowired
    IFireEquipmentDataDao iFireEquipmentDataDao;

    @Autowired
    private RemoteRuleServer remoteRuleServer;

    @Autowired
    private RemoteWebSocketServer remoteWebSocketServer;

    @Autowired
    private EquipCommunicationDao equipCommunicationDao;

    @Autowired
    private IEquipmentService equipmentService;

    @Autowired
    private IDictDao dictDao;

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    IContingencyInstance iContingencyInstance;

    @Autowired
    private FmeaEquipmentPointMapper fmeaEquipmentPointMapper;

    @Autowired
    private FmeaPointInputitemMapper fmeaPointInputitemMapper;

    public static String cacheKeyForCanBeRunning() {
        return Redis.genKey(CacheType.ERASABLE.name(), "CONTINGENCYRUNING");
    }

    @Override
    public RiskSource editRiskSource(HashMap<String, Object> map) throws Exception {
        RiskSource riskSource = (RiskSource) map.get("param");
//		String id = String.valueOf(map.get("id"));
        Long id = riskSource.getId();
        String orgCode = map.get("org_code") == null ? "" : map.get("org_code").toString();
        String userId = map.get("user_id") == null ? "0" : map.get("user_id").toString();
        riskSource.setOrgCode(orgCode);
        riskSource.setCreateBy(Integer.parseInt(userId));
        Optional<RiskSource> oldRiskSource1 = iRiskSourceDao.findById(id);
        RiskSource oldRiskSource=null;
        if(oldRiskSource1.isPresent()){
        	oldRiskSource=oldRiskSource1.get();
        }
        if (id == 0) {//新增
            riskSource.setStatus(FasConstant.RISK_SOURCE_STATUS_NORMAL);
            riskSource.setCreateDate(new Date());
        } else {// 更新
            riskSource.setCreateDate(oldRiskSource.getCreateDate());
            riskSource.setFmeaList(oldRiskSource.getFmeaList());
            riskSource.setIncrement(oldRiskSource.getIncrement());
//            riskSource.setRiskSourceEquipment(oldRiskSource.getRiskSourceEquipment());
//            riskSource.setRiskSourcePointInputitem(oldRiskSource.getRiskSourcePointInputitem());
            riskSource.setRpn(oldRiskSource.getRpn());
            riskSource.setRpnChangeLogList(oldRiskSource.getRpnChangeLogList());
            riskSource.setRpni(oldRiskSource.getRpni());
            riskSource.setStatus(oldRiskSource.getStatus());
        }

        iRiskSourceDao.saveAndFlush(riskSource);


        //同步数据
        if (id == null || id == 0)
            node3dVoService.syncData(() -> node3dVoService.incrementalCreate(Node3dVoService.DATATYPE_RISKSOURCE));
        else
            node3dVoService.syncData(() -> node3dVoService.incrementalUpdate(Node3dVoService.DATATYPE_RISKSOURCE));

        return riskSource;
    }

    @Override
    public void deleteRiskSource(Long[] riskSourceId) throws Exception {
        Long id = Collections.min(Arrays.asList(riskSourceId));
        Long parentId = 0L;
        if (null != id) {
            Optional<RiskSource> rs1 = iRiskSourceDao.findById(id);
            RiskSource rs =null;
            if(rs1.isPresent()){
            	rs=rs1.get();
            }
            parentId = rs.getParentId();
        }
        for (Long rId : riskSourceId) {
            int count = iRiskSourceDao.countByParentId(rId);
            if (count > 0) {
                throw new YeeException("该数据有关联子项，请先删除子项数据");
            }
            iRiskSourceDao.deleteById(rId);
        }
//        if (null != parentId) {
////            updateRiskSourceRpni(parentId);
////        }

        //同步数据
        node3dVoService.syncData(() -> node3dVoService.incrementalRemove(Node3dVoService.DATATYPE_RISKSOURCE));

    }

    @Override
    public Page<HashMap<String, Object>> queryRiskSourceByPage(CommonPageInfoParam param) {
        long total = riskSourceMapper.countPageData(param);
        List<HashMap<String, Object>> content = riskSourceMapper.queryRiskSourceByPage(param);
        return new PageImpl<>(content, param, total);
    }


    public List<Map> queryForRegion() {
        List<Map> result = riskSourceMapper.queryForRegion();
        if (!CollectionUtils.isEmpty(result)) {
            for (Map map : result) {
                Long id = Long.parseLong(String.valueOf(map.get("id")));
                map.put("regionMaxLevel", findRegionMaxLevel(id));
            }
        }
        return result;
    }


    public Map queryFor3DStatistics() {
        Map<String, List> result = riskSourceMapper.statistics3dCount();
        result.put("equipClassify", riskSourceMapper.statisticsEquipClassify());
        result.put("pointStatus", riskSourceMapper.statisticsPointStatus());
        result.put("riskLevel", riskSourceMapper.statisticsRiskLevel());
        return result;
    }


    public List<Map> queryRPNReport() {
        return riskSourceMapper.queryRPNReport();
    }


    public Map queryForRiseUp() throws Exception {
        Map<String, Map> result = new HashMap<>();

        String startTime, endTime;
        Date now = new Date();
        Date[] timeArrayMonth = getDateInfo(now, DATETYPE_YYYYMM);
        Date[] timeArraySeason = getDateInfo(now, DATETYPE_YYYYS);
        Date[] timeArrayYear = getDateInfo(now, DATETYPE_YYYY);

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //当月的升上率
        startTime = format.format(timeArrayMonth[0]);
        endTime = format.format(timeArrayMonth[1]);
        Map resultMonth = this.riskSourceMapper.queryForRiseUp(startTime, endTime);

        //当季度的升上率
        startTime = format.format(timeArraySeason[0]);
        endTime = format.format(timeArraySeason[1]);
        Map resultSeason = this.riskSourceMapper.queryForRiseUp(startTime, endTime);


        //当年的升上率
        startTime = format.format(timeArrayYear[0]);
        endTime = format.format(timeArrayYear[1]);
        Map resultYear = this.riskSourceMapper.queryForRiseUp(startTime, endTime);

        result.put("month", resultMonth);
        result.put("season", resultSeason);
        result.put("year", resultYear);
        return result;
    }

    public List<Map> queryForMatrix() {
        return this.riskSourceMapper.queryForMatrix();
    }

    private static Date[] getDateInfo(Date date, String datetype) throws Exception {
        Date[] returnDate = new Date[2];


        Date start = null;
        Date end = null;
        if (DATETYPE_YYYYMMDD.equals(datetype)) {
            start = DateUtils.getCurrentDayStartTime(date);
            end = DateUtils.getCurrentDayEndTime(date);
        }

        if (DATETYPE_YYYYWW.equals(datetype)) {
            start = DateUtils.getCurrentWeekDayStartTime(date);
            end = DateUtils.getCurrentWeekDayEndTime(date);
        }

        if (DATETYPE_YYYYS.equals(datetype)) {
            start = DateUtils.getCurrentQuarterStartTime(date);
            end = DateUtils.getCurrentQuarterEndTime(date);
        }

        if (DATETYPE_YYYYMM.equals(datetype)) {
            start = DateUtils.getCurrentMonthStartTime(date);
            end = DateUtils.getCurrentMonthEndTime(date);
        }

        if (DATETYPE_YYYY.equals(datetype)) {
            start = DateUtils.getCurrentYearStartTime(date);
            end = DateUtils.getCurrentYearEndTime(date);
        }
        returnDate[0] = start;
        returnDate[1] = end;
        return returnDate;
    }

    @Override
    public List<RiskSourceTreeResponse> findRiskSourceTrees() {
        return riskSourceMapper.getRiskSources();
    }

//    @Override
//    public Page<HashMap<String, Object>> getRiskSourcePoints(RiskSourceParam param) {
//        long total = riskSourceMapper.getRiskSourcePointCount(param);
//        List<HashMap<String, Object>> content = riskSourceMapper.getRiskSourcePoints(param);
//        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, param, total);
//        return result;
//    }

    @Override
    public List<FmeaEquipmentPoint> bindFireEquiment(FmeaBindParam fmeaBindParam) {
        Long fmeaId = fmeaBindParam.getFmeaId();
        Long importantEquipId = fmeaBindParam.getImportantEquipmentId();
        List<Long> equipmentPointIds = fmeaEquipmentPointMapper.listEquipmentPointIdsByEquipmentId(fmeaBindParam.getEquipmentId());
        if (!CollectionUtils.isEmpty(equipmentPointIds)) {
            fmeaEquipmentPointMapper.deleteByFmeaIdAndEquipmentPointIds(fmeaId, importantEquipId, equipmentPointIds);
        }
        List<FmeaEquipmentPoint> returnList = new ArrayList<>();
        for (Long equipmentPointId : fmeaBindParam.getEquipmentPointIds()) {
            FmeaEquipmentPoint fmeaEquipmentPoint = new FmeaEquipmentPoint();
            fmeaEquipmentPoint.setFmeaId(fmeaId);
            fmeaEquipmentPoint.setImportantEquipmentId(importantEquipId);
            fmeaEquipmentPoint.setEquipmentPointId(equipmentPointId);
            returnList.add(fmeaEquipmentPoint);
        }
        if (!CollectionUtils.isEmpty(returnList)) {
            fmeaEquipmentPointMapper.saveBatch(returnList);
            RsDataQueue rsDataQueue = RsDataQueue.getInstance();
            rsDataQueue.addEquipmentMessage(fmeaId);
        }
        return returnList;
    }

    @Override
    public List<FmeaPointInputitem> bindPointInputitem(FmeaBindParam fmeaBindParam) {
        Long fmeaId = fmeaBindParam.getFmeaId();
        List<Long> pointInputitemIds = fmeaPointInputitemMapper.listPointInputitemIdsByPointId(fmeaBindParam.getPointId());
        if (!CollectionUtils.isEmpty(pointInputitemIds)) {
            fmeaPointInputitemMapper.deleteByFmeaIdAndPointInputitemIds(fmeaId, pointInputitemIds);
        }
        List<FmeaPointInputitem> returnList = new ArrayList<>();
        for (Long pointInputitemId : fmeaBindParam.getPointInputitemIds()) {
            FmeaPointInputitem fmeaPointInputitem = new FmeaPointInputitem();
            fmeaPointInputitem.setFmeaId(fmeaId);
            fmeaPointInputitem.setPointInputitemId(pointInputitemId);
            returnList.add(fmeaPointInputitem);
        }
        if (!CollectionUtils.isEmpty(returnList)) {
            fmeaPointInputitemMapper.saveBatch(returnList);
            RsDataQueue rsDataQueue = RsDataQueue.getInstance();
            rsDataQueue.addPatrolMessage(fmeaId);
        }
        return returnList;
    }

//    public String[] removeBoundRelation(String[] idArray) {
//        for (String id : idArray)
//            this.iRiskSourceEquipmentDao.delete(Long.parseLong(id));
//        return idArray;
//    }

    /**
     * 查询指定风险点和设备之间的关系，包含绑定和未绑定
     */
    public Page<Map> queryEquimentRelation(CommonPageable commonPageable, String equipmentId, String fname) {
        Long total = fireEquipMapper.queryEquimentRelationCount(equipmentId, fname);
        List<Map> list = fireEquipMapper.queryEquimentRelation(commonPageable.getOffset(), commonPageable.getPageSize(), equipmentId, fname);
        return new PageImpl<>(list, commonPageable, total);
    }

    public List<Map<String, Object>> listEquipmentPointById(Long fmeaId, Long importantEquipId, Long equipmentId, String equipmentPointName) {
        List<Map<String, Object>> list = fmeaEquipmentPointMapper.listEquipmentPoint(fmeaId, importantEquipId, equipmentId, equipmentPointName);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;

    }

    @Async
    public String processFireEqumtData(FireEquimentDataRo deviceData) throws Exception {
        //处理设备和巡检数据
        deviceData.setNodeState(deviceData.getValue());
        String batchNo = UUID.randomUUID().toString();
        deviceData.setBatchNo(batchNo);
        Optional<FireEquipment> fireEquipment1 = this.iFireEquipmentDao.findById(deviceData.getFireEquimentId());
        FireEquipment fireEquipment =null;
        
        if(fireEquipment1.isPresent()){
        	fireEquipment =fireEquipment1.get();
        }
        Equipment equipment = null;
        if (fireEquipment != null) {
            deviceData.setCode(fireEquipment.getCode());
            equipment = impAndFireEquipMapper.queryImpEqumtByFireEquipmt(deviceData.getFireEquimentId());
            if (equipment != null) {
                deviceData.setMonitor(equipment.getName());
                deviceData.setEquimentId(String.valueOf(equipment.getId()));

                //Object result = remoteRuleServer.fireRule(deviceData, "风险管控/fireEquiment");
                //处理返回结果

                List<RiskSource> riskSources = this.riskSourceMapper.queryByFireEqument(deviceData.getFireEquimentId());
                //asymbleWithParent(batchNo, riskSources, FireEquimentDataRo.class.getSimpleName(), deviceData.getFireEquimentId(), deviceData.getNodeState(), null, null);

                try {
                    alermContingency(deviceData.getBatchNo(), fireEquipment, equipment);
                } catch (Exception e) {
                    log.error("调用规则失败", e);
                }
            }
        }


        return "SUCCESS";
    }


    public void alermContingency(String batchNo, FireEquipment fireEquipment, Equipment equipment) throws Exception {
        ContingencyRo contingencyRo = new ContingencyRo();


        contingencyRo.setBatchNo(batchNo);
        contingencyRo.setEquipmentId(String.valueOf(equipment.getId()));
        contingencyRo.setEquipmentName(equipment.getName());
        contingencyRo.setFireEquipmentId(String.valueOf(fireEquipment.getId()));
        contingencyRo.setFireEquipmentName(fireEquipment.getName());
        contingencyRo.setStep("0");
        //contingencyRo.setNodeState(deviceData.getNodeState());
        contingencyRo.setConfirm("NONE");
        contingencyRo.setFireTruckRoute(equipment.getFireTruckRoute());
        contingencyRo.setRunstep(false);
        contingencyRo.setEquipmentPosition3d(equipment.getPosition3d());

        Map cameraInfo = impAndFireEquipMapper.queryForCamera(String.valueOf(equipment.getId()));

        if (cameraInfo != null) {
            contingencyRo.setCameraCodes(String.valueOf(cameraInfo.get("codes")));
            contingencyRo.setCameraIds(String.valueOf(cameraInfo.get("ids")));
        }
        contingencyRo.setMobile("13259783333");
        contingencyRo.setAdminName("admin");
        contingencyRo.setFireEquipmentPosition(fireEquipment.getPosition3d());


        List<PreplanPicture> pictures = iPreplanPictureDao.findByEquipmentId(Long.valueOf(equipment.getId()));
        if (!CollectionUtils.isEmpty(pictures)) {
            for (PreplanPicture picture : pictures) {
                if (1 == picture.getType())
                    contingencyRo.setPicture1(picture.getPicture());
                if (2 == picture.getType())
                    contingencyRo.setPicture2(picture.getPicture());
                if (3 == picture.getType())
                    contingencyRo.setPicture3(picture.getPicture());
                if (4 == picture.getType())
                    contingencyRo.setPicture4(picture.getPicture());
            }
        }


        Object result = remoteRuleServer.fireRuleFlow(contingencyRo, equipment.getReservePlan(), equipment.getName());


        ContingencyOriginalData contingencyOriginalData = new ContingencyOriginalData();
        BeanUtils.copyProperties(contingencyRo, contingencyOriginalData);
        iContingencyOriginalDataDao.save(contingencyOriginalData);
    }


//    public boolean asymbleWithParent(String bacthNo, List<RiskSource> riskSourceList, String from, Long fromId, String nodeState, String originalNodeState, List<FmeaPointInputitem> pointInputitems) throws Exception {
//        if (!CollectionUtils.isEmpty(riskSourceList)) {
//            for (RiskSource riskSource : riskSourceList) {
//                //当前规则
//                RiskSourceRo riskSourceRo = this.transfer(bacthNo, riskSource, from, nodeState, originalNodeState, new BigDecimal(0), pointInputitems);
//
//                Object result = remoteRuleServer.fireRule(riskSourceRo, PACKAGE_ID);
//                //BigDecimal RPNi = updateRpn(result,riskSource,null,fromId);
//                //处理返回结果
//
//                //反查 父级风险点，取得处于第二级的父级风险点
//                findParent(bacthNo, riskSource, nodeState, originalNodeState, new BigDecimal(0), fromId);
//            }
//        }
//        return true;
//    }

//    /**
//     * 查询父节点风险点
//     *
//     * @param riskSource
//     * @param nodeState
//     * @param originalNodeState
//     * @param RPNi
//     * @return
//     */
//    private BigDecimal findParent(String bacthNo, RiskSource riskSource, String nodeState, String originalNodeState,
//                                  BigDecimal RPNi, Long fromId) throws Exception {
//        if (riskSource != null && riskSource.getId() != 0 && RPNi.doubleValue() != 0) {
//            RiskSource parent = this.iRiskSourceDao.findById(riskSource.getParentId());
//            if (null != parent) {
//                RiskSourceRo parentRiskResource = this.transfer(bacthNo, parent, "child", nodeState, originalNodeState,
//                        RPNi, null);
//                Object result = remoteRuleServer.fireRule(parentRiskResource, "风险管控/parentRisk");
//                //updateRpn(result, parent, RPNi, fromId);
//
//                if (parent.getParentId() != 0)
//                    this.findParent(bacthNo, parent, nodeState, originalNodeState, RPNi, fromId);
//            }
//        }
//
//        return RPNi;
//    }


    private RiskSourceRo transfer(String bacthNo, RiskSource riskSource, String from, String nodeState, String originalNodeState, BigDecimal rpni, List<FmeaPointInputitem> pointInputitems) {
        RiskSourceRo riskSourceRo = new RiskSourceRo();
        riskSourceRo.setBatchNo(bacthNo);
        riskSourceRo.setId(String.valueOf(riskSource.getId()));
        riskSourceRo.setCode(riskSource.getCode());
        riskSourceRo.setFrom(from);
        riskSourceRo.setName(riskSource.getName());
        riskSourceRo.setNodeState(nodeState);
        riskSourceRo.setOriginalNodeState(originalNodeState);
        riskSourceRo.setIsRegion(riskSource.getIsRegion());
        riskSourceRo.setRiskFactor(null);
        riskSourceRo.setRpn(riskSource.getRpn());
        riskSourceRo.setRiskState(riskSource.getStatus());

        riskSourceRo.setRpni(rpni);
        Optional<RiskLevel> riskLevel1 = iRiskLevelDao.findById(riskSource.getRiskLevelId());
        RiskLevel riskLevel =null;
        if(riskLevel1.isPresent()){
        	riskLevel=riskLevel1.get();
        }
        if (riskLevel != null) {
            riskSourceRo.setRiskLevel(riskLevel.getLevel());
        }


        List<BigDecimal> RPNiSum = new ArrayList<>();
        List<Fmea> fmeaList = iFmeaDao.findByRiskSourceId(riskSource.getId());
        String riskFactor = "";

        if (!CollectionUtils.isEmpty(fmeaList)) {
            for (Fmea fmea : fmeaList) {
                RPNiSum.add(fmea.getRpni());
                Optional<RiskFactor> factor1 = iRiskFactorDao.findById(fmea.getRiskFactorsId());
                RiskFactor factor =null;
                if(factor1.isPresent()){
                	factor=factor1.get();
                }
                if (factor != null)
                    riskFactor += factor.getName() + "\n";
            }
        }


        //获取所有子节点的rpni值
        List<Map<String, BigDecimal>> rpniList = riskSourceMapper.queryForRiskSourceRpni(riskSource.getId());
        if (!CollectionUtils.isEmpty(rpniList)) {
            for (Map<String, BigDecimal> map : rpniList) {
                RPNiSum.addAll(map.values());
            }
        }



       /* for(Fmea fmea:fmeaList)
        {
            Map<String,BigDecimal> map = new HashMap<>();
            map.put("rpni",fmea.getRpni());
            RPNiSum.add(map);
        }*/


        //巡检
        if (ProtalDataRo.class.getSimpleName().equals(from)) {

            if (!CollectionUtils.isEmpty(pointInputitems)) {
//                for (RiskSourcePointInputitem pointInputitem : pointInputitems) {
//                    RiskSourcePointInputitem riskSourcePointInputitem = iRiskSourcePointInputitemDao.findAllByRiskSourceIdAndPointIdAndPointInputitemId(riskSource.getId(), pointInputitem.getPointId(), pointInputitem.getPointInputitemId());
//
//                    if (riskSourcePointInputitem != null) {
//                        riskSourcePointInputitem.setCheckInputitemId(pointInputitem.getCheckInputitemId());
//						/*//正常1，异常2    正常变异常  负的，异常变正常  正的
//						String status = pointInputitem.getStatus();
//						String oldStatus = riskSourcePointInputitem.getStatus();
//
//						*//*if(StringUtils.isEmpty(oldStatus))
//							oldStatus =  "1";
//
//						if("1".equals(oldStatus) && "2".equals(status))
//						{
//							if(!CollectionUtils.isEmpty(fmeaList))
//							{
//								for(Fmea fmea:fmeaList)
//								{
//									Map<String,BigDecimal> map = new HashMap<>();
//
//									//正常变异常  累加负的
//									map.put("rpni",fmea.getRpni().multiply(new BigDecimal(-1)));
//									RPNiSum.add(map);
//								}
//							}
//							riskSourcePointInputitem.setStatus(status);
//						}
//
//						if("2".equals(oldStatus) && "1".equals(status))
//						{
//							if(!CollectionUtils.isEmpty(fmeaList))
//							{
//								for(Fmea fmea:fmeaList)
//								{
//									Map<String,BigDecimal> map = new HashMap<>();
//									map.put("rpni",fmea.getRpni());
//									RPNiSum.add(map);
//								}
//							}
//							riskSourcePointInputitem.setStatus(status);
//						}*//*
//
//
//                        for(Fmea fmea:fmeaList)
//                        {
//                            Map<String,BigDecimal> map = new HashMap<>();
//                            map.put("rpni",fmea.getRpni());
//                            RPNiSum.add(map);
//                        }
//                       // riskSourcePointInputitem.setStatus(status);*/
//                        riskSourcePointInputitem.setStatus(pointInputitem.getStatus());
//                        iRiskSourcePointInputitemDao.save(riskSourcePointInputitem);
//                    }
//                }
            }
        }


        riskSourceRo.setRiskFactor(riskFactor);
        riskSourceRo.setRPNiSum(RPNiSum);


        //是否是区域节点
        if ("TRUE".equals(riskSource.getIsRegion())) {

            riskSourceRo.setRegionMaxLevel(findRegionMaxLevel(riskSource.getId()));
        }
        return riskSourceRo;
    }


    private Integer findRegionMaxLevel(Long regionRiskSourceId) {
        Integer maxLevel = 0;
        List<RiskSource> anomalyRiskSource = findAnomalyRiskSource(regionRiskSourceId);
        for (RiskSource anomaly : anomalyRiskSource) {
            Optional<RiskLevel> anomalyLevel1 = this.iRiskLevelDao.findById(anomaly.getRiskLevelId());
            RiskLevel anomalyLevel = null;
            if(anomalyLevel1.isPresent()){
            	anomalyLevel=anomalyLevel1.get();
            }
            if (anomalyLevel != null && anomalyLevel.getLevel() > maxLevel)
                maxLevel = anomalyLevel.getLevel();
        }
        return maxLevel;
    }


    private List<RiskSource> findAnomalyRiskSource(Long riskSourceId) {
        List<RiskSource> returnList = new ArrayList<>();
        List<RiskSource> childs = iRiskSourceDao.findByParentId(riskSourceId);

        if (CollectionUtils.isEmpty(childs))
            return returnList;

        for (RiskSource child : childs) {
			/*if("ANOMALY".equals(child.getStatus()))
			{
				returnList.add(child);
			}*/
            returnList.add(child);
            returnList.addAll(this.findAnomalyRiskSource(child.getId()));
        }
        return returnList;
    }


	/*private BigDecimal updateRpn(Object result,RiskSource riskSource,BigDecimal RPNi,Long fromId)
	{

			*//*"RPNr": 16,
			"RPNi": -14*//*
		Map map = (Map) result;



			RPNi = new BigDecimal(Double.parseDouble(String.valueOf(map.get("RPNi"))));
			if(RPNi != null)
            {
                riskSource.setRpni(RPNi);
                this.iRiskSourceDao.save(riskSource);
            }

			*//*if(RPNr.doubleValue() != 0 && !"ANOMALY".equals(riskSource.getStatus()))
			{
				riskSource.setStatus("ANOMALY");
				this.iRiskSourceDao.save(riskSource);
			}

			if(RPNr.doubleValue() == 0 && !"NORMAL".equals(riskSource.getStatus()))
			{
				riskSource.setStatus("NORMAL");
				this.iRiskSourceDao.save(riskSource);
			}*//*
		return RPNi;
	}*/


    private void createRpnChangeLog(BigDecimal rpni, BigDecimal rpnr, Long riskSourceId, Long fromId) {
        RpnChangeLog rpnChangeLog = new RpnChangeLog();
        rpnChangeLog.setCreateDate(new Date());
        rpnChangeLog.setRiskSourceId(Long.valueOf(riskSourceId));
        rpnChangeLog.setRpn(rpnr);
        rpnChangeLog.setRpni(rpni);
        rpnChangeLog.setTriggerBy(Long.valueOf(fromId));
        rpnChangeLog.setType(rpni.doubleValue() > 0 ? 0 : 1);
        iRpnChangeLogDao.save(rpnChangeLog);
    }

    @Override
    public Page<Map<String, Object>> listFmeaPointInputitem(Long fmeaId, Integer pageNumber, Integer pageSize) {
        List<Map<String, Object>> content = Lists.newArrayList();
        long total = fmeaPointInputitemMapper.countByFmeaId(fmeaId);
        if (total == 0L) {
            return new PageImpl<>(content, null, total);
        }
        content = fmeaPointInputitemMapper.listByFmeaId(fmeaId, pageNumber, pageSize);
        return new PageImpl<>(content, null, total);
    }

    @Override
    public Page<Map<String, Object>> listFeamEquipmentPoint(Long fmeaId, Integer pageNumber, Integer pageSize) {
        long total = fmeaEquipmentPointMapper.countByFmeaId(fmeaId);
        List<Map<String, Object>> content = fmeaEquipmentPointMapper.listByFmeaId(fmeaId, pageNumber, pageSize);
        return new PageImpl<>(content, null, total);
    }


    public boolean processTaskData(ProtalDataRo taskData) throws Exception {
        taskData.setBatchNo(UUID.randomUUID().toString());
        //Object result = remoteRuleServer.fireRule(taskData, "风险管控/patrol");
        return true;
    }


    @Async
    public void processProtalData(String toke,String product,String appKey,ProtalDataRo protalData) {
        String bacthNo = UUID.randomUUID().toString();
        protalData.setBatchNo(bacthNo);
        Optional<PPoint> pPoint1 = iPPointDao.findById(protalData.getId());
        PPoint pPoint =null;
        if(pPoint1.isPresent()){
        	pPoint=pPoint1.get();
        }
        if (pPoint != null) {
            protalData.setOriginalNodeState(pPoint.getStatus());
            protalData.setLevel(pPoint.getLevel());
            protalData.setPointNo(pPoint.getPointNo());
            protalData.setPointName(pPoint.getName());

            AgencyUserModel sUser = remoteSecurityService.getUserById( toke, product, appKey, pPoint.getChargePersonId());
            
           
            
            if (sUser != null) {
                protalData.setUserName(sUser.getUserName());
            } else {
                protalData.setUserName("");
            }
        }
        if (!CollectionUtils.isEmpty(protalData.getItems())) {
            Long pointId = protalData.getId();
            List<Long> inputIds = Lists.newArrayList();
            Map<Long, CheckInputItemRo> map = Maps.newHashMap();
            for (CheckInputItemRo checkInputItemRo : protalData.getItems()) {
                inputIds.add(checkInputItemRo.getPointInputitemId());
                map.put(checkInputItemRo.getPointInputitemId(), checkInputItemRo);
            }
            List<FmeaPointInputitem> fmeaPointInputitems = fmeaPointInputitemMapper.listByPointIdAndInputItemIds(pointId, inputIds);
            Set<Long> fmeaIds = Sets.newHashSet();
            List<Long> failIds = Lists.newArrayList();
            List<Long> successIds = Lists.newArrayList();
            fmeaPointInputitems.forEach(fmeaPointInputitem -> {
                CheckInputItemRo checkInputItemRo = map.get(fmeaPointInputitem.getInputItemId());
                if (checkInputItemRo.getStatus().equals("2")) {
                    failIds.add(fmeaPointInputitem.getId());
                    fmeaIds.add(fmeaPointInputitem.getFmeaId());
                } else if (checkInputItemRo.getStatus().equals("1")) {
                    successIds.add(fmeaPointInputitem.getId());
                    fmeaIds.add(fmeaPointInputitem.getFmeaId());
                }
            });
            if (failIds.size() > 0) {
                fmeaPointInputitemMapper.updateStateByIds(1, failIds);
            }
            if (successIds.size() > 0) {
                fmeaPointInputitemMapper.updateStateByIds(0, successIds);
            }
            RsDataQueue rsDataQueue = RsDataQueue.getInstance();
            fmeaIds.forEach(fmeaId -> rsDataQueue.addPatrolMessage(fmeaId));
        }
        //asymbleWithParent(bacthNo,riskSources, ProtalDataRo.class.getSimpleName(),protalData.getId(),protalData.getNodeState(),protalData.getOriginalNodeState(),protalData.getPointInputitems());
    }

//    @Override
//    @Transactional
//    public void removeByRSIdAndPId(List<HashMap<String, String>> list) {
//        // TODO Auto-generated method stub
//        if (list.size() > 0) {
//            for (HashMap<String, String> hashMap : list) {
//                iRiskSourcePointInputitemDao.removeByRSIdAndPId(hashMap.get("riskId"), hashMap.get("pointId"));
//            }
//
//        }
//
//    }

    @Override
    public RiskSourceTreeResponse queryRiskSourceDetailById(Long id) {
        RiskSourceTreeResponse det = riskSourceMapper.findRiskSourceDetatil(id);
        return det;
    }


    public Map earlyWarning(Long riskSourceId) {
        Map returnMap = new HashMap();
        Map riskSourceInfo = this.riskSourceMapper.queryForRiskSourceLevel(riskSourceId);
        List<Map> fmeaList = this.fmeaMapper.queryForFmeaList(riskSourceId);
        List<Map> inputitemContent = this.riskSourceMapper.queryForUnqualified(riskSourceId);
        List<Map> fireEquipmentPointMap = fireEquipPointMapper.queryForEqueAndPointName(riskSourceId);

        returnMap.put("riskSourceInfo", riskSourceInfo);
        returnMap.put("fmeaList", fmeaList);
        returnMap.put("inputitemContent", inputitemContent);
        returnMap.put("fire_equipment", fireEquipmentPointMap);
        return returnMap;
    }

//    @Override
//    public BigDecimal updateRiskSourceRpni(Long riskSourceId) throws Exception {
//        BigDecimal newRpni = new BigDecimal(0);
//        //风险点添加或删除风险因素时
//        RiskSource riskSource = iRiskSourceDao.findById(riskSourceId);
//        if (null != riskSource) {
//            List<BigDecimal> childRpniList = new ArrayList<>();
//            List<RiskSource> children = iRiskSourceDao.findByParentId(riskSource.getId());
//            for (RiskSource child : children) {
//                childRpniList.add(child.getRpni());
//            }
//            RiskSourceRo riskSourceRo = fillRiskSourceRo(riskSource, childRpniList);
//            //Object result = remoteRuleServer.fireRule(riskSourceRo, PACKAGE_ID_COUNT_RPNI);
//            //BigDecimal RPNi = updateRpni(result, riskSource);
//            //findParent(riskSource, RPNi);
//            //newRpni = RPNi;
//        }
//        return newRpni;
//    }

    private RiskSourceRo fillRiskSourceRo(RiskSource riskSource, List<BigDecimal> rpniList) {
        RiskSourceRo riskSourceRo = new RiskSourceRo();
        String batchNo = UUID.randomUUID().toString();
        riskSourceRo.setId(String.valueOf(riskSource.getId()));
        riskSourceRo.setBatchNo(batchNo);
        riskSourceRo.setIsRegion(riskSource.getIsRegion());
        riskSourceRo.setRiskState(riskSource.getStatus());
        List<BigDecimal> RPNiSum = new ArrayList<>();
        List<Fmea> fmeaList = iFmeaDao.findByRiskSourceId(riskSource.getId());
        if (!CollectionUtils.isEmpty(fmeaList)) {// 风险点自身危险因素的rpni值
            for (Fmea fmea : fmeaList) {
                RPNiSum.add(fmea.getRpni());
            }
        }
        if (null != rpniList) {// 若风险点为父节点，则将所有子节点的rpni值加入RPNiSum列表中
            for (BigDecimal rpni : rpniList) {
                RPNiSum.add(rpni);
            }
        }
        riskSourceRo.setRPNiSum(RPNiSum);
        return riskSourceRo;
    }

    private BigDecimal updateRpni(Object result, RiskSource riskSource) {

        /*
         * "RPNr": 16, "RPNi": -14
         */
        BigDecimal RPNi = null;
        Map map = (Map) result;
        if (null != map.get("RPNi")) {
            RPNi = new BigDecimal(Double.parseDouble(String.valueOf(map.get("RPNi"))));
            if (RPNi != null) {
                riskSource.setRpni(RPNi);
                this.iRiskSourceDao.save(riskSource);
            }
        }
        return RPNi;
    }

    /**
     * 查询父节点风险点
     *
     * @param riskSource
     * @param RPNi
     * @return
     */
    private BigDecimal findParent(RiskSource riskSource, BigDecimal RPNi) throws Exception {
        if (null != riskSource && riskSource.getId() != 0 && riskSource.getParentId() != 0 && null != RPNi && RPNi.doubleValue() != 0) {
//			RiskSource parent = iRiskSourceDao.getOne(0L);
            Optional<RiskSource> parent1 = iRiskSourceDao.findById(riskSource.getParentId());
            RiskSource parent=null;
            if(parent1.isPresent()){
            	parent=parent1.get();
            }
            if (null != parent) {
                List<BigDecimal> childRpniList = new ArrayList<>();
                List<RiskSource> children = iRiskSourceDao.findByParentId(parent.getId());
                for (RiskSource child : children) {
                    childRpniList.add(child.getRpni());
                }

                RiskSourceRo parentRiskResourceRo = fillRiskSourceRo(parent, childRpniList);
                //Object result = remoteRuleServer.fireRule(parentRiskResourceRo, PACKAGE_ID_COUNT_RPNI);
                //updateRpni(result, parent);
                if (parent.getParentId() != 0)
                    this.findParent(parent, RPNi);
            }
        }

        return RPNi;
    }

    @Override
    public List<HashMap<String, Object>> queryRiskAreaRpn() {
        return riskSourceMapper.queryRiskAreaRpn();
    }

    @javax.transaction.Transactional
    public void updateFirePointValue(Long id, String state) {
        fireEquipPointMapper.updateValue(id, state);
    }


    private static final BlockingQueue<AlarmParam> blockingQueue = new LinkedBlockingQueue<AlarmParam>();
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static boolean isRunning = true;

    @PostConstruct
    public void start() {
        executorService.execute(new AlarmConsumer());
    }

    class AlarmConsumer implements Runnable {

        /**
         * 1.从队列中取出帧；2.调用业务接口；
         */
        @Override
        public void run() {
            while (isRunning) {
                AlarmParam alarmParam = null;
                try {
                    alarmParam = blockingQueue.take();
                } catch (InterruptedException e) {
                    log.error("take alarmParam happened error", e);
                }
                // 2.调用业务接口；
                if (alarmParam == null) {
                    log.warn("alarmParam is empty!");
                } else {
                    try {
                        processFireData(alarmParam);
                    } catch (Exception e) {
                        log.error("parse alarmParam happened error", e);
                        // 失败处理
                    }
                }
            }
        }

    }


    private void processFireData(AlarmParam deviceData) throws Exception {
        //处理设备和巡检数据
        deviceData.setNodeState(deviceData.getState());

        FireEquipmentPoint fireEquipmentPoint = iFireEquipmentPointDao.findOneByCode(deviceData.getPointCode());
        fireEquipmentPoint.setValue(deviceData.getState());
        updateFirePointValue(fireEquipmentPoint.getId(), deviceData.getState());
        String fireEquipmentPointType = null;
        if (!ObjectUtils.isEmpty(fireEquipmentPoint.getAlarmType())) {
            Dict dict = dictDao.getOne(fireEquipmentPoint.getAlarmType());
            fireEquipmentPointType = dict.getDictValue();
        }
        Optional<FireEquipment> fireEquipment1 = this.iFireEquipmentDao.findById(fireEquipmentPoint.getFireEquipmentId());
        FireEquipment fireEquipment =null;
        if(fireEquipment1.isPresent()){
        	fireEquipment=fireEquipment1.get();
        }
        Equipment equipment = null;
        if (fireEquipment != null) {
            deviceData.setCode(fireEquipment.getCode());
            equipment = impAndFireEquipMapper.queryImpEqumtByFireEquipmt(fireEquipmentPoint.getFireEquipmentId());
            //报警数据存库
            saveFireEquipmentData(fireEquipmentPoint, deviceData, fireEquipmentPointType);
            List<AlarmParam> list = new ArrayList<>();
            list.add(deviceData);
            //保存到mongo
            saveData(list, "soe");

            if (equipment != null) {
                String batchNo = null;
                Object batch = null;
                Dict dict = null;
                if (fireEquipmentPointType != null) {
                    if ("alarm_type_fire".equals(fireEquipmentPointType)) {
                        redisTemplate.opsForHash().put("currentContingency", "batchNo", null);
                    } else {
                        batch = redisTemplate.opsForHash().get("currentContingency", "batchNo");
                    }
                    if (batch != null) {

                        batchNo = batch.toString();
                    } else {
                        batchNo = UUID.randomUUID().toString();
                    }
                } else {
                    batchNo = UUID.randomUUID().toString();
                }
                if (ObjectUtils.isEmpty(batchNo)) {
                    return;
                }
//				if (batch == null) {
//					batchNo = UUID.randomUUID().toString();
                deviceData.setBatchNo(batchNo);

                deviceData.setMonitor(equipment.getName());
                deviceData.setEquimentId(String.valueOf(equipment.getId()));

//                FireEquimentDataRo ruleData = new FireEquimentDataRo();
//                ruleData.setBatchNo(batchNo);
//                ruleData.setEquimentId(String.valueOf(equipment.getId()));
//                ruleData.setMonitor(equipment.getName());
//                ruleData.setCode(deviceData.getCode());
//                ruleData.setFireEquimentId(fireEquipment.getId());
//                ruleData.setName(fireEquipmentPoint.getName());
//                ruleData.setNodeState("true".equals(deviceData.getState()) ? "1" : "0");
//                ruleData.setUnit(fireEquipmentPoint.getUnit());
//                ruleData.setValue(deviceData.getState());
//                ruleData.setFireEqumentName(fireEquipment.getName());
//                Object result = remoteRuleServer.fireRule(ruleData, "风险管控/fireEquiment");
                //处理返回结果
//				} else {
//					if (batch == null) {
//					batchNo = batch.toString();
//				}

                //List<RiskSource> riskSources = this.riskSourceMapper.queryByFireEqument(fireEquipmentPoint.getFireEquipmentId());
                //asymbleWithParent(batchNo, riskSources, FireEquimentDataRo.class.getSimpleName(), fireEquipmentPoint.getFireEquipmentId(), deviceData.getNodeState(), null, null);
//                if (ObjectUtils.isEmpty(fireEquipmentPointType) || "false".equals(deviceData.getState())) {
//                    return;
//                }


                if ("alarm_type_fire".equals(fireEquipmentPointType)) {
                    if (deviceData.getIsMock()) {
                        redisTemplate.delete(RiskSourceServiceImpl.cacheKeyForCanBeRunning());
                    }
                    Object canBeRunning = redisTemplate.opsForValue().get(cacheKeyForCanBeRunning());
                    if (canBeRunning == null) {

                        try {
                            alermContingency(batchNo, fireEquipment, equipment);
                        } catch (Exception e) {
                            log.error("调用规则失败", e);
                        }
                    } else {
                        redisTemplate.expire(cacheKeyForCanBeRunning(), 24 * 60 * 60, TimeUnit.SECONDS);
                    }
                    redisTemplate.opsForHash().put("currentContingency", "batchNo", batchNo);
                    redisTemplate.opsForHash().put("currentContingency", "contingencyPlan", null);
                    redisTemplate.opsForHash().put("currentContingency", "alarmType", null);
//					redisTemplate.opsForValue().set("equipmentId", null);
                } else {
                    if ("alarm_type_trouble".equals(fireEquipmentPointType)) {
                        notifyAlarm(fireEquipmentPoint, deviceData);
                    }
                    String alarmType = (String) redisTemplate.opsForHash().get("currentContingency", "alarmType");
                    if (!ObjectUtils.isEmpty(alarmType) && dict.getDictValue().equals(alarmType)) {
                        ContingencyDeviceStatus contingencyDeviceStatus = (ContingencyDeviceStatus) redisTemplate.opsForHash().get("currentContingency", "contingencyPlan");
                        contingencyDeviceStatus.setNeedStatus("true");
                        autoProcessContingency(contingencyDeviceStatus, alarmType);
                    }
                }
            }
        }
    }

    @Override
    @javax.transaction.Transactional
    public String processFireEqumtData(AlarmParam deviceData) throws Exception {
        blockingQueue.add(deviceData);
        return "SUCCESS";
    }


    private void saveFireEquipmentData(FireEquipmentPoint fireEquipmentPoint, AlarmParam deviceData, String fireEquipmentPointType) {
        FireEquipmentData fireEquipmentData = new FireEquipmentData();
        fireEquipmentData.setEqPointCode(deviceData.getPointCode());
        fireEquipmentData.seteValue(deviceData.getState());
        fireEquipmentData.setInformationAddress(deviceData.getInformationAddress());
        fireEquipmentData.setSoe(deviceData.getSoe());
        fireEquipmentData.setIsInvalid(deviceData.getIsInvalid());
        fireEquipmentData.setEqPointName(fireEquipmentPoint.getName());
        fireEquipmentData.setEqPointUnit(fireEquipmentPoint.getUnit());
        fireEquipmentData.setFireEquipmentPointId(fireEquipmentPoint.getId());
        fireEquipmentData.setFireEquipmentId(fireEquipmentPoint.getFireEquipmentId());
        if (fireEquipmentPointType == null || !"alarm_type_fire".equals(fireEquipmentPointType)) {
            fireEquipmentData.setType("monitor");
        }
        iFireEquipmentDataDao.save(fireEquipmentData);
    }

    @Override
    public void saveData(List<AlarmParam> deviceDatas, String type) {
        List<EquipCommunicationData> list = deviceDatas.stream().map(param -> {
            log.debug("pointCode==" + param.getPointCode() + " InformationAddress==" + param.getInformationAddress());
            if (ObjectUtils.isEmpty(param.getPointCode())) {
                EquipCommunicationData data = new EquipCommunicationData();
                data.setIsInvalid(param.getIsInvalid());
                data.setInformationAddress(param.getInformationAddress());
                data.setRecDate(new Date());
                data.setState(param.getState());
                data.setSoe(param.getSoe());
                data.setServiceId(param.getServiceId());
                return data;
            }
            EquipCommunicationData data = equipmentService.findFireEquipmentByPointCode(param.getPointCode());
            if (ObjectUtils.isEmpty(data)) {
                return null;
            }
            data.setIsInvalid(param.getIsInvalid());
            data.setInformationAddress(param.getInformationAddress());
            data.setRecDate(new Date());
            data.setState(param.getState());
            data.setSoe(param.getSoe());
            data.setServiceId(param.getServiceId());

            if ("all".equals(type)) {
                FireEquipmentPoint fireEquipmentPoint = iFireEquipmentPointDao.findOneByCode(param.getPointCode());
                Dict dict = null;
                if (fireEquipmentPoint.getAlarmType() != null) {
                	Optional<Dict> dict1 = dictDao.findById(fireEquipmentPoint.getAlarmType());
                	if(dict1.isPresent()){
                		dict=dict1.get();
                	}
                }
                if (!param.getState().equals(fireEquipmentPoint.getValue())) {
                    fireEquipmentPoint.setValue(param.getState());
                    updateFirePointValue(fireEquipmentPoint.getId(), param.getState());
                    Equipment equipment = impAndFireEquipMapper.queryImpEqumtByFireEquipmt(Long.valueOf(data.getFireEquipmentId()));
                    if (!ObjectUtils.isEmpty(equipment)) {
                        if (dict != null && dict.getDictValue().equals("alarm_type_trouble")) {
                            notifyAlarm(fireEquipmentPoint, param);
                        }
//                        String batchNo = UUID.randomUUID().toString();
//                        FireEquimentDataRo ruleData = new FireEquimentDataRo();
//                        ruleData.setBatchNo(batchNo);
//                        ruleData.setEquimentId(String.valueOf(equipment.getId()));
//                        ruleData.setMonitor(equipment.getName());
//                        ruleData.setCode(data.getFireEquipmentCode());
//                        ruleData.setFireEquimentId(Long.valueOf(data.getFireEquipmentId()));
//                        ruleData.setName(data.getPointName());
//                        ruleData.setNodeState("true".equals(data.getState()) ? "1" : "0");
//                        ruleData.setUnit(data.getUnit());
//                        ruleData.setValue(data.getSoe() + "");
//                        ruleData.setFireEqumentName(data.getFireEquipmentName());
//                        try {
//                            Object result = remoteRuleServer.fireRule(ruleData, "风险管控/fireEquiment");
//                        } catch (Exception e) {
//                            e.printStackTrace();
//                        }
                    }
                }
            }
            if ("ANALOGUE".equals(data.getType())) {
                sendAnalogue(data);
            }

            return data;
        }).filter(param -> !ObjectUtils.isEmpty(param)).collect(Collectors.toList());
        equipCommunicationDao.saveAll(list);
    }

    private void notifyAlarm(FireEquipmentPoint fireEquipmentPoint, AlarmParam param) {
        List<FmeaEquipmentPoint> fmeaEquipmentPoints = fmeaEquipmentPointMapper.listByEquipmentPointId(fireEquipmentPoint.getId());
        Set<Long> fmeaIds = Sets.newHashSet();
        List<Long> ids = Lists.newArrayList();
        fmeaEquipmentPoints.forEach(fmeaEquipmentPoint -> {
            ids.add(fmeaEquipmentPoint.getId());
            fmeaIds.add(fmeaEquipmentPoint.getFmeaId());
        });
        Integer state = null;
        if (param.getState().equals("true")) {
            state = 1;
        } else if (param.getState().equals("false")) {
            state = 0;
        }
        if (state != null) {
            if (ids.size() > 0) {
                fmeaEquipmentPointMapper.updateStateByIds(state, ids);
            }
            RsDataQueue rsDataQueue = RsDataQueue.getInstance();
            fmeaIds.forEach(fmeaId -> rsDataQueue.addEquipmentMessage(fmeaId));
        }
    }

    @Async
    public void sendAnalogue(EquipCommunicationData data) {
        try {
            redisTemplate.opsForHash().put("Analogue", data.getPointCode(), data);
            remoteWebSocketServer.sendMessage("plan", JSON.toJSONString(data));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<HashMap<String, Object>> queryRiskSourceSecondLevel() {
        // TODO Auto-generated method stub
        return riskSourceMapper.queryRiskSourceSecondLevel();
    }

    @Override
    public List<RiskSourceTreeResponse> findRiskSourceEquipStatistics() {
        return riskSourceMapper.getRiskSourcesEquipment();
    }

    @Override
    public List<RiskSourceTreeResponse> findRiskSourceEquipStatistics(String[] type) {
        return riskSourceMapper.getRiskSourcesFireEquipmentByType(type);
    }

    @Override
    public List<RiskSourceTreeResponse> getCheckPointRiskSources() {
        return riskSourceMapper.getCheckPointRiskSource();
    }

    @Override
    public void queryContingencyDeviceStatus(ContingencyDeviceStatus contingencyDeviceStatus) {
        String alarmType = null;

        switch (contingencyDeviceStatus.getActionName()) {
            case "确认灾情":
//			redisTemplate.opsForHash().put("currentContingency", "equipmentId", contingencyDeviceStatus.getEquipmentId());
                redisTemplate.opsForValue().set("equipmentId", contingencyDeviceStatus.getEquipmentId());
                break;
            case "断开上级电源":
                alarmType = "alarm_type_power";
                redisTemplate.opsForHash().put("currentContingency", "alarmType", alarmType);
                redisTemplate.opsForHash().put("currentContingency", "contingencyPlan", contingencyDeviceStatus);
                redisTemplate.opsForValue().set("equipmentId", contingencyDeviceStatus.getEquipmentId());
                break;
            case "关停设备": // 换流变
                alarmType = "alarm_type_rheology";
                redisTemplate.opsForHash().put("currentContingency", "alarmType", alarmType);
                redisTemplate.opsForHash().put("currentContingency", "contingencyPlan", contingencyDeviceStatus);
                redisTemplate.opsForValue().set("equipmentId", contingencyDeviceStatus.getEquipmentId());
                break;
            case "应急处置结束": // 换流变
                redisTemplate.opsForHash().put("currentContingency", "batchNo", null);
                redisTemplate.opsForHash().put("currentContingency", "contingencyPlan", null);
                redisTemplate.opsForHash().put("currentContingency", "alarmType", null);
                redisTemplate.opsForValue().set("equipmentId", null);
                break;
            default:
//			redisTemplate.opsForHash().put("currentContingency", "contingencyPlan", null);
                redisTemplate.opsForValue().set("equipmentId", contingencyDeviceStatus.getEquipmentId());
//			redisTemplate.opsForHash().put("currentContingency", "equipmentId", null);
                break;
        }
        if (alarmType == null) {
            return;
        }
        contingencyDeviceStatus.setNeedStatus("true");
        autoProcessContingency(contingencyDeviceStatus, alarmType);
    }

    private void autoProcessContingency(ContingencyDeviceStatus contingencyDeviceStatus, String alarmType) {
        if (ObjectUtils.isEmpty(contingencyDeviceStatus)) {
            return;
        }
        int pointCount = fireEquipPointMapper.queryCountByEuipmentIdAndAlarmType(contingencyDeviceStatus.getEquipmentId(), alarmType);
        int count = fireEquipPointMapper.queryStopCountByEuipmentIdAndAlarmType(contingencyDeviceStatus.getEquipmentId(), alarmType, contingencyDeviceStatus.getNeedStatus());
        if (pointCount > 0 && pointCount == count) {
            try {
                String batchNo = (String) redisTemplate.opsForHash().get("currentContingency", "batchNo");
                iContingencyInstance.setButtonExecuted(batchNo, contingencyDeviceStatus.getContingencyPlanId(), contingencyDeviceStatus.getButtonCode(), contingencyDeviceStatus.getConfirm());
                iContingencyInstance.fire(batchNo, contingencyDeviceStatus.getStepCode(), contingencyDeviceStatus.getContingencyPlanId(), contingencyDeviceStatus.getButtonCode(), contingencyDeviceStatus.getConfirm(), contingencyDeviceStatus.getStepState());
            } catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    @Override
    public List<Map> queryContingencyWater() {
        List<Map> list = riskSourceMapper.queryContingencyWater();
        HashOperations hashOperations = redisTemplate.opsForHash();
        for (Map map : list) {
            if (hashOperations.size("Analogue") > 0) {
                if (ObjectUtils.isEmpty(map.get("CODE")) || !hashOperations.hasKey("Analogue", map.get("CODE"))) {
                    map.put("level", 0);
                    map.put("volume", 0);
                    continue;
                }
                EquipCommunicationData data = (EquipCommunicationData) hashOperations.get("Analogue", map.get("CODE"));
                map.put("level", String.format("%.2f", Double.valueOf(data.getState())));
                if (!ObjectUtils.isEmpty(map.get("level"))) {
                    double area = 0;
                    if (!ObjectUtils.isEmpty(map.get("area"))) {
                        area = Double.valueOf(map.get("area").toString());
                    }
                    map.put("volume", String.format("%.2f", Double.valueOf(map.get("level").toString()) * area));
                } else {
                    map.put("volume", 0);
                }
            } else {
                map.put("level", 0);
                map.put("volume", 0);
            }
        }
        return list;
    }

    @Override
    public List<Map> queryFmeaByPointId(Long pointId) {
        return riskSourceMapper.queryFmeaByPointId(pointId);
    }

    @Override
    public Integer getChildTypeByPid(Long riskSourceId) {
        Long regionCount = riskSourceMapper.countByParentIdAndIsRegion(riskSourceId, "TRUE");
        if (!regionCount.equals(0L)) {
            //子节点有风险区域
            return 1;
        }
        Long pointCount = riskSourceMapper.countByParentIdAndIsRegion(riskSourceId, "FALSE");
        if (!pointCount.equals(0L)) {
            //子节点有风险点
            return 2;
        }
        return 3;
    }

    /**
     * 修改、添加导致rpn、rpni改变
     */
    @Override
    public void notifyFmeaFromUpdate(String toke,String product,String appKey,Long fmeaId, String nofityType) {
        Fmea fmea = fmeaMapper.getById(fmeaId);
        if (fmea == null) {
            return;
        }
        if (fmea.getEvaluationOid() != null && fmea.getEvaluationSid() != null && fmea.getEvaluationDid() != null) {
            BigDecimal oidValue = new BigDecimal(fmea.getOidValue());
            BigDecimal sidValue = new BigDecimal(fmea.getSidValue());
            BigDecimal didValue = new BigDecimal(fmea.getDidValue());
            BigDecimal rpni = oidValue.multiply(sidValue).multiply(didValue);
            BigDecimal rpn;
            if (fmea.getNewEvaluationOid() == null) {
                fmea.setNewEvaluationOid(fmea.getEvaluationOid());
                rpn = rpni;
            } else {
                BigDecimal newOidValue = new BigDecimal(fmea.getNewOidValue());
                rpn = newOidValue.multiply(sidValue).multiply(didValue);
            }
            List<RiskLevel> levels = riskLevelDao.findAll();
            RiskLevel newLevel = getBetweenLevel(rpn, levels);
            String jpushTarget = null;
            fmea.setRpni(rpni);
            fmea.setRpn(rpn);
            if (newLevel != null) {
                fmea.setRiskLevelId(newLevel.getId());
                jpushTarget = getJpushTarget( toke, product, appKey,fmea, newLevel.getLevel());
            }
            fmeaMapper.updateRpn(fmea);
            saveRpnLog(fmea.getRiskSourceId(), fmeaId, rpn, rpni);
            this.notifyRiskSource(fmea.getRiskSourceId(), nofityType, jpushTarget);
        }
    }

    private String getJpushTarget(String toke,String product,String appKey,Fmea fmea, Integer level) {
        String jpushTarget = null;
        String userId = null;
        if (level.equals(1)) {
            userId = fmea.getCompanyLeader();
        } else if (level.equals(2)) {
            userId = fmea.getDepartmentLeader();
        } else if (level.equals(3)) {
            userId = fmea.getGroupLeader();
        } else if (level.equals(4)) {
            userId = fmea.getPersonLeader();
        }
        if (userId != null) {
            AgencyUserModel user = remoteSecurityService.getUserById( toke, product, appKey, userId);

            if (user != null) {
                jpushTarget = user.getMobile();
            }
        }
        return jpushTarget;
    }

    /**
     * 告警或者不合格项导致fmea的rpn、new_evaluation_oid改变
     */
    @Override
    public void notifyFmeaFromAbnormal(String toke,String product,String appKey,Long fmeaId, String notifyType) {
        Fmea fmea = fmeaMapper.getById(fmeaId);
        if (fmea == null) {
            return;
        }
        if (fmea.getEvaluationOid() != null && fmea.getEvaluationSid() != null && fmea.getEvaluationDid() != null) {
            List<FmeaEquipmentPoint> equipmentPoints = fmeaEquipmentPointMapper.listFmeaByFmeaId(fmeaId);
            List<FmeaPointInputitem> pointInputitems = fmeaPointInputitemMapper.listFmeaByFmeaId(fmeaId);
            Double maxRate = getMaxRate(equipmentPoints, pointInputitems);
            if (maxRate != null) {
                List<EvaluationModel> oModels = iEvaluationModelDao.findAllByType("O");
                EvaluationModel oEvaluationModel = getBetweenModel(maxRate, oModels);
                if (oEvaluationModel != null) {
                    BigDecimal newOidValue = new BigDecimal(oEvaluationModel.getCoefficient());
                    BigDecimal sidValue = new BigDecimal(fmea.getSidValue());
                    BigDecimal didValue = new BigDecimal(fmea.getDidValue());
                    BigDecimal rpn = newOidValue.multiply(sidValue).multiply(didValue);
                    List<RiskLevel> levels = riskLevelDao.findAll();
                    RiskLevel newLevel = getBetweenLevel(rpn, levels);
                    fmea.setRpn(rpn);
                    fmea.setNewEvaluationOid(oEvaluationModel.getId());
                    String jpushTarget = null;
                    if (newLevel != null) {
                        jpushTarget = getJpushTarget( toke, product, appKey,fmea, newLevel.getLevel());
                        fmea.setRiskLevelId(newLevel.getId());
                    }
                    fmeaMapper.updateRpn(fmea);
                    saveRpnLog(fmea.getRiskSourceId(), fmeaId, rpn, fmea.getRpni());
                    this.notifyRiskSource(fmea.getRiskSourceId(), notifyType, jpushTarget);
                }
            }
        }
    }

    private void saveRpnLog(Long riskSourceId, Long fmeaId, BigDecimal rpn, BigDecimal rpni) {
        RpnChangeLog rpnChangeLog = new RpnChangeLog();
        rpnChangeLog.setRiskSourceId(riskSourceId);
        rpnChangeLog.setFmeaId(fmeaId);
        rpnChangeLog.setRpn(rpn);
        rpnChangeLog.setRpni(rpni);
        iRpnChangeLogDao.save(rpnChangeLog);
    }

    private EvaluationModel getBetweenModel(Double maxRate, List<EvaluationModel> oModels) {
        for (EvaluationModel model : oModels) {
            String str = model.getDescribe().replaceAll("O", maxRate.toString());
            if (JexlUtil.convertToCode(str)) {
                return model;
            }
        }
        return null;
    }

    private Double getMaxRate(List<FmeaEquipmentPoint> equipmentPoints, List<FmeaPointInputitem> pointInputitems) {
        Double pointInputitemRate = null;
        if (!CollectionUtils.isEmpty(pointInputitems)) {
            int totalPointInputitem = pointInputitems.size();
            int pointInputitemUnNormal = 0;
            for (FmeaPointInputitem pointInputitem : pointInputitems) {
                if (pointInputitem.getState() == 1) {
                    pointInputitemUnNormal++;
                }
            }
            pointInputitemRate = pointInputitemUnNormal * 1.0 / totalPointInputitem;
        }
        Double equipmentPointRate = null;
        if (!CollectionUtils.isEmpty(equipmentPoints)) {
            int totalEquipmentPoint = equipmentPoints.size();
            int equipmentPointUnNormal = 0;
            for (FmeaEquipmentPoint equipmentPoint : equipmentPoints) {
                if (equipmentPoint.getState() == 1) {
                    equipmentPointUnNormal++;
                }
            }
            equipmentPointRate = equipmentPointUnNormal * 1.0 / totalEquipmentPoint;
        }
        if (equipmentPointRate == null) {
            if (pointInputitemRate == null) {
                return null;
            } else {
                return pointInputitemRate;
            }
        } else {
            if (pointInputitemRate == null) {
                return equipmentPointRate;
            } else {
                if (pointInputitemRate < equipmentPointRate) {
                    return equipmentPointRate;
                } else {
                    return pointInputitemRate;
                }
            }
        }
    }

    /**
     * fmea的更新导致rpn、rpni的值改变
     */
    @Override
    public void notifyRiskSource(Long riskSourceId, String notifyType, String jpushTarget) {
        Optional<RiskSource> riskSource1 = iRiskSourceDao.findById(riskSourceId);
        RiskSource riskSource =null;
        if(riskSource1.isPresent()){
        	  riskSource =riskSource1.get();
        }
        if (riskSource == null) {
            return;
        }
        List<Fmea> fmeas = fmeaMapper.listByRiskSourceId(riskSourceId);
        if (CollectionUtils.isEmpty(fmeas)) {
            BigDecimal resetValue = new BigDecimal("0");
            riskSource.setRpn(resetValue);
            riskSource.setRpni(resetValue);
            riskSource.setRiskLevelId(0L);
            riskSourceMapper.updateRpn(riskSource);
        }
        BigDecimal maxSidValue = new BigDecimal("0");
        BigDecimal maxDidValue = new BigDecimal("0");
        BigDecimal totalOidValue = new BigDecimal("0");
        BigDecimal totalNewOidValue = new BigDecimal("0");
        long count = 0L;
        for (Fmea fmea : fmeas) {
            if (fmea.getEvaluationDid() != null && fmea.getEvaluationSid() != null && fmea.getEvaluationOid() != null && fmea.getNewEvaluationOid() != null) {
                BigDecimal didValue = new BigDecimal(fmea.getDidValue());
                BigDecimal sidValue = new BigDecimal(fmea.getSidValue());
                BigDecimal oidValue = new BigDecimal(fmea.getOidValue());
                BigDecimal newOidValue = new BigDecimal(fmea.getNewOidValue());
                if (didValue.compareTo(maxDidValue) == 1) {
                    maxDidValue = didValue;
                }
                if (sidValue.compareTo(maxSidValue) == 1) {
                    maxSidValue = sidValue;
                }
                totalOidValue = totalOidValue.add(oidValue);
                totalNewOidValue = totalNewOidValue.add(newOidValue);
                count++;
            }
        }
        if (count == 0) {
            return;
        }
        BigDecimal averageOidValue = totalOidValue.divide(BigDecimal.valueOf(count));
        BigDecimal averageNewOidValue = totalNewOidValue.divide(BigDecimal.valueOf(count));
        BigDecimal rpn = maxDidValue.multiply(maxSidValue).multiply(averageNewOidValue);
        BigDecimal rpni = maxDidValue.multiply(maxSidValue).multiply(averageOidValue);
        List<RiskLevel> levels = riskLevelDao.findAll();
        RiskLevel newRiskLevel = getBetweenLevel(rpn, levels);
        RiskLevel oldRiskLevel = getBetweenLevel(rpni, levels);
        if (newRiskLevel != null) {
            riskSource.setRpn(rpn);
            riskSource.setRpni(rpni);
            riskSource.setRiskLevelId(newRiskLevel.getId());
            riskSourceMapper.updateRpn(riskSource);
            jpushRiskSourceMessage("风险点告警", jpushTarget);
            notifyRule(riskSourceId, rpn, rpni, oldRiskLevel.getLevel(), newRiskLevel.getLevel(), notifyType);
        }
    }

    private void jpushRiskSourceMessage(String content, String jpushTarget) {
        if (StringUtils.isEmpty(jpushTarget)) {
            return;
        }
        PushMsgParam pushMsgParam = new PushMsgParam();
        pushMsgParam.setRecivers(Lists.newArrayList(jpushTarget));
        pushMsgParam.setContent(content);
        pushMsgParam.setSubject("风险点RPN值改变");
        pushMsgParam.setType(JPushTypeEnum.ALIAS.getCode());
        appMessagePushService.sendMessage(pushMsgParam);
    }

    private void notifyRule(Long id, BigDecimal rpnr, BigDecimal rpni, Integer oldLevel, Integer newLevel, String notifyType) {
        int level = oldLevel - newLevel;
        String changeType;
        if (level > 0) {
            changeType = "up";
        } else if (level == 0) {
            changeType = "no";
        } else {
            changeType = "down";
        }
        RiskSourceRuleRo riskSourceRuleRo = new RiskSourceRuleRo();
        riskSourceRuleRo.setId(id);
        riskSourceRuleRo.setRpnr(rpnr);
        riskSourceRuleRo.setRpni(rpni);
        riskSourceRuleRo.setLevelChangeType(changeType);
        riskSourceRuleRo.setNotifyType(notifyType);
        BigDecimal rg = rpnr.subtract(rpni);
        int frequency = 0;
        if ("up".equals(changeType) && rg.intValue() > 0) {
            frequency = 3;
        } else if ("no".equals(changeType) && rg.intValue() > 0) {
            frequency = 1;
        }
        node3dVoService.updateByRiskSourceId(riskSourceRuleRo.getId(), frequency);
        try {
            remoteRuleServer.fireRule(riskSourceRuleRo, "风险管控/riskSource");
        } catch (Exception e) {
            log.error("调用规则异常", e);
        }
    }

    private RiskLevel getBetweenLevel(BigDecimal rpni, List<RiskLevel> levels) {
        if (CollectionUtils.isEmpty(levels)) {
            return null;
        }
        for (RiskLevel level : levels) {
            int downResult = level.getDownLimit().compareTo(rpni);
            int topResult = level.getTopLimit().compareTo(rpni);
            if (downResult == -1 && topResult != -1) {
                return level;
            }
        }
        return null;
    }

	@Override
	public List<RegionTreeResponse> findRegionTree(String orgCode) {
		List<RegionTreeResponse> regionList = riskSourceMapper.getRegionList(orgCode);
		return getRiskRegionTree(regionList);
	}
	
	//区域列表转树
	private static List<RegionTreeResponse> getRiskRegionTree(List<RegionTreeResponse> list) {
		HashMap<Long, RegionTreeResponse> hashMap = new HashMap<>();
		list.forEach( e -> hashMap.put(e.getId(), e));
		List<RegionTreeResponse> treeList = new ArrayList<RegionTreeResponse>();
        list.forEach( r -> {
        	Long parentId = r.getParentId();
        	if(parentId != null) {
        		RegionTreeResponse pRegion = hashMap.get(parentId);
        		if(pRegion != null) {
        			pRegion.getChildren().add(r);
        		}else {
        			treeList.add(r);
        		}
        	}
        });
        return treeList;
    }

	@Override
	public HashMap<String, Object> findRegionById(Long id,String orgCode) {
		HashMap<String, Object> regionDetail = riskSourceMapper.findRegionById(id,orgCode);
		if(regionDetail != null) {			
			Long isBind = (Long) regionDetail.get("isBind");
			regionDetail.put("isBind", isBind == 0 ? false : true);
		}
		return regionDetail;
	}

	@Override
	public void batchSaveRegionUe4(List<BindRegionBo> regionBoList) {
		riskSourceMapper.batchSaveRegionUe4(regionBoList);
	}
	
}
