package com.yeejoin.amos.fas.business.service.intfc;

import java.util.concurrent.Callable;

public interface Node3dVoService {

	String DATATYPE_RISKSOURCE 	= "RISKSOURCE"; //数据类型-风险点
	String DATATYPE_FIREEQUMT 	= "FIREEQUMT";//数据类型-消防设备
	String DATATYPE_IMPEQUMT 	= "IMPEQUMT";//数据类型-重点设备
	String DATATYPE_FIRECAR 	= "FIRECAR";//数据类型-消防车
	String DATATYPE_STATION 	= "STATION";//数据类型-消防室和泡沫间
	String DATATYPE_WATER 		= "WATER";//数据类型-水资源


	/**
	 * 同步新增的3d数据
	 * @param dataType
	 * @return
	 */
	Integer incrementalCreate(String dataType);



	/**
	 * 同步已经删除的的3d数据
	 * @param dataType
	 * @return
	 */
	Integer incrementalRemove(String dataType);


	/**
	 * 同步需要更新的的3d数据
	 * @param dataType
	 * @return
	 */
	Integer incrementalUpdate(String dataType);


	/**
	 * 同步指定数据类型，新增，删除，更新
	 * @param dataType
	 * @return
	 */
	Integer incrementalDataType(String dataType);

	/**
	 * 对所有数据类型进行同步，新增，更新，删除
	 * @return
	 */
	Integer  wholeIncremental();

	Integer updateByRiskSourceId(Long riskSourceId, Integer frequency);

	Integer syncData(Callable<Integer> callable )throws Exception;

}
