package com.yeejoin.amos.fas.client.invoke;

import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.service.intfc.IRiskSourceService;
import com.yeejoin.amos.fas.business.util.CacheFactory;
import com.yeejoin.amos.fas.business.util.CacheMap;
import com.yeejoin.amos.fas.business.vo.Toke;
import com.yeejoin.amos.fas.context.IotContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;

/**
 * 风险点消费队列
 */

public class RsDataQueue {

    private static final BlockingQueue<FmeaMessage> blockingQueue = new LinkedBlockingQueue<>();
    private ScheduledExecutorService service_apdu = null;
    private IRiskSourceService riskSourceService;
    private volatile static RsDataQueue instance = null;
    private static final String TOKE = "TOKE";
    
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    private RsDataQueue() {
        riskSourceService = (IRiskSourceService) IotContext.getInstance().getBean(IRiskSourceService.class);
    }

    //获取RsDataQueue 的实例
    public static RsDataQueue getInstance() {
        //先检查实例是否存在，如果不存在才进入下面的同步块
        if (instance == null) {
            //同步块，线程安全的创建实例
            synchronized (RsDataQueue.class) {
                //再次检查实例是否存在，如果不存在才真的创建实例
                if (instance == null) {
                    instance = new RsDataQueue();
                }
            }
        }
        return instance;
    }

    /**
     * 启动apdu数据消费任务
     */
    public void start() {
        service_apdu = Executors.newSingleThreadScheduledExecutor();
        // 第二个参数为首次执行的延时时间，第三个参数为定时执行的间隔时间
        service_apdu.execute(task_runnable);
    }

    public void addUpdateMessage(Long fmeaId) {
        blockingQueue.add(new FmeaMessage(fmeaId, "update"));
    }

    public void addPatrolMessage(Long fmeaId) {
        blockingQueue.add(new FmeaMessage(fmeaId, "patrol"));
    }

    public void addEquipmentMessage(Long fmeaId) {
        blockingQueue.add(new FmeaMessage(fmeaId, "equipment"));
    }

    public void addDeleteMessage(Long riskSourceId) {
        blockingQueue.add(new FmeaMessage(riskSourceId, "delete"));
    }

    Runnable task_runnable = new Runnable() {
        public void run() {
            while (true) {
                try {
                    FmeaMessage fmeaMessage = blockingQueue.take();
                    
                    if (riskSourceService != null) {
                    	 //获取缓存
                        CacheMap cacheMap= CacheFactory.newChacheMap();
                        Toke  toke=  cacheMap.getValue(TOKE);
                        if(toke==null){
                        	toke= remoteSecurityService.come();
                        	Long times=  (long) (20*24*60*60);
                        	cacheMap.setex(TOKE, toke, times);
                        }
                        String from = fmeaMessage.getNorifyFrom();
                        Long handId = fmeaMessage.getHandId();
                        if (from.equals("patrol")) {
                            riskSourceService.notifyFmeaFromAbnormal(toke.getToke(),toke.getProduct(),toke.getAppKey(),handId, from);
                        } else if (from.equals("equipment")) {
                            riskSourceService.notifyFmeaFromAbnormal(toke.getToke(),toke.getProduct(),toke.getAppKey(),handId, from);
                        } else if (from.equals("update")) {
                            riskSourceService.notifyFmeaFromUpdate(toke.getToke(),toke.getProduct(),toke.getAppKey(),handId, from);
                        } else if (from.equals("delete")) {
                            riskSourceService.notifyRiskSource(handId, from, null);
                        }
                    }
                } catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    };


}
