package com.yeejoin.amos.fas.common.enums;

/**
 * <h1>同步数据类型</h1>
 *
 * @Author SingleTian
 * @Date 2021-04-01 09:20
 */
public enum DataSyncTypeEnum {

    CONTINGENCY_PLAN_DETAIL("11", "cs/v1/fireASF/dataSync"),
    CONTINGENCY_PLAN_OPERATION_RECORD("11", "cs/v1/fireASF/dataSync"),
    CONTINGENCY_ORIGINAL_DATA("11", "cs/v1/fireASF/dataSync"),
    CONTINGENCY_PLAN_INSTANCE("11", "cs/v1/fireASF/dataSync");

    /**
     * 资源类型编码
     */
    private final String sourceCode;
    /**
     * mqtt主题
     */
    private final String mqTopic;

    DataSyncTypeEnum(String sourceCode, String mqTopic) {
        this.sourceCode = sourceCode;
        this.mqTopic = mqTopic;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public String getMqTopic() {
        return mqTopic;
    }


}
