package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.*;

/**
 * 水资源
 * @author
 *
 */
@Entity
@Table(name="f_water_resource")
@NamedQuery(name="WaterResource.findAll", query="SELECT f FROM WaterResource f")
public class WaterResource extends BasicEntity{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 名称
	 */
	private String name;
	/**
	 * 编号
	 */
	private String code;
	
	/**
	 * 类型 1：消火栓，2：消防水池，3：喷淋
	 */
	private String type;
	

	/**
	 * 区域
	 */
	@Column(name="production_area")
	private String productionArea;
	
	
	/**
	 * 3纬坐标
	 */
	private String position3d;
	
	/**
	 * 3维楼层
	 */
	private String floor3d;	
	
	/**
	 * 是否室内
	 */
	@Column(name="is_indoor")
	private Boolean isIndoor=true;
	/**
	 * 所属风险区域id
	 */
	@Column(name="risk_source_id")
	private Long riskSourceId;
	
	/**
	 * 房间
	 */
	private String room;
	
	/**
	 * 位置
	 */
	private String address;
	
	
	/**
	 * 组织
	 */
	@Column(name="org_code")
	private String orgCode;
	
	/**
	 * 创建人
	 */
	@Column(name="create_by")
	private String createBy;
	
	@Column(name="area")
	private String area;
	
	@Column(name="max_level")
	private String maxLevel;
	
	@Column(name="alarm_level")
	private String alarmLevel;

	/**
	 * ue4位置
	 */
	@Lob
	private String ue4Location;

	/**
	 * ue4旋转
	 */
	@Lob
	private String ue4Rotation;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getProductionArea() {
		return productionArea;
	}

	public void setProductionArea(String productionArea) {
		this.productionArea = productionArea;
	}

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	
	public String getRoom() {
		return room;
	}

	public void setRoom(String room) {
		this.room = room;
	}

	public Long getRiskSourceId() {
		return riskSourceId;
	}

	public void setRiskSourceId(Long riskSourceId) {
		this.riskSourceId = riskSourceId;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	@Column(name = "ue4_location")
	public String getUe4Location() {
		return ue4Location;
	}

	public void setUe4Location(String ue4Location) {
		this.ue4Location = ue4Location;
	}

	@Column(name = "ue4_rotation")
	public String getUe4Rotation() {
		return ue4Rotation;
	}

	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = ue4Rotation;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getMaxLevel() {
		return maxLevel;
	}

	public void setMaxLevel(String maxLevel) {
		this.maxLevel = maxLevel;
	}

	public String getAlarmLevel() {
		return alarmLevel;
	}

	public void setAlarmLevel(String alarmLevel) {
		this.alarmLevel = alarmLevel;
	}
}
