package com.yeejoin.amos.fas.business.dao.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.fas.business.vo.AssoEquipsVo;
import com.yeejoin.amos.fas.business.vo.EquipmentPointVo;
import com.yeejoin.amos.fas.business.vo.EquipmentSpecificForRiskVo;
import com.yeejoin.amos.fas.business.vo.EquipmentSpecificVo;
import com.yeejoin.amos.fas.dao.entity.EquipmentSpecific;
import com.yeejoin.amos.fas.dao.entity.FmeaEquipmentPoint;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 设备配置 Mapper 接口
 *
 * @author zjw
 * @date 2020-11-04
 */
public interface EquipmentSpecificMapper extends BaseMapper<EquipmentSpecificVo> {

    Long saveBatch(List<FmeaEquipmentPoint> list);

    int deletPointBuFmeaId(@Param("fmeaId")Long fmeaId,@Param("importantEquipId")Long importantEquipId);

    List<AssoEquipsVo>getAssoEquips(@Param("fmeaId")Long fmeaId, @Param("pageNumber")int pageNumber,@Param("pageSize") int pageSize);
    /**
     * 查询设备指标
     * @param fmeaId
     * @param importantEquipId
     * @param equimentId
     * @param equipmentPointName
     * @return
     */
    List<EquipmentPointVo> getBindEquipment(@Param("fmeaId")Long fmeaId, @Param("importantEquipId")Long importantEquipId, @Param("equimentId")Long equimentId, @Param("equipmentPointName")String equipmentPointName);
    /**
     * 获取配置数据
     * @param pageNumber
     * @param pageSize
     * @param name
     * @param code
     * @param equipmentId
     * @return
     */
    List<EquipmentSpecificVo> getEquipmentBySpe(@Param("pageNumber") int pageNumber, @Param("pageSize") int pageSize, @Param("name")String name, @Param("code")String code,@Param("equipmentId") String equipmentId);
    int getEquipmentBySpeCount( @Param("name")String name, @Param("code")String code,@Param("equipmentId") String equipmentId);


    /**
     * 查询绑定关系设备
     * @param equipmentId
     * @param fname
     * @return
     */
    List<EquipmentSpecificVo> getFireEquiments(@Param("equipmentId")String equipmentId, @Param("fname")String fname);

    String findEquipNameById(@Param("id")long id);

    /**
      * <pre>
      * @Description: 通过id查询
      * </pre>
      *
      * @MethodName:
      * @Param: [id]
      * @Return: EquipmentSpecific
      * @Throws
      * @Author keyong
      * @Date 2020/11/17 19:32
      */
    EquipmentSpecificForRiskVo getOneById(@Param("id")long id);
}
