package com.yeejoin.amos.fas.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.action.model.FireEquimentDataRo;
import com.yeejoin.amos.fas.business.action.model.SetpEnum;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.action.mq.WebMqttSubscribe;
import com.yeejoin.amos.fas.business.bo.JpushMsgBo;
import com.yeejoin.amos.fas.business.bo.MsgParamBo;
import com.yeejoin.amos.fas.business.dao.mapper.*;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyOriginalDataDao;
import com.yeejoin.amos.fas.business.dao.repository.IEvaluationModelDao;
import com.yeejoin.amos.fas.business.dao.repository.IFireEquipmentDao;
import com.yeejoin.amos.fas.business.dao.repository.IPreplanPictureDao;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.param.AlarmParam;
import com.yeejoin.amos.fas.business.service.intfc.IDataRefreshService;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentHandlerService;
import com.yeejoin.amos.fas.business.service.intfc.IView3dService;
import com.yeejoin.amos.fas.business.util.JexlUtil;
import com.yeejoin.amos.fas.business.util.RpnUtils;
import com.yeejoin.amos.fas.business.util.StringUtil;
import com.yeejoin.amos.fas.business.vo.*;
import com.yeejoin.amos.fas.client.invoke.RsDataQueue;
import com.yeejoin.amos.fas.common.enums.EquipmentRiskTypeEnum;
import com.yeejoin.amos.fas.common.enums.View3dRefreshAreaEum;
import com.yeejoin.amos.fas.dao.entity.*;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author keyong
 * @title: HandlerMqttMessageImpl
 * <pre>
 * @description: 订阅装备信息系统消息处理类
 * </pre>
 * @date 2020/11/10 18:03
 */
@Service("IEquipmentHandlerService")
public class HandlerMqttMessageImpl implements IEquipmentHandlerService {

    private final Logger log = LoggerFactory.getLogger(HandlerMqttMessageImpl.class);

    @Autowired
    private WebMqttSubscribe webMqttSubscribe;

    @Value("${equipManage.fegin.name}")
    private String serverName;

    @Value("${emqx.defaultTopic}")
    private String defaultTopic;

    @Autowired
    private WebMqttComponent webMqttComponent;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private FireEquipPointMapper fireEquipPointMapper;

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private ImpAndFireEquipMapper impAndFireEquipMapper;

    @Autowired
    private IPreplanPictureDao iPreplanPictureDao;

    @Autowired
    private RuleTrigger ruleTrigger;

    @Autowired
    IContingencyOriginalDataDao iContingencyOriginalDataDao;

    @Autowired
    private IDataRefreshService iDataRefreshService;

    @Autowired
    private IView3dService view3dService;

    @Autowired
    private FmeaEquipmentPointMapper fmeaEquipmentPointMapper;

    @Autowired
    private FireEquipMapper fireEquipMapper;

    @Autowired
    EquipmentSpecificMapper equipmentSpecificMapper;

    @Autowired
    private FmeaPointInputitemMapper fmeaPointInputitemMapper;

    @Autowired
    private IEvaluationModelDao iEvaluationModelDao;

    @Autowired
    private FmeaMapper fmeaMapper;


    @Value("${spring.application.name}")
    private String serviceName;

    @Override
    public void handlerMqttMessage(String topic, String data) {
        TopicEntityVo topicEntity = JSON.parseObject(data, TopicEntityVo.class);
        log.info("iotCode 性能指标属于： " + topicEntity.getType());
        EquipmentSpecificIndexVo equipmentSpecificIndex = JSONObject.parseObject(topicEntity.getMessage(), EquipmentSpecificIndexVo.class);
        long eqSpecId = equipmentSpecificIndex.getEquipmentSpecificId();
        EquipmentSpecificForRiskVo equipmentSpecific = equipmentSpecificMapper.getOneById(eqSpecId);
        Equipment equipment = impAndFireEquipMapper.queryImpEqumtByFireEquipmt(eqSpecId);
        Toke toke = remoteSecurityService.getServerToken();
        AlarmParam deviceData = new AlarmParam();
        deviceData.setMonitor(equipment != null ? equipment.getName() : "");
        deviceData.setId(String.valueOf(equipmentSpecific.getId()));
        deviceData.setCode(equipmentSpecific.getCode());
        if (EquipmentRiskTypeEnum.HZGJ.getCode().equals(equipmentSpecificIndex.getType())) { //设备告警处理逻辑
            log.info("(报警)Message type is: " + equipmentSpecificIndex.getType());

            // 报警触发调用规则服务
            executeDynamicPlan(deviceData, equipment, equipmentSpecific, toke);

        } else if (EquipmentRiskTypeEnum.GZ.getCode().equals(equipmentSpecificIndex.getType())) { // 设备故障处理逻辑
            log.info("(故障)Message type is: " + equipmentSpecificIndex.getType());
            long equipId = 0;
            if(StringUtil.isNotEmpty(equipment)) {
                equipId = equipment.getId();
            }
            long specificIndexId = equipmentSpecificIndex.getId();
            notifyAlarm(equipmentSpecificIndex, 1);

            // 是否关联风险点
            List<FmeaEquipmentPoint> list = fmeaEquipmentPointMapper.listFmeaByEquipIndexIdAndEquipId(specificIndexId, equipId);
            if(list.size() > 0) {
                // 关联风险点进行rpn，rpni值的修改
                list.forEach(fmeaEqPoint -> {
                    long fmeaId = fmeaEqPoint.getFmeaId();
                    updateFmeaRpn(fmeaId);
                });
            } else {
                // 没有关联风险点，三维页面消息推送
                fireEquipRuleMessagePush(deviceData, toke);
            }

        } else { // 向三维推送实时值修改
            log.info("(监测)Message type is: " + equipmentSpecificIndex.getType());
            Map<String, Object> content = new HashMap<>();
//            content.put("id", fireEquipmentData.getId());
//            content.put("label", fireEquipmentData.getEqPointName());
//            content.put("changeDate", fireEquipmentData.getCreateDate());
//            content.put("orgCode", fireEquipment.getOrgCode());
//            content.put("status", deviceData.getSoe());
            content.put("id", "id");
            content.put("label", "eqPointName");
            content.put("changeDate", new Date());
            content.put("orgCode", "orgCode");
            content.put("status", deviceData.getSoe());
            iDataRefreshService.sendRefreshDataWithArea(View3dRefreshAreaEum.monitor_data.getCode(), content);
            String title = String.format("/%s/%s/%s", serviceName, "yinan","data/refresh/monitorData");
            webMqttComponent.publish(title, JSON.toJSONString(view3dService.getEquipStatusList(equipmentSpecific.getOrgCode())));
        }

    }

    @Override
    public void subscribeTopic(ReginParams reginParams) {
        // 若登录系统则订阅装备数据
        webMqttSubscribe.adapter.removeTopic(defaultTopic);
        String orgCode = reginParams.getCompany().getOrgCode();
        String topic = String.format("%s.%s.%s%s", serverName, orgCode, "equipment", "/#");
        String[] strs =  webMqttSubscribe.adapter.getTopic();
        List<String> list = Stream.of(strs).collect(Collectors.toList());
        if(list.size() > 0) {
            list.forEach(x -> {
                if(!(x.equals(topic))) {
                    webMqttSubscribe.adapter.addTopic(topic);
                }
            });
        } else {
            webMqttSubscribe.adapter.addTopic(topic);
        }

    }


    /**
      * <pre>
      * @Description: rpn,rpni值修改
      * </pre>
      *
      * @MethodName:
      * @Param: [fmeaId]
      * @Return: void
      * @Throws
      * @Author keyong
      * @Date 2020/11/16 18:26
      */
    public void updateFmeaRpn(long fmeaId) {
        Fmea fmea = fmeaMapper.getById(fmeaId);
        BigDecimal oidValue = new BigDecimal(fmea.getOidValue());
        BigDecimal sidValue = new BigDecimal(fmea.getSidValue());
        BigDecimal didValue = new BigDecimal(fmea.getDidValue());
        // 计算rpni
        BigDecimal rpni = oidValue.multiply(sidValue).multiply(didValue).setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal rpn;
        if (fmea.getNewEvaluationOid() == null) {
            EvaluationModel evaluationModel = this.getEvaluationModel(fmeaId);
            if (evaluationModel != null) { // 已经绑定点位或者巡检点项且匹配到风险模型，则更新为计算后的结果
                BigDecimal newOidValue = new BigDecimal(evaluationModel.getCoefficient());
                rpn = newOidValue.multiply(sidValue).multiply(didValue).setScale(2, BigDecimal.ROUND_HALF_UP);
                fmea.setNewEvaluationOid(evaluationModel.getId());
            } else { // 未绑定点位或者巡检点项或者匹配不到风险模型，则更新为rpn与rpni一致
                fmea.setNewEvaluationOid(fmea.getEvaluationOid());
                rpn = rpni;
            }
        } else {
            BigDecimal newOidValue = new BigDecimal(fmea.getNewOidValue());
            rpn = newOidValue.multiply(sidValue).multiply(didValue).setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        fmea.setRpni(rpni);
        fmea.setRpn(rpn);
        // 更新fmea
        fmeaMapper.updateRpn(fmea);
    }

    /**
      * <pre>
      * @Description: 设备消息规则推送
      * </pre>
      *
      * @MethodName:
      * @Param: [deviceData, toke]
      * @Return: void
      * @Throws
      * @Author keyong
      * @Date 2020/11/16 18:26
      */
    @Async
    void fireEquipRuleMessagePush(AlarmParam deviceData, Toke toke) {
        String bacthNo = UUID.randomUUID().toString();
        FireEquimentDataRo fireEquimentDataRo = new FireEquimentDataRo();
        deviceData.setBatchNo(bacthNo);
        BeanUtils.copyProperties(deviceData, fireEquimentDataRo);
        try {
            RequestContext.setToken(toke.getToke());
            RequestContext.setProduct(toke.getProduct());
            log.info("设备消息规则推送" + JSONObject.toJSONString(deviceData));
            ruleTrigger.publish(fireEquimentDataRo, "风险管控/fireEquiment", null);
        } catch (Exception e) {
            log.error(e.getMessage(),e);
        }
    }

    /**
      * <pre>
      * @Description: 故障通知
      * </pre>
      *
      * @MethodName:
      * @Param: [fireEquipmentPoint, param]
      * @Return: void
      * @Throws
      * @Author keyong
      * @Date 2020/11/16 15:25
      */
    private void notifyAlarm(EquipmentSpecificIndexVo equipmentSpecificIndex, int state) {
        List<FmeaEquipmentPoint> fmeaEquipmentPoints = fmeaEquipmentPointMapper.listByEquipmentPointId(equipmentSpecificIndex.getId());
        Set<Long> fmeaIds = Sets.newHashSet();
        List<Long> ids = Lists.newArrayList();
        fmeaEquipmentPoints.forEach(fmeaEquipmentPoint -> {
            ids.add(fmeaEquipmentPoint.getId());
            fmeaIds.add(fmeaEquipmentPoint.getFmeaId());
        });

        if (ids.size() > 0) {
            fmeaEquipmentPointMapper.updateStateByIds(state, ids);
        }
        final Integer st = state;
        String monitor = equipmentSpecificMapper.findEquipNameById(equipmentSpecificIndex.getEquipmentSpecificId());
        RsDataQueue rsDataQueue = RsDataQueue.getInstance();
        fmeaIds.forEach(fmeaId -> rsDataQueue.addEquipmentMessage(fmeaId, monitor, st));
    }

    private EvaluationModel getEvaluationModel(Long fmeaId) {
        List<FmeaEquipmentPoint> equipmentPoints = fmeaEquipmentPointMapper.listFmeaByFmeaId(fmeaId);
        List<FmeaPointInputitem> pointInputitems = fmeaPointInputitemMapper.listFmeaByFmeaId(fmeaId);
        Double maxRate = RpnUtils.getMaxRate(equipmentPoints, pointInputitems);
        if (maxRate != null) {
            List<EvaluationModel> oModels = iEvaluationModelDao.findAllByType("O");
            EvaluationModel oEvaluationModel = getBetweenModel(maxRate, oModels);
            return oEvaluationModel;
        }
        return null;
    }

    private EvaluationModel getBetweenModel(Double maxRate, List<EvaluationModel> oModels) {
        for (EvaluationModel model : oModels) {
            String str = model.getDescribe().replaceAll("O", maxRate.toString());
            if (JexlUtil.convertToCode(str)) {
                return model;
            }
        }
        return null;
    }

    /**
      * <pre>
      * @Description: 火警执行动态预案
      * </pre>
      *
      * @MethodName:
      * @Param:
      * @Return: null
      * @Throws
      * @Author keyong
      * @Date 2020/11/11 20:46
      */
    @Async
    void executeDynamicPlan(AlarmParam deviceData, Equipment equipment, EquipmentSpecificForRiskVo equipmentSpecific, Toke toke) {
        String batchNo = UUID.randomUUID().toString();
        RequestContext.setToken(toke.getToke());
        RequestContext.setProduct(toke.getProduct());
        try {
            alarmContingency(batchNo, equipmentSpecific, equipment);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void alarmContingency(String batchNo, EquipmentSpecificForRiskVo equipmentSpecific, Equipment equipment) throws Exception {
        Object oldContingencyRo = redisTemplate.opsForValue().get("contingencyRo");
        ContingencyRo contingencyRo = new ContingencyRo();
        contingencyRo.setBatchNo(batchNo);
        contingencyRo.setEquipmentId(String.valueOf(equipment.getId()));
        contingencyRo.setEquipmentName(equipment.getName());
        contingencyRo.setFireEquipmentId(String.valueOf(equipmentSpecific.getId()));
        contingencyRo.setFireEquipmentName(equipmentSpecific.getName());
        contingencyRo.setStep(SetpEnum.STEP0.getValue());
        contingencyRo.setConfirm("NONE");
        contingencyRo.setFireTruckRoute(equipment.getFireTruckRoute());
        contingencyRo.setRunstep(false);
        contingencyRo.setEquipmentPosition3d(equipment.getPosition3d());
        contingencyRo.setEquipmentCode(equipment.getCode());
        contingencyRo.setEquipmentOrgCode(equipment.getOrgCode());

//        Map cameraInfo = impAndFireEquipMapper.queryForCamera(String.valueOf(equipment.getId()));//查询重点设备关联视频点位，暂不处理
//
//        if (cameraInfo != null) {
//            contingencyRo.setCameraCodes(String.valueOf(cameraInfo.get("codes")));
//            contingencyRo.setCameraIds(String.valueOf(cameraInfo.get("ids")));
//        }

//        contingencyRo.setMobile("13259783333");
//        contingencyRo.setAdminName("admin");
//        contingencyRo.setFireEquipmentPosition(fireEquipment.getPosition3d());

        List<PreplanPicture> pictures = iPreplanPictureDao.findByEquipmentId(Long.valueOf(equipment.getId()));
        if (!CollectionUtils.isEmpty(pictures)) {
            for (PreplanPicture picture : pictures) {
                if (1 == picture.getType()) {
                    contingencyRo.setPicture1(picture.getPicture());
                }
                if (2 == picture.getType()) {
                    contingencyRo.setPicture2(picture.getPicture());
                }
                if (3 == picture.getType()) {
                    contingencyRo.setPicture3(picture.getPicture());
                }
                if (4 == picture.getType()) {
                    contingencyRo.setPicture4(picture.getPicture());
                }
            }
        }

        // 获取遥信指标,暂不处理    code = 设备编码iot_code-指标项name_key
        List<Map> points = fireEquipPointMapper.getPointsByEquipmentIdAndType(equipment.getId(), "SWITCH");//物联属性指标 and 为true或false
        HashMap<String, Integer> telesignallingMap = new HashMap<>();
        for (Map map : points) {
            telesignallingMap.put(map.get("code") + "", (ObjectUtils.isEmpty(map.get("value")) || "false".equals(map.get("value").toString())) ? 0 : 1);
        }
        contingencyRo.setTelesignallingMap(telesignallingMap);
        // 获取遥测指标
        points = fireEquipPointMapper.getPointsByEquipmentIdAndType(equipment.getId(), "ANALOGUE"); //物联指标 非 true false
        HashMap<String, Double> telemetryMap = new HashMap<>();
        for (Map map : points) {
            telemetryMap.put(map.get("code") + "", Double.valueOf(ObjectUtils.isEmpty(map.get("value")) ? "0" : map.get("value").toString()));
        }
        contingencyRo.setTelemetryMap(telemetryMap);

        log.debug("开始调用规则");
        Object result = ruleTrigger.publish(contingencyRo, equipment.getReservePlan(), ArrayUtils.toArray(equipment.getName()));
        log.debug("规则调用返回==",result);

        ContingencyOriginalData contingencyOriginalData = new ContingencyOriginalData();
        BeanUtils.copyProperties(contingencyRo, contingencyOriginalData);
        iContingencyOriginalDataDao.save(contingencyOriginalData);
    }
}
