package com.yeejoin.amos.fas.dao.entity; 


import javax.persistence.*;
import java.util.Date; 

/**
 * The persistent class for the alarm database table.
 */
@Entity
@Table(name = "f_station_info")
@NamedQuery(name = "StationInfo.findAll", query = "SELECT a FROM StationInfo a")
public class StationInfo extends BasicEntity{
    private static final long serialVersionUID = 1L;

    /**
     * 名称
     */
    private String name; 

    /**
     * 环流站编码
     */
    @Column(name="station_code")
    private String stationCode; 

    /**
     * 后三位编码
     */
    private String code; 

    /**
     * 换流站类型：1-发电类型；2-收电类型
     */
    @Column(name="elec_type")
    private Integer elecType; 

    /**
     * 用途类型:1-电厂升压变电站；2-公用普通变电站；3-公用换流变电站；4-企业自备变电站；5-其他
     */
    @Column(name="use_type")
    private Integer useType; 

    /**
     * 省份编码
     */
    @Column(name="province_code")
    private String provinceCode; 

    /**
     * 市区编码
     */
    @Column(name="city_code")
    private String cityCode; 

    /**
     * 区县编码
     */
    @Column(name="district_code")
    private String districtCode; 

    /**
     * 省份编码
     */
    private String regionCode;

    /**
     * 详细地址
     */
    private String address; 

    /**
     * '0-启用；1-停用
     */
    private Integer status; 

    /**
     * 经度
     */
    private Double longitude; 

    /**
     * 纬度
     */
    private Double latitude; 

    /**
     * 换流站负责人
     */
    @Column(name="station_charge_user_id")
    private String stationChargeUserId; 

    /**
     * 安全负责人
     */
    @Column(name="safety_charge_user_id")
    private String safetyChargeUserId; 

    /**
     * 创建人
     */
    @Column(name="create_by")
    private String createBy; 

    /**
     * 创建日期
     */
    @Column(name="create_date")
    private Date createDate;

    /**
     * 备注
     */
    private String remark; 

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStationCode() {
        return stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getElecType() {
        return elecType;
    }

    public void setElecType(Integer elecType) {
        this.elecType = elecType;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public String getStationChargeUserId() {
        return stationChargeUserId;
    }

    public void setStationChargeUserId(String stationChargeUserId) {
        this.stationChargeUserId = stationChargeUserId;
    }

    public String getSafetyChargeUserId() {
        return safetyChargeUserId;
    }

    public void setSafetyChargeUserId(String safetyChargeUserId) {
        this.safetyChargeUserId = safetyChargeUserId;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public Date getCreateDate() {
        return createDate;
    }

    @Override
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Transient
    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }
}
