package com.yeejoin.amos.fas.business.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/safeuser")
@Api(tags="公司选择api")
public class SafetyController extends BaseController{
	private final Logger log = LoggerFactory.getLogger(SafetyController.class);
	
	 /**
     * 保存登陆用户选择公司信息
     */
	@Permission
    @ApiOperation(value = "  保存登陆用户选择公司信息", notes = " 保存登陆用户选择公司信息")
    @PostMapping(value = "/save/curCompany")
    public CommonResponse saveCurCompany(@RequestBody ReginParams reginParams) {
        this.saveSelectedOrgInfo(reginParams);
        return CommonResponseUtil.success();
    }
}
