package com.yeejoin.amos.fas.business.dao.repository;

import java.util.List;
import java.util.Optional;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.fas.dao.entity.WaterResourceEquipment;

@Repository("iWaterResourceEquipmentDao")
public interface IWaterResourceEquipmentDao extends BaseDao<WaterResourceEquipment, Long> {

	Optional<WaterResourceEquipment> findById(Long id);
	
	WaterResourceEquipment findByWaterResourceIdAndFireEquipmentId(Long waterResourceId,Long fireEquipmentId);
	
	int countByWaterResourceIdAndFireEquipmentId(Long waterResourceId,Long fireEquipmentId);

	@Transactional
    @Modifying
    @Query(value = "delete  FROM `f_water_resource_equipment` WHERE water_resource_id = ?1", nativeQuery = true)
	void deleteByWaterSourceId(Long id);

}
