package com.yeejoin.amos.fas.business.feign;


import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.yeejoin.amos.fas.core.util.CommonResponse;

@FeignClient(name="${dutyMode.fegin.name}", fallback=DutyModeServerFallback.class, configuration=FeignConfiguration.class)
public interface IDutyModeServer {
	
	@RequestMapping(value = "/duty/listByDay", method = RequestMethod.POST,consumes = "application/json")
	public CommonResponse dutyListByDay(
			@RequestHeader(name="appKey",required = true) String appKey,
			@RequestHeader(name="product",required = true) String product,
			@RequestHeader(name="orgCode",required = true) String orgCode,
			@RequestBody String param);

	@RequestMapping(value = "/duty/dutyListByDate", method = RequestMethod.POST,consumes = "application/json")
	public CommonResponse dutyListByDate(
			@RequestHeader(name="appKey",required = true) String appKey,
			@RequestHeader(name="product",required = true) String product,
			@RequestHeader(name="token",required = true) String token,
			@RequestHeader(name="orgCode",required = true) String orgCode,
			@RequestBody String param);
}
