package com.yeejoin.amos.fas.business.feign;

import com.yeejoin.amos.fas.business.service.model.BasicsRo;
import com.yeejoin.amos.fas.business.service.model.ContingencyDeviceStatus;
import com.yeejoin.amos.fas.business.service.model.RiskSourceRuleRo;
//import com.yeejoin.amos.op.core.util.ApplicationConfig;
//import com.yeejoin.amos.op.core.util.Constants;
import com.yeejoin.amos.fas.business.util.Constants;
import com.yeejoin.amos.fas.business.util.JSONUtil;

import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * <pre>
 * 规则模型系统远程调用
 * </pre>
 *
 * @author amos
 * @version $Id: RemoteRuleServer.java, v 0.1 2019年5月7日 下午5:52:21 amos Exp $
 */
@Service("remoteRuleServer")
public class RemoteRuleServer {

   /* @Autowired
    private ApplicationConfig applicationConfig;*/
	@Value("${params.remoteRuleUrl}")
    private String remoteRuleUrl;
    
    private final RestTemplate restTemplate;

    private final Logger log = LoggerFactory.getLogger(RemoteRuleServer.class);

    private ObjectMapper objectMapper = new ObjectMapper();

    public RemoteRuleServer() {
        this.restTemplate = new RestTemplate();
    }

    /**
     * 触发风险点规则
     */
    public Object fireRule(RiskSourceRuleRo riskSourceRuleRo, String packageId) throws Exception {
        Map<String, String> map = new HashMap<>();
        String data = JSONUtil.toJson(riskSourceRuleRo);
        log.info(data);
        map.put("resFact", data);
        map.put("packageId", packageId);
        map.put("className", riskSourceRuleRo.getClass().getName());
        /*String url = applicationConfig.getParamValueStr("params.remoteRuleUrl");*/
        String url =remoteRuleUrl;
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<>(map, headers);
        ResponseEntity responseEntity = restTemplate.exchange(url + "urule/rule/fireRule",
                HttpMethod.POST, formEntity, String.class);

        responseEntity.getBody();
        Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(), Map.class);
        if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS)) {
            log.info("调用规则服务成功，请求参数：" + formEntity.toString());
            return commonResponse.get("dataList");
        }
        return null;
    }

    /**
     * <pre>
     * 触发规则流
     * </pre>
     *
     * @param resFact   触发规则对象
     * @param packageId 规范规则包
     * @param processId 规则流id
     * @return
     */
    public Object fireRuleFlow(BasicsRo resFact, String packageId, String processId) throws Exception {
        String data = JSONUtil.toJson(resFact);
        log.info("调用规则请求====================>" + data);
        Map<String, String> map = new HashMap<String, String>();
        map.put("resFact", data);
        map.put("packageId", packageId);
        map.put("processId", processId);
        map.put("className", resFact.getClass().getName());
        //String url = applicationConfig.getParamValueStr("params.remoteRuleUrl");
        String url =remoteRuleUrl;
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType
                .parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<Map<String, String>>(map, headers);
        ResponseEntity responseEntity = restTemplate.exchange(url + "urule/rule/fireRuleFlow",
                HttpMethod.POST, formEntity, String.class);


        Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(), Map.class);
        if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS)) {
            return commonResponse.get("dataList");
        }
        return null;
    }


    public Object autoProcessContingency(ContingencyDeviceStatus contingencyDeviceStatus) throws Exception {
        Map<String, String> map = new HashMap<String, String>();

       // String url = applicationConfig.getParamValueStr("params.remoteRuleUrl");
        String url =remoteRuleUrl;
        //        String url = "http://172.16.10.70:8080/";
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType
                .parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<Map<String, String>>(map, headers);
        String urlParams = "batchNo=%s&stepCode=%s&buttonCode=%s&confirm=%s&contingencyPlanId=%s&stepState=%s";
        String.format(urlParams,
                contingencyDeviceStatus.getButtonCode(),
                contingencyDeviceStatus.getStepCode(),
                contingencyDeviceStatus.getConfirm(),
                contingencyDeviceStatus.getContingencyPlanId(),
                contingencyDeviceStatus.getStepState());
        ResponseEntity responseEntity = restTemplate.exchange(url + "/api/timeline/fire?" + urlParams,
                HttpMethod.PUT, formEntity, String.class);


        Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(), Map.class);
        if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS)) {
            return commonResponse.get("dataList");
        }
        return null;
    }
}