package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.FireStrengthMapper;
import com.yeejoin.amos.fas.business.dao.repository.FireStrengthPointDao;
import com.yeejoin.amos.fas.business.service.intfc.FireStengthService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.FireStrength;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service("fireStengthService")
public class FireStrengthServiceImpl implements FireStengthService {

	@Autowired
	private FireStrengthPointDao fireStrengthPointDao;
	@Autowired
	private FireStrengthMapper fireStrengthMapper;

	public FireStrength savePoint(FireStrength fireEquipmentPoint) {
		return fireStrengthPointDao.save(fireEquipmentPoint);
	}

	public Map queryOne(Long id) {
		return fireStrengthMapper.queryOne(id);
	}

	public String[] deletePoint(String[] idArray) throws Exception {
		for (String id : idArray) {
			Optional<FireStrength> fireEquipmentPoint1 = fireStrengthPointDao.findById(Long.parseLong(id));
			FireStrength fireEquipmentPoint = null;
			if (fireEquipmentPoint1.isPresent()) {
				fireEquipmentPoint = fireEquipmentPoint1.get();
			}
			if (fireEquipmentPoint != null) {
				this.fireStrengthPointDao.deleteById(Long.parseLong(id));
			} else {
				throw new Exception("找不到指定的监测点:" + id);
			}
		}

		return idArray;
	}

	public Page queryByFireEquimt(String username, String code, CommonPageable pageable) {
		Long total = fireStrengthMapper.queryCountForPage(username, code);
		List<Map> content = fireStrengthMapper.queryForPage(username, code, pageable.getOffset(),
				pageable.getPageSize());
		Page result = new PageImpl(content, pageable, total);
		return result;
	}

	public List<FireStrength> queryForStrengthList(String time) {
		return fireStrengthMapper.queryForStrengthList(time);
	}

}
