package com.yeejoin.amos.fas.config;


import javax.servlet.http.HttpServletRequest;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.yeejoin.amos.component.feign.config.TokenOperation;
import com.yeejoin.amos.fas.exception.PermissionException;

@Aspect
@Component
@ResponseBody
public class PermissionAspect {
	private static final Logger logger = LoggerFactory.getLogger(PermissionAspect.class);
	
	// 前置通知，在方法执行之前
	@Before(value = "@annotation(Permission)")
	public void PermissionCheck(JoinPoint joinPoint) throws PermissionException {
		HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder
				.getRequestAttributes()).getRequest();

		logger.info("======开始权限校验======");
		// 用户token
		String token = (String) request.getHeader("token");
		token = ObjectUtils.isEmpty(token) ? (String) request.getHeader("X-Access-Token") : token;
		String product = (String) request.getHeader("product");
		String appKey = (String) request.getHeader("appKey");
		logger.info("用户token：" + token);
		RequestContext.setToken(token);
		RequestContext.setProduct(product);
		RequestContext.setAppKey(appKey);
		if (!TokenOperation.refresh(token)) {
			throw new PermissionException("登录信息失效，请重新登录");
		}
	}
}
