package com.yeejoin.amos.fas.business.dao.mapper;

import com.yeejoin.amos.fas.business.vo.PlanDetailVo;
import com.yeejoin.amos.fas.datasync.bo.PlanDetailSyncBo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/1/15 10:52
 */
@Repository
public interface PlanDetailMapper {

    /**
     * 更新预案状态
     * @param idList id
     * @param status 状态
     * @return
     */
    int updatePlanStatusByIdList(@Param("idList") List<Long> idList, @Param("status") Integer status);

    /**
     * 更新删除状态
     * @param idList id
     * @param isDelete 是否删除
     * @return
     */
    int updateIsDeleteByIdList(@Param("idList") List<Long> idList, @Param("isDelete") Boolean isDelete);

    /**
     * 筛选预案获得总数
     * @return
     */
    Integer filterCount(@Param("planName") String planName, @Param("classifyId") List<Long> classifyId, @Param("planRange") List<String> planRange, @Param("editOrgName") String editOrgName, @Param("implementationTimeLeft") Date implementationTimeLeft, @Param("implementationTimeRight") Date implementationTimeRight);

    /**
     * 筛选预案获得分页记录
     * @return
     */
    List<PlanDetailVo> filterList(@Param("planName") String planName, @Param("classifyId") List<Long> classifyId, @Param("planRange") List<String> planRange, @Param("editOrgName") String editOrgName, @Param("implementationTimeLeft") Date implementationTimeLeft, @Param("implementationTimeRight") Date implementationTimeRight, @Param("start") int start, @Param("size") int size);

    List<String> getRuleIdByEquipment(@Param("id")  Long id);


    PlanDetailVo getPlanDetailByEquipmentId(@Param("fireEquipmentId")  Long fireEquipmentId);

    Integer planReset(@Param("date") Date date);

    List<PlanDetailSyncBo> getPlanDetailSyncBoList(Map<String, Object> map);
    

	String queryBatchNoByFireEquipmentId(@Param("fireEquipmentId") String fireEquipmentId);
}
