package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.PlanEquipment;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <h1><h1>
 *
 * @author tiantao
 * @date 2021/1/15 10:36
 */
@Repository
public interface IPlanEquipmentDao extends BaseDao<PlanEquipment, Long> {
    @Query(value="SELECT * from c_plan_equipment where fire_equipment_id = ?1 AND is_delete = 0 ", nativeQuery = true)
    PlanEquipment findByFireEquipmentId(Long fireEquipmentId);

    void deleteByPlanId(long planId);

    List<PlanEquipment> getPlanDocsByPlanId(Long planId);
    @Query(value="SELECT * from c_plan_equipment where plan_id = ?1 AND is_delete = 0 ", nativeQuery = true)
    List<PlanEquipment> findByPlanId(Long planId);

    List<PlanEquipment> findAllByIsDelete(Boolean isDelete);

    List<PlanEquipment> findAllByPlanIdIn(List<Long> planId);

    @Query(value="SELECT * from c_plan_equipment where  fire_equipment_id in (?1) AND is_delete = 0 ", nativeQuery = true)
    List<PlanEquipment> findAllByFireEquipmentIdIn(List<Long> id);

}
