package com.yeejoin.amos.fas.business.feign;

import com.yeejoin.amos.fas.business.jpush.PushMsgParam;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 消息推送
 * @author maoying
 *
 */
@FeignClient(name = "${Jcs.fegin.name}", configuration={MultipartSupportConfig.class})
public interface JcsFeign {

	/**
	 * 新值班月视图
	 * @param dutyDay
	 * @param shiftId
	 * @param postType
	 * @return
	 */
	@RequestMapping(value = "/jcs/common/duty-person/new-duty-detail", method = RequestMethod.GET,consumes = "application/json")
	ResponseModel dutyStatisticsByDate(
			@RequestParam String beginDate,
			@RequestParam String endDate,
			@RequestParam(required = false) String fieldCode);

	/**
	 * 查询当前值班人信息列表
	 * @return
	 */
	@RequestMapping(value = "/jcs/common/duty-person/person/on_duty/list", method = RequestMethod.GET,consumes = "application/json")
	ResponseModel dutyPersonList();


	@RequestMapping(value = "/jcs//org-person/listCompanyByIds", method = RequestMethod.GET,consumes = "application/json")
	List<Object> listCompanyByIds(@RequestParam List<Long> ids);

	@RequestMapping(value = "/jcs/org-person/person/img/{id}", method = RequestMethod.GET,consumes = "application/json")
	ResponseModel getPersonImage(@PathVariable String id);
}
