package com.yeejoin.amos.fas.business.feign;


import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

@FeignClient(name = "${privilege.fegin.name}", configuration = {MultipartSupportConfig.class})
public interface PrivilegeFeign {

    @RequestMapping(value = "privilege/v1/auth/idpassword", method = RequestMethod.POST)
    FeignClientResult login(
            @RequestHeader(name = "appKey", required = true) String appKey,
            @RequestHeader(name = "product", required = true) String product,
//            @RequestHeader(name = "token", required = true) String token,
            @RequestBody Map person);

    @RequestMapping(value = "privilege/v1/application/list/user/service", method = RequestMethod.GET)
    FeignClientResult warrant(
            @RequestHeader(name = "appKey", required = true) String appKey,
            @RequestHeader(name = "product", required = true) String product,
            @RequestHeader(name = "token", required = true) String token);

    @RequestMapping(value = "/privilege/v1/agencyuser/list/role/{roleIds}", method = RequestMethod.GET)
    FeignClientResult getUserByRoleIds(@RequestHeader(name = "appKey", required = true) String appKey,
                                       @RequestHeader(name = "product", required = true) String product,
                                       @RequestHeader(name = "token", required = true) String token,
                                       @RequestParam(value = "roleIds", required = true) String roleIds);

    @RequestMapping(value = "/privilege/v1/role/list", method = RequestMethod.GET)
    FeignClientResult getRoleList(@RequestHeader(name = "appKey", required = true) String appKey,
                                       @RequestHeader(name = "product", required = true) String product,
                                       @RequestHeader(name = "token", required = true) String token,
                                       @RequestParam(value = "roleName", required = true) String roleName);
}
