package com.yeejoin.amos.fas.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.fas.business.action.ContingencyAction;
import com.yeejoin.amos.fas.business.action.model.ContingencyEvent;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.action.util.ContingencyLogPublisher;
import com.yeejoin.amos.fas.business.bo.FirePlanAlarmBo;
import com.yeejoin.amos.fas.business.dao.mapper.*;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyOriginalDataDao;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyPlanInstanceRepository;
import com.yeejoin.amos.fas.business.event.ContingecyExecEvent;
import com.yeejoin.amos.fas.business.event.EventHandler;
import com.yeejoin.amos.fas.business.event.EventType;
import com.yeejoin.amos.fas.business.feign.JcsFeign;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.service.intfc.*;
import com.yeejoin.amos.fas.business.service.model.Operate;
import com.yeejoin.amos.fas.business.service.model.OperateGroup;
import com.yeejoin.amos.fas.business.util.DateUtils;
import com.yeejoin.amos.fas.business.vo.*;
import com.yeejoin.amos.fas.common.enums.PlanReplyMessageEnum;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import com.yeejoin.amos.fas.dao.entity.ContingencyOriginalData;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.EmergencyTaskContent;
import com.yeejoin.amos.fas.dao.entity.Equipment;
import com.yeejoin.amos.fas.datasync.bo.ContingencyOriginalDataSyncBo;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

import static org.typroject.tyboot.core.foundation.context.RequestContext.*;

@Service
public class ContingencyInstanceImpl implements IContingencyInstance {

    private static final Logger log = LoggerFactory.getLogger(ContingencyInstanceImpl.class);

    static LinkedList<Map<String, String>> fireQueue = new LinkedList<>();

    // public final static List<String> list = Arrays.asList("0", "1", "2", "5", "9", "10", "11");

    @Value("classpath:/json/plan-setp-node.json")
    private Resource planStepNodeResource;

    @Autowired
    private IContingencyPlanInstanceRepository repository;

    @Autowired
    IContingencyOriginalDataDao iContingencyOriginalDataDao;

    @Autowired
    private ImpAndFireEquipMapper impAndFireEquipMapper;

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private FireEquipPointMapper fireEquipPointMapper;

    @Autowired
    IRocketMQService rocketMQService;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Value("${rocket-equip-alarm-topic}")
    private String rocketTopicFireEquipAlarm;

    @Autowired
    private View3dMapper view3dMapper;

    @Value("${station.name}")
    private String stationName;

    @Value("${systemctl.sync.switch}")
    private Boolean dataSyncSwitch;

    @Autowired
    private IDataSyncService dataSyncService;

    @Autowired
    private ContingencyOriginalMapper contingencyOriginalMapper;

    @Autowired
    private ContingencyInstanceInfoService contingencyInstanceInfoService;

    @Autowired
    private IContingencyInstance contingencyInstance;

    @Autowired
    private ContingencyPlanInstanceMapper contingencyPlanInstanceMapper;

    @Autowired
    private WebMqttComponent webMqttComponent;

    @Autowired
    private IPlanVisual3dService planVisual3dService;

    @Autowired
    private IPlanStepService planStepService;

    private static Map<String, String> stepMap = new HashMap<>();

    @Autowired
    private RuleTrigger ruleTrigger;

    @Value("${spring.application.name}")
    private String serviceName;

    @Value("${plan.instance.personImg}")
    private String personImg;

    @Autowired
    ContingencyAction contingencyAction;

    @Autowired
    private ContingencyLogPublisher contingencyLogPublisher;
    @Autowired
    private PlanDetailMapper planDetailMapper;

    @Autowired
    private ApplicationEventPublisher applicationContext;

    @Autowired
    private IEmergencyTaskService emergencyTaskService;

    @Autowired
    JcsFeign jcsFeign;

    /**
     * 创建预案执行记录
     *
     * @param category    一级分类
     * @param subCategory 二级分类
     * @param content     信息内容
     * @param recordType  信息分类
     * @param icon        信息显示图标
     */
    @Transactional
    public ContingencyPlanInstance createInstanceRecord(String instanceNo, String category, String subCategory, String content, String recordType, String icon) {
        ContingencyPlanInstance planInstance = new ContingencyPlanInstance();
        if ("MESSAGE".equalsIgnoreCase(recordType)) {
            planInstance.setFileType(PlanReplyMessageEnum.TEXT.getCode());
        }
        planInstance.setContent(content);
        planInstance.setIcon(icon);
        planInstance.setRecordType(recordType);
        planInstance.setCategory(category);
        planInstance.setBatchNo(instanceNo);
        planInstance.setCreateDate(new Date());
        if ("OPERATE".equalsIgnoreCase(recordType)) {
            JSONObject obj = JSON.parseObject(content);
            planInstance.setStepCode(String.valueOf(obj.get("stepCode")));
        }
        //计算序号
        int count = repository.countByBatchNo(instanceNo);
        planInstance.setSort(++count);
        ContingencyPlanInstance contingencyPlanInstance = contingencyInstance.updateExtendColumn(planInstance);
        Integer num = contingencyPlanInstanceMapper.getPlanInstanceCountByCondition(contingencyPlanInstance.getCategory(),
                contingencyPlanInstance.getRecordType(),
                contingencyPlanInstance.getBatchNo(),
                contingencyPlanInstance.getContent());
        ContingencyPlanInstance instance = new ContingencyPlanInstance();
        if (0 == num) {
            instance = this.repository.save(contingencyPlanInstance);
        }
        //  异步数据同步之消息发送
//        contingencyPlanInstanceDataSync(instance);
        return instance;
    }

//    private void contingencyPlanInstanceDataSync(ContingencyPlanInstance instance) {
//        if (dataSyncSwitch) {
//            try {
//                dataSyncService.asyncInvoke(() -> {
//                    dataSyncService.syncCreatedContingencyPlanInstance(instance);
//                });
//            } catch (Exception e) {
//                log.info("数据同步之消息发送. [method='{}']", "createInstanceRecord==>syncCreatedContingencyPlanInstance", e);
//            }
//        }
//    }


    /**
     * 查询时间轴
     *
     * @param instanceNo
     * @return
     * @throws Exception
     */
    public List<ContingencyPlanInstance> queryForTimeLine(String instanceNo, String recordType) throws Exception {
        List<ContingencyPlanInstance> categorys = repository.queryForCategory(instanceNo, recordType);
        return categorys;
    }

    @Transactional
    public Optional<Equipment> fire(String batchNo, String stepCode, String contingencyPlanId, String buttonCode, String buttonState, String stepStateOnbutton) throws Exception {
        //火灾误报
        ContingencyOriginalData contingencyOriginalData = iContingencyOriginalDataDao.findByBatchNo(batchNo);

        String stepKey = batchNo + "_" + stepCode;
        if (stepMap.get(stepKey) == null)
            stepMap.put(stepKey, "");
        Equipment equipment;
        if (contingencyOriginalData != null) {
            log.info("数据库中的stepcode:" + contingencyOriginalData.getStep());
            contingencyOriginalData.setConfirm(buttonState);
            contingencyOriginalData.setRunstep(false);
            if (contingencyOriginalData.getStepState() == null)
                contingencyOriginalData.setStepState("");

            if ("CONFIRM".equals(buttonState)
                    && !contingencyOriginalData.getStepState().contains(stepStateOnbutton)
                    && stepCode.equals(contingencyOriginalData.getStep()))
                contingencyOriginalData.setStepState(contingencyOriginalData.getStepState() + stepStateOnbutton);

            //请求中的步骤小于以保存的步骤
//            if (Integer.parseInt(stepCode) < Integer.parseInt(contingencyOriginalData.getStep())) {
//                contingencyOriginalData.setRunstep(true);
//            }

            if (Integer.parseInt(stepCode) > Integer.parseInt(contingencyOriginalData.getStep())) {
                contingencyOriginalData.setStepState(stepStateOnbutton);
            }
            int update = iContingencyOriginalDataDao.updateByButton(
                    contingencyOriginalData.getConfirm(),
                    contingencyOriginalData.getRunstep(),
                    contingencyOriginalData.getStepState(),
                    batchNo
            );

            //  异步数据同步之消息发送 暂时屏蔽 原数字化1.0 同步数据
            //contingencyOriginalDataDataSync(batchNo, update);

            //使用原始数据触发规则
            if ("CONFIRM".equals(buttonState)
                    && !stepMap.get(stepKey).contains(stepStateOnbutton))
                stepMap.put(stepKey, stepMap.get(stepKey) + stepStateOnbutton);

            ContingencyRo contingencyRo = new ContingencyRo();
            contingencyRo.setButtonCode(buttonCode);
            contingencyRo.setButtonState(buttonState);

            ContingencyInstanceInfoVO infoVO = contingencyInstanceInfoService.selectDisposalDetails(batchNo);
            if (!ObjectUtils.isEmpty(infoVO.getPosition())) {
                contingencyOriginalData.setPosition(infoVO.getPosition());
            }

            BeanUtils.copyProperties(contingencyOriginalData, contingencyRo);
            contingencyRo.setStep(stepCode);
            contingencyRo.setStepState(stepMap.get(stepKey));
            String isMock = redisTemplate.boundValueOps("isMock").get(0, -1);
            if (isMock != null) {
                contingencyRo.setIsMock("true".equals(isMock));
            } else {
                contingencyRo.setIsMock(false);
            }
            log.info("stepstate:" + contingencyRo.getStepState());
            log.info("stepCode:" + stepCode);
            equipment = impAndFireEquipMapper.queryImpEqumtByFireEquipmt(Long.parseLong(contingencyRo.getFireEquipmentId()));
            if (equipment != null) {
                contingencyRo.setEquipmentCode(equipment.getCode());
                Map<String, Object> params = contingencyRo.getParams();
                params.put("appKey", RequestContext.getAppKey());
                params.put("product", RequestContext.getProduct());
                params.put("token", RequestContext.getToken());

                contingencyRo.setParams(params);

                List<String> plan = this.getNumberPlan(Long.parseLong(contingencyRo.getEquipmentId()));
//                contingencyRo.setRunstep(false);
                ruleTrigger.publish(contingencyRo, "换流站消防专项预案/" + plan.get(0), ArrayUtils.toArray(equipment.getName()));

                publisherPlanLog(stepCode, buttonCode, batchNo);
            }
        } else {
            throw new Exception("数据异常,请联系管理员.");
        }
        return Optional.ofNullable(equipment);
    }
    // 异步数据同步之消息发送 暂时屏蔽 原数字化1.0 同步数据
    private void contingencyOriginalDataDataSync(String batchNo, int update) {
        if (update > 0 && dataSyncSwitch) {
            try {
                dataSyncService.asyncInvoke(() -> {
                    Map<String, Object> map = new HashMap<>();
                    map.put("batchNo", batchNo);
                    List<ContingencyOriginalDataSyncBo> contingencyOriginalDataBoList = contingencyOriginalMapper.getContingencyOriginalDataBoList(map);
                    dataSyncService.syncCreatedContingencyOriginalDataSyncBo(contingencyOriginalDataBoList);
                });
            } catch (Exception e) {
                log.info("数据同步之消息发送. [method='{}']", "fire==>syncCreatedContingencyOriginalDataSyncBo", e);
            }
        }
    }

    private void publisherPlanLog(String stepCode, String buttonCode, String batchNo) {
        ContingencyEvent event = new ContingencyEvent(this);
        JSONObject json = new JSONObject();
        JSONObject msgContext = new JSONObject();
        JSONObject content = new JSONObject();
        content.put("stepCode", stepCode);
        content.put("buttonCode", buttonCode);
        msgContext.put("type", "clickEvent");
        msgContext.put("content", content);
        json.put("msgType", "message");
        json.put("msgContext", msgContext);
        event.setMsgBody(json.toJSONString());
        String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
        event.setTopic(topic);
        event.setMsgType("clickEvent");
        event.setContingency(batchNo);
        contingencyLogPublisher.publish(event);
    }

    @Transactional
    public void setButtonExecuted(String batchNo, String contingencyPlanId, String code, String buttonState,String user) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ContingencyPlanInstance contingencyPlanInstance = contingencyInstance.getMessageById(contingencyPlanId);
        if (contingencyPlanInstance != null) {
            if ("OPERATE".equals(contingencyPlanInstance.getRecordType())) {

                String operateJson = contingencyPlanInstance.getContent();
                if(user != null) {
                    contingencyPlanInstance.setStartUserName(user);
                }
                OperateGroup operateGroup = objectMapper.readValue(operateJson, OperateGroup.class);

                List<Operate> operates = operateGroup.getOperate();
                if (!CollectionUtils.isEmpty(operates)) {
                    for (Operate operate : operates) {
//                        if (code.equals(operate.getCode()) && ("executed".equals(operate.getState()) || "disable".equals(operate.getState()))) {
                        if (code.equals(operate.getCode()) && ("executed".equals(operate.getState()))) {
                            if ("FIRE_CANCEL".equals(code) || "END_EMERGENCY".equals(code)) {
                                redisTemplate.delete(RiskSourceServiceImpl.cacheKeyForCanBeRunning());
                            }
                            throw new Exception("请勿重复操作.");
                        }
                    }
                }

                operateJson = objectMapper.writeValueAsString(operateGroup);
                contingencyPlanInstance.setContent(operateJson);
                if (buttonState.equals("CONFIRM")) {
                    contingencyPlanInstance.setRunstate(true);
                    if (code.endsWith("_NOT")) {
                        contingencyPlanInstance.setRunstate(false);
                        //  满足移动端确认按钮展示，确认后，多按钮json只保留最后一个按钮
                        planVisual3dService.updateStatusByIdWeb(contingencyPlanInstance, false);
                    } else {
                        //  满足移动端确认按钮展示，确认后，多按钮json只保留最后一个按钮
                        planVisual3dService.updateStatusByIdWeb(contingencyPlanInstance, true);
                    }
                }
                ContingencyPlanInstance instance = repository.save(contingencyPlanInstance);
                if (buttonState.equals("CONFIRM")) {
                    String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                    Map<String, Object> map = new HashMap<>();
                    map.put("contingency", new ContingencyRo());
                    map.put("msgContext", Collections.EMPTY_MAP);
                    map.put("msgType", "operateConfirmMessage");
                    webMqttComponent.publish(topic, JSON.toJSONString(map));
                }
                if (buttonState.equals("CANCEL_0")) {
                    String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                    System.out.println("=========================> 规则触发  初始化动作 initOperate ");
                    Map<String, Object> map = new HashMap<>();
                    map.put("contingency", new ContingencyRo());
                    map.put("msgContext", Collections.EMPTY_MAP);
                    map.put("msgType", "initOperate");
                    webMqttComponent.publish(topic, JSON.toJSONString(map));
                }
                //  异步数据同步之消息发送
                //contingencyPlanInstanceDataSync(instance);
                if ("CONFIRM".equals(buttonState) && ("FIRE_CANCEL".equals(code) || "END_EMERGENCY".equals(code))) {
                    redisTemplate.delete(RiskSourceServiceImpl.cacheKeyForCanBeRunning());
                    // 应急处置中断，初始化planStep，json数据
                    planStepService.initPlanStep();
                    planStepService.initPlanTask();
                    // 应急处置中断，更新预案信息表结束时间
                    contingencyInstanceInfoService.updateEndTimeById(batchNo);
                }
            }
        }

    }

    public void setButtonWait(String batchNo, String contingencyPlanId, String buttonState) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        Optional<ContingencyPlanInstance> contingencyPlanInstance1 = repository.findById(contingencyPlanId);
        ContingencyPlanInstance contingencyPlanInstance = null;
        if (contingencyPlanInstance1.isPresent()) {
            contingencyPlanInstance = contingencyPlanInstance1.get();
        }

        if (contingencyPlanInstance != null && "OPERATE".equals(contingencyPlanInstance.getRecordType())) {
            String operateJson = contingencyPlanInstance.getContent();
            OperateGroup operateGroup = objectMapper.readValue(operateJson, OperateGroup.class);

            List<Operate> operates = operateGroup.getOperate();
            if (!CollectionUtils.isEmpty(operates)) {
                for (Operate operate : operates) {

                    if ("CONFIRM".equals(buttonState)) {
                        operate.setState("executed");
                    }
                }
            }

            if (buttonState.equals("CONFIRM")) {
                contingencyPlanInstance.setRunstate(true);
            }
            operateJson = objectMapper.writeValueAsString(operateGroup);
            contingencyPlanInstance.setContent(operateJson);
            ContingencyPlanInstance instance = repository.save(contingencyPlanInstance);
            //  异步数据同步之消息发送
//            contingencyPlanInstanceDataSync(instance);
        }
    }


    @Override
    public void updateStep(String step, String batchNo) {
        int update = iContingencyOriginalDataDao.updateByButtonStep(step, batchNo);
        emergencyTaskService.saveTask(step, batchNo);
        //  异步数据同步之消息发送
        // contingencyOriginalDataDataSync(batchNo, update);
    }

    @Override
    public Optional<Equipment> fire(String batchNo, String stepCode, String buttonJson, String contingencyPlanId, String buttonCode, String buttonState, String stepStateOnbutton, String isExecute, String isAuto, String token, String product, String appKey,String startUserName) throws Exception {
//        Map<String, String> map = new HashMap<>();
//        map.put("batchNo", batchNo);
//        map.put("stepCode", stepCode);
//        map.put("buttonCode", buttonCode);
//        map.put("confirm", buttonState);
//        map.put("contingencyPlanId", contingencyPlanId);
//        map.put("stepState", stepStateOnbutton);
//        //  是否执行
//        map.put("isExecute", isExecute);
//        //  是否自动执行
//        map.put("isAuto", isAuto);
//        if(startUserName != null) {
//            map.put("startUserName", startUserName);
//        }
//        map.put("buttonJson", buttonJson);
//        map.put("appKey", RequestContext.getAppKey());
//        map.put("token", RequestContext.getToken());
//        map.put("product", RequestContext.getProduct());


        PlanExecuteVo vo = new PlanExecuteVo();
        vo.setConfirm(buttonState);
        vo.setStepState(stepStateOnbutton);
        vo.setBatchNo(batchNo);
        vo.setStepCode(stepCode);
        vo.setButtonCode(buttonCode);
        vo.setContingencyPlanId(contingencyPlanId);
        vo.setButtonJson(buttonJson);
        vo.setIsAuto(isAuto);
        vo.setIsExecute(isExecute);

        ContingecyExecEvent fireEvent = new ContingecyExecEvent(this);
        fireEvent.setEventType(EventType.FIRE_NEXT_RULE.name());
        fireEvent.setPlanExecute(vo);
        fireEvent.setContext(RequestContext.cloneRequestContext());
        applicationContext.publishEvent(fireEvent);
        ContingecyExecEvent updateEvent = new ContingecyExecEvent(this);
        updateEvent.setEventType(EventType.UPDATE_CONTINGENCY_DATE.name());
        updateEvent.setPlanExecute(vo);
        updateEvent.setContext(RequestContext.cloneRequestContext());
        // TODO 构建event对象，
        try {
            applicationContext.publishEvent(updateEvent);
        } catch (Exception e) {
            e.printStackTrace();
        }


        // 下面代码之后去掉。
//        fireQueue.addLast(map);
        //应急指挥给总部推送消息
//        sendPlanAlarm(batchNo, buttonCode);
        return Optional.empty();
    }

    @Override
    public Optional<Equipment> clickButton(String batchNo, String stepCode, String buttonJson, String contingencyPlanId, String buttonCode, String buttonState, String stepStateOnbutton, String isExecute, String isAuto, String token, String product, String appKey,String startUserName) throws Exception {
//        String json;
//        try {
//            json = IOUtils.toString(planStepNodeResource.getInputStream(), String.valueOf(StandardCharsets.UTF_8));
//        } catch (IOException e) {
//            throw new RuntimeException("获取预案节点信息失败！");
//        }

        if ("0".equals(stepCode)) {
            contingencyInstance.fire(batchNo, stepCode, buttonJson, contingencyPlanId,
                    "FIRE_CONFIRM", buttonState, stepStateOnbutton, "true", "false", token,
                    product, appKey, startUserName);
        }

//        JSONObject jsonObject = JSONObject.parseObject(json);
//        List<String> nodes = Arrays.stream(jsonObject.get("nodes").toString().split(",")).collect(Collectors.toList());
//        List<String> strs = nodes.stream().filter(x -> x.equals(stepCode)).collect(Collectors.toList());

        ContingencyPlanInstance instance = contingencyPlanInstanceMapper.getMessageById(contingencyPlanId);
        instance.setId(null);
        instance.setRecordType("REPLYMESSAGE");
        instance.setCreateDate(new Date());
        instance.setContent(instance.getCategory());
        ContingencyPlanInstance res = repository.save(instance);
        if (!ObjectUtils.isEmpty(res)) {
            List<EmergencyTaskContentVo> mustTasks = emergencyTaskService.getMustTaskList(stepCode);
            boolean flag = judgeIfConfirmed(mustTasks, batchNo);
            if (!"-1".equals(stepCode) && flag) {
                PlanExecuteVo vo = new PlanExecuteVo();
                vo.setConfirm(buttonState);
                vo.setStepState(stepStateOnbutton);
                vo.setBatchNo(batchNo);
                vo.setStepCode(stepCode);
                vo.setButtonCode(buttonCode);
                vo.setContingencyPlanId(contingencyPlanId);
                vo.setButtonJson(buttonJson);
                vo.setIsAuto(isAuto);
                vo.setIsExecute(isExecute);

                ContingecyExecEvent fireEvent = new ContingecyExecEvent(this);
                fireEvent.setEventType(EventType.FIRE_NEXT_RULE.name());
                fireEvent.setPlanExecute(vo);
                fireEvent.setContext(RequestContext.cloneRequestContext());
                applicationContext.publishEvent(fireEvent);
                ContingecyExecEvent updateEvent = new ContingecyExecEvent(this);
                updateEvent.setEventType(EventType.UPDATE_CONTINGENCY_DATE.name());
                updateEvent.setPlanExecute(vo);
                updateEvent.setContext(RequestContext.cloneRequestContext());
                try {
                    applicationContext.publishEvent(updateEvent);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String planStep = "";
                if (redisTemplate.hasKey("planStep")) {
                    planStep = Objects.requireNonNull(redisTemplate.opsForValue().get("planStep")).toString();
                } else {
                    planStep = planStepService.getPlanStep();
                }
                JSONArray objects = JSON.parseArray(planStep);
                String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                Map<String, Object> result = new HashMap<>();
                result.put("contingency", new ContingencyRo());
                result.put("msgContext", Collections.EMPTY_MAP);
                result.put("msgType", "getStepList");
                result.put("planStep", objects);
                String planTask = "";
                if (redisTemplate.hasKey("planTask")) {
                    planTask = Objects.requireNonNull(redisTemplate.opsForValue().get("planTask")).toString();
                } else {
                    List<ContingencyPlanInstanceVO> lists = planVisual3dService.getTaskActionList(batchNo, 1);
                    planTask = JSON.toJSONString(lists);
                }
                JSONArray taskObjects = JSON.parseArray(planTask);
                result.put("planTask", taskObjects);
                webMqttComponent.publish(topic, JSON.toJSONString(result));
            }

            String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
            Map<String, Object> map = new HashMap<>();
            map.put("contingency", new ContingencyRo());
            map.put("msgContext", Collections.EMPTY_MAP);
            map.put("msgType", "refreshTaskRecord");
            webMqttComponent.publish(topic, JSON.toJSONString(map));
        }
        return Optional.empty();
    }

    private boolean judgeIfConfirmed(List<EmergencyTaskContentVo> mustTasks, String batchNo) {
        if (0 == mustTasks.size()) {
            return true;
        }
        EmergencyTaskContentVo vo = mustTasks.get(0);
        Integer count = contingencyPlanInstanceMapper.getPlanInstanceByRunState(vo.getStepCode(), batchNo);
        if (0 == count) {
            return true;
        } else {
            return false;
        }
    }

    @Autowired
    List<EventHandler> handlers;

    @Override
    public ContingencyPlanInstance updateExtendColumn(ContingencyPlanInstance contingencyPlanInstance) {
        String recordType = contingencyPlanInstance.getRecordType();
        if ("OPERATE".equals(recordType)) {
            ButtonJsonVO buttonJsonVO = JSONObject.parseObject(contingencyPlanInstance.getContent(), ButtonJsonVO.class);
            Map<String, Object> map = buttonJsonVO.getOperate().get(buttonJsonVO.getOperate().size() - 1);
            contingencyPlanInstance.setRoleCode(planStepService.getPlanStepRoleCodeByButtonCode(map.get("code").toString()));
        } else {
            String appKey = redisTemplate.opsForValue().get("action:appKey").toString();
            String product = redisTemplate.opsForValue().get("action:product").toString();
            String token = redisTemplate.opsForValue().get("action:token").toString();

            if (StringUtils.isBlank(appKey) || StringUtils.isBlank(product) || StringUtils.isBlank(token)) {
                Toke toke = remoteSecurityService.getServerToken();
                RequestContext.setToken(toke.getToke());
                RequestContext.setProduct(toke.getProduct());
                RequestContext.setAppKey(toke.getAppKey());
            } else {
                RequestContext.setAppKey(appKey);
                RequestContext.setProduct(product);
                RequestContext.setToken(token);
            }

            FeignClientResult<AgencyUserModel> feignClientResult = Privilege.agencyUserClient.getme();
            AgencyUserModel user = (AgencyUserModel) feignClientResult.getResult();

//            List<PlanStepJsonVO> result = planStepService.getPlanStepJsonVOS();
//            List<String> roleCode = result.stream().map(PlanStepJsonVO::getRoleCode).distinct().collect(Collectors.toList());
//
//            List<RoleModel> roleModelList = new ArrayList<>();
//            for (Long key : user.getOrgRoles().keySet()) {
//                roleModelList.addAll(user.getOrgRoles().get(key));
//            }
//            List<String> roleCodeList = new ArrayList<>();
//            List<String> roleNameList = new ArrayList<>();
//            List<String> realRoleCode = roleModelList.stream().map(RoleModel::getRoleName).distinct().collect(Collectors.toList());
//            realRoleCode.forEach(item -> {
//                if (roleCode.contains(item)) {
//                    roleCodeList.add(item);
//                }
//            });
//            roleModelList.forEach(item -> {
//                if (!roleNameList.contains(item.getRoleDesc()) && roleCode.contains(item.getRoleName())) {
//                    roleNameList.add(item.getRoleDesc());
//                }
//            });
            String roleCodes = emergencyTaskService.getRolesByUserId(user.getUserId());
            String roleNames = emergencyTaskService.getRolesNameByUserId(user.getUserId());
            List<String> roleCodeList = Arrays.asList(roleCodes.split(","));
            List<String> roleNameList = Arrays.asList(roleNames.split(","));

            contingencyPlanInstance.setRoleCode(String.join("-", roleCodeList));
            contingencyPlanInstance.setRoleName(String.join("-", roleNameList));
            contingencyPlanInstance.setStartUserId(user.getUserId());
            contingencyPlanInstance.setStartUserName(user.getRealName());
            ResponseModel responseModel = null;
            try {
                responseModel = jcsFeign.getPersonImage(user.getUserId());
            } catch (Exception e) {
                e.printStackTrace();
            }
            String img = null;
            if (responseModel != null && "SUCCESS".equals(responseModel.getDevMessage())) {
                String resStr = JSON.toJSONString(responseModel.getResult()).replace("\"","");
                img = "null".equalsIgnoreCase(resStr) ? null : img;
            }
            img = StringUtils.isEmpty(img) ? personImg : img;
            contingencyPlanInstance.setPersonImg(img);
        }
        return contingencyPlanInstance;
    }

    private void sendPlanAlarm(String batchNo, String buttonCode) {
        //确警后推送报警数据
        List<FirePlanAlarmBo> list = new ArrayList<FirePlanAlarmBo>();
        if ("FIRE_CONFIRM".equals(buttonCode)) {
            FirePlanAlarmBo firePlanAlarm = view3dMapper.getPlanAlarmInfo(batchNo);
            firePlanAlarm.setWarningState("1");
            list.add(firePlanAlarm);
        } else if ("END_EMERGENCY".equals(buttonCode)) {
            FirePlanAlarmBo firePlanAlarm = view3dMapper.getPlanAlarmInfo(batchNo);
            firePlanAlarm.setWarningState("0");
            firePlanAlarm.setWarningTime(DateUtils.date2LongStr(new Date()));
            list.add(firePlanAlarm);
        }
        if (!ObjectUtils.isEmpty(list)) {
            rocketMQService.sendMsg(rocketTopicFireEquipAlarm, "plan_alarm", list);
        }

    }

    //    @Scheduled(cron = "*/2 * * * * ?")
    public void runFireQueue() throws Exception {

        if (fireQueue.size() == 0)
            return;

        Map<String, String> map = fireQueue.getFirst();
        String batchNo = map.get("batchNo");
        String stepCode = map.get("stepCode");
        String buttonCode = map.get("buttonCode");
        String confirm = map.get("confirm");
        String contingencyPlanId = map.get("contingencyPlanId");
        String stepState = map.get("stepState");
        String isExecute = map.get("isExecute");
        String isAuto = map.get("isAuto");
        String buttonJson = map.get("buttonJson");
        String appKey = map.get("appKey");
        String product = map.get("product");
        String token = map.get("token");
        String user = map.containsKey("startUserName")  ? map.get("startUserName") : null;
        try {
            RequestContext.setAppKey(appKey);
            RequestContext.setProduct(product);
            RequestContext.setToken(token);
            fire(batchNo, stepCode, contingencyPlanId, buttonCode, confirm, stepState);

            //  更新redis中预案步骤数据
            planVisual3dService.updatePlanStepToRedis(batchNo, stepCode, buttonJson, contingencyPlanId, buttonCode, isExecute, isAuto);
            setButtonExecuted(batchNo, contingencyPlanId, buttonCode, confirm, user);
        } catch (Exception e) {
            throw e;
        } finally {
            // 更新记录之后发送消息刷新
            String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
            Map<String, Object> result = new HashMap<>();
            result.put("contingency", new ContingencyRo());
            result.put("msgContext", Collections.EMPTY_MAP);
            result.put("msgType", "refreshRecord");
            webMqttComponent.publish(topic, JSON.toJSONString(result));
            fireQueue.removeFirst();
        }
    }

    public List<String> getNumberPlan(Long id) {
        List<String> ruleId = planDetailMapper.getRuleIdByEquipment(id);
        return ruleId;
    }

    @Override
    public ContingencyPlanInstance getMessageById(String id) {
        return contingencyPlanInstanceMapper.getMessageById(id);
    }

    @Override
    public String getInstanceIdByBatchNOAndCategory(String type, String name, String batchNo) {
        return contingencyPlanInstanceMapper.getInstanceIdByBatchNOAndCategory(type, name, batchNo);
    }

}

