package com.yeejoin.amos.fas.business.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.fas.business.dao.mapper.ContingencyInstanceInfoMapper;
import com.yeejoin.amos.fas.business.service.intfc.ContingencyInstanceInfoService;
import com.yeejoin.amos.fas.business.vo.ContingencyInstanceInfoVO;
import com.yeejoin.amos.fas.business.vo.ContingencyPlanInstanceVO;
import com.yeejoin.amos.fas.core.util.DateUtil;
import com.yeejoin.amos.fas.dao.entity.ContingencyInstanceInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.Date;
import java.util.List;


@Service("contingencyInstanceInfoService")
public class ContingencyInstanceInfoServiceImpl implements ContingencyInstanceInfoService {

    @Autowired
    private ContingencyInstanceInfoMapper contingencyInstanceInfoMapper;


    @Override
    public ContingencyInstanceInfoVO selectDisposalDetails(String disposalId) {
        ContingencyInstanceInfoVO instanceInfo = contingencyInstanceInfoMapper.selectDisposalDetails(disposalId);
        if (!ObjectUtils.isEmpty(instanceInfo.getStartTime()) && !ObjectUtils.isEmpty(instanceInfo.getEndTime())){
            String datePoorToMin = getDatePoorToMin(instanceInfo.getEndTime(), instanceInfo.getStartTime());
            instanceInfo.setDuration(datePoorToMin);
        }
        return instanceInfo;
    }

    @Override
    public Page<ContingencyInstanceInfoVO> selectDisposalListPage(int current, int size, String orgCode) {
        Page<ContingencyInstanceInfoVO> page = new Page<>(current, size);
        int total = contingencyInstanceInfoMapper.selectCount(orgCode);
        page.setTotal(total);
        long start = (page.getCurrent() - 1) * page.getSize();
        if (total == 0) {
            page.setCurrent(1);
        } else {
            if (total < start) {
                page.setCurrent(1);
                start = 0;
            }
            List<ContingencyInstanceInfoVO> infoList = contingencyInstanceInfoMapper.selectDisposalListPage((int) start, size, orgCode);
            for (ContingencyInstanceInfoVO instanceInfo : infoList) {
                if (!ObjectUtils.isEmpty(instanceInfo.getStartTime()) && !ObjectUtils.isEmpty(instanceInfo.getEndTime())){
                    String datePoorToMin = getDatePoorToMin(instanceInfo.getEndTime(), instanceInfo.getStartTime());
                    instanceInfo.setDuration(datePoorToMin);
                }
            }
            page.setRecords(infoList);
        }
        return page;
    }

    @Override
    public Boolean addDisposalDetails(ContingencyInstanceInfo contingencyInstanceInfo) {
        contingencyInstanceInfo.setIsDelete(false);
        contingencyInstanceInfo.setCreateDate(DateUtil.getDateNow());
        return contingencyInstanceInfoMapper.addDisposalDetails(contingencyInstanceInfo);
    }

    @Override
    public Boolean updateDisposalDetails(ContingencyInstanceInfo contingencyInstanceInfo) {
        return contingencyInstanceInfoMapper.updateDisposalDetails(contingencyInstanceInfo);
    }

    @Override
    public Boolean updateEndTimeById(String id) {
        ContingencyInstanceInfoVO instanceInfoVO = selectDisposalDetails(id);
        ContingencyInstanceInfo instanceInfo = new ContingencyInstanceInfo();
        BeanUtils.copyProperties(instanceInfoVO, instanceInfo);
        if (instanceInfo != null) {
            instanceInfo.setEndTime(new Date());
            return contingencyInstanceInfoMapper.updateDisposalDetails(instanceInfo);
        }
        return false;
    }
    public static String getDatePoorToMin(Date endDate, Date nowDate) {

	    long nd = 1000 * 24 * 60 * 60;
        long nh = 1000 * 60 * 60;
        long nm = 1000 * 60;
        long ns = 1000;
        // 获得两个时间的毫秒时间差异
        long diff = endDate.getTime() - nowDate.getTime();
        // 计算差多少天
	    long day = diff / nd;
        // 计算差多少小时
        long hour = diff / nh;
        // 计算差多少分钟
        long min = diff % nh / nm;
        // 计算差多少秒//输出结果
         long sec = diff % nd % nh % nm / ns;
        return hour + "小时" + min + "分钟 " + sec + "秒";
    }

}
