package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.service.intfc.IDataSyncService;
import com.yeejoin.amos.fas.business.util.DataSyncUtil;
import com.yeejoin.amos.fas.common.enums.DataSyncOperationEnum;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.datasync.bo.ContingencyOriginalDataSyncBo;
import com.yeejoin.amos.fas.datasync.bo.PlanDetailSyncBo;
import com.yeejoin.amos.fas.datasync.bo.PlanOperationRecordSyncBo;
import com.yeejoin.amos.fas.datasync.message.DataSyncMessage;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ProjectName: YeeAMOSPatrolRoot
 * @Package: com.yeejoin.amos.patrol.business.service.impl
 * @ClassName: DataSyncServiceImpl
 * @Author: Jianqiang Gao
 * @Description: DataSyncServiceImpl
 * @Date: 2022/5/30 10:48
 * @Version: 1.0
 */
@Service
public class DataSyncServiceImpl implements IDataSyncService {

    @Autowired
    private EmqKeeper emqKeeper;

    @Override
    public void asyncInvoke(AsyncExec consumer) throws Exception {
        consumer.exec();
    }

    @Override
    public void syncCreatedPlanDetailSyncBo(PlanDetailSyncBo planDetailSyncBo) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(planDetailSyncBo, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncCreatedPlanDetailSyncBo(Collection<PlanDetailSyncBo> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedPlanDetailSyncBo(Collection<Long> ids) {
        List<PlanDetailSyncBo> list = ids.stream().map(id -> {
            PlanDetailSyncBo planDetailSyncBo = new PlanDetailSyncBo();
            planDetailSyncBo.setId(id);
            return planDetailSyncBo;
        }).collect(Collectors.toList());
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedPlanDetailSyncBo(Long id) {
        PlanDetailSyncBo planDetailSyncBo = new PlanDetailSyncBo();
        planDetailSyncBo.setId(id);
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(planDetailSyncBo, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncUpdatedPlanDetailSyncBo(Collection<PlanDetailSyncBo> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.UPDATE);
        sendMessage(message);
    }

    @Override
    public void syncCreatedPlanOperationRecordSyncBo(PlanOperationRecordSyncBo planTaskDetailBo) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(planTaskDetailBo, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncCreatedPlanOperationRecordSyncBo(Collection<PlanOperationRecordSyncBo> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedPlanOperationRecordSyncBo(Collection<Long> ids) {
        List<PlanOperationRecordSyncBo> list = ids.stream().map(id -> {
            PlanOperationRecordSyncBo planOperationRecordSyncBo = new PlanOperationRecordSyncBo();
            planOperationRecordSyncBo.setId(id);
            return planOperationRecordSyncBo;
        }).collect(Collectors.toList());
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedPlanOperationRecordSyncBo(Long id) {
        PlanOperationRecordSyncBo planOperationRecordSyncBo = new PlanOperationRecordSyncBo();
        planOperationRecordSyncBo.setId(id);
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(planOperationRecordSyncBo, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncUpdatedPlanOperationRecordSyncBo(Collection<PlanOperationRecordSyncBo> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.UPDATE);
        sendMessage(message);
    }

    @Override
    public void syncCreatedContingencyOriginalDataSyncBo(ContingencyOriginalDataSyncBo contingencyOriginalDataSyncBo) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(contingencyOriginalDataSyncBo, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncCreatedContingencyOriginalDataSyncBo(Collection<ContingencyOriginalDataSyncBo> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedContingencyOriginalDataSyncBo(Collection<String> ids) {
        List<ContingencyOriginalDataSyncBo> list = ids.stream().map(id -> {
            ContingencyOriginalDataSyncBo contingencyOriginalDataSyncBo = new ContingencyOriginalDataSyncBo();
            contingencyOriginalDataSyncBo.setId(id);
            return contingencyOriginalDataSyncBo;
        }).collect(Collectors.toList());
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedContingencyOriginalDataSyncBo(String id) {
        ContingencyOriginalDataSyncBo checkBo = new ContingencyOriginalDataSyncBo();
        checkBo.setId(id);
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(checkBo, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncUpdatedContingencyOriginalDataSyncBo(Collection<ContingencyOriginalDataSyncBo> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.UPDATE);
        sendMessage(message);
    }

    @Override
    public void syncCreatedContingencyPlanInstance(ContingencyPlanInstance contingencyPlanInstance) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(contingencyPlanInstance, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncCreatedContingencyPlanInstance(Collection<ContingencyPlanInstance> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.CREATE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedContingencyPlanInstance(Collection<String> ids) {
        List<ContingencyPlanInstance> list = ids.stream().map(id -> {
            ContingencyPlanInstance contingencyPlanInstance = new ContingencyPlanInstance();
            contingencyPlanInstance.setId(id);
            return contingencyPlanInstance;
        }).collect(Collectors.toList());
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncDeletedContingencyPlanInstance(String id) {
        ContingencyPlanInstance contingencyPlanInstance = new ContingencyPlanInstance();
        contingencyPlanInstance.setId(id);
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(contingencyPlanInstance, DataSyncOperationEnum.DELETE);
        sendMessage(message);
    }

    @Override
    public void syncUpdatedContingencyPlanInstance(Collection<ContingencyPlanInstance> list) {
        DataSyncMessage message = DataSyncUtil.buildSyncMessage(list, DataSyncOperationEnum.UPDATE);
        sendMessage(message);
    }

    private void sendMessage(DataSyncMessage message) {
        try {
            emqKeeper.getMqttClient().publish(message.getType().getMqTopic(), message.message2Bytes(), 2, false);
        } catch (MqttException e) {
            e.printStackTrace();
        }
        //暂时屏蔽同步时存储redis
        //redisTemplate.opsForValue().set(message.redisKey(), new String(message.message2Bytes()));
    }
}