package com.yeejoin.amos.fas.business.action;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.result.BubbleTipResult;
import com.yeejoin.amos.fas.business.action.result.message.ActionResultMessage;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
/**
 * 
 * <pre>
 * 风险态势图动作
 * </pre>
 *
 * @author amos
 * @version $Id: RiskSituationAction.java, v 0.1 2019年5月16日 下午5:26:27 amos Exp $
 */
@Component
public class RiskSituationAction implements CustomerAction
{
	private static String PACKAGEURL = "com.yeejoin.amos.rule.map.action.result.message.";
	
	//@ExposeAction("气泡提示")
	public void sendBubbleTip(Object bizobj, Boolean showInfo, String title)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		tempmap1.put("bizobj", bizobj);
		result.add(tempmap1);
		//是否显示气泡
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("showInfo", showInfo);
		result.add(tempmap2);
		//显示title提示
		Map<String, Object> tempmap3 = new HashMap<>();
		tempmap3.put("title", title);
		result.add(tempmap3);
		
		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			ActionResultMessage<?> action = (ActionResultMessage<?>) constructor.newInstance(result);
			String firstStr = "fromws";
			String secondStr = "riskSituation";
			String thirdStr = "bubble";
			Object obj = action.execute(firstStr, secondStr, thirdStr);
			result.setToipResponse((ToipResponse) obj);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
	//@ExposeAction("区域颜色改变")
	public void regionChange(Object bizobj, String colour)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		tempmap1.put("bizobj", bizobj);
		result.add(tempmap1);
		//更改颜色
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("colour", colour);
		result.add(tempmap2);
		
		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			ActionResultMessage<?> action = (ActionResultMessage<?>) constructor.newInstance(result);
			String firstStr = "fromws";
			String secondStr = "riskSituation";
			String thirdStr = "colour";
			Object obj = action.execute(firstStr, secondStr, thirdStr);
			result.setToipResponse((ToipResponse) obj);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}


	//@ExposeAction(value = "区域闪烁",snapshot = false)
	public void regionFlicker(Object bizobj, Integer frequency)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		tempmap1.put("bizobj", bizobj);
		result.add(tempmap1);
		//更改颜色
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("frequency", frequency);
		result.add(tempmap2);

		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			ActionResultMessage<?> action = (ActionResultMessage<?>) constructor.newInstance(result);
			String firstStr = "fromws";
			String secondStr = "riskSituation";
			String thirdStr = "flicker";
			Object obj = action.execute(firstStr, secondStr, thirdStr);
			result.setToipResponse((ToipResponse) obj);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
}
