package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.FireStation;
import com.yeejoin.amos.fas.dao.entity.FireStationFireEquipment;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

public interface IFireStationService {

    /**
     * 保存或者更新风险点
     * @param fireStation
     * @return
     */
    FireStation save(FireStation fireStation);
    
    /**
     * 保存或者更新消防小室
     * @param fireStation
     * @return
     */
    FireStation saveAndUpd(FireStation fireStation,MultipartFile[] file);

    /**
     * 关联消防设备
     * @param fireStationFireEquipments
     * @return
     */
    List<FireStationFireEquipment>  saveStationFireEquipment(List<FireStationFireEquipment> fireStationFireEquipments) throws Exception;


    /**
     * 查询单个风险点
     * @param id
     * @return
     */
    Map queryOne(Long id);

    /**
     * 查询已经绑定的消防设备列表
     * @param fireStationId
     * @return
     */
    Page queryForFireEquemtPage(Long fireStationId,CommonPageable pageable);
    void deleteStationFireEquipment(List<FireStationFireEquipment> fireStationFireEquipments) throws Exception;

    /**
     * 删除单个风险点
     * @return
     * @throws Exception
     */
    String [] delete(String[] idArray) throws Exception;


    /**
     * 查询指定设备的风险点列表
     * @return
     */
    Page queryForPage(String username, String code,String type, CommonPageable pageable);


    List<Map> queryForList(String username, String code,String type);
    
    /**
     * 获取消防小室配置装备数据
     * @param id
     * @return
     */
    Map queryForEuqimentListById(Long id);

}
