package com.yeejoin.amos.fas.business.service.intfc;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.fas.business.bo.BindPointBo;
import com.yeejoin.amos.fas.business.bo.SafetyExecuteBo;
import com.yeejoin.amos.fas.business.vo.ExceptionRegionVo;
import com.yeejoin.amos.fas.business.vo.SafetyIndexDetailVo;
import com.yeejoin.amos.fas.business.vo.TodaySafetyIndexVo;
import com.yeejoin.amos.fas.business.vo.View3dNodeVo;
import com.yeejoin.amos.fas.core.common.response.Node3DVoResponse;
import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;
import com.yeejoin.amos.fas.core.util.CommonResponse;

/**
 * @author DELL
 */
public interface IView3dService {

    /**
     * 区域绑定保存
     * @param pointBoList 数组
     * @return 空
     */
    CommonResponse setPoint3dPosition(List<BindPointBo> pointBoList);

    /**
     * 点类型查询
     * @return list
     */
	List<Map<String, String>> getPointType();

    /**
     * 按照分类查询点树
     * @param type 树类型字典值
     * @param orgCode 登陆机构
     * @return list
     */
	List<RegionTreeResponse> getPointTreeByType(String type,String orgCode,String channelType);

	/**
	 * 获取点详情
	 * @param type	树类型
	 * @param pointId 点id
	 * @param orgCode 登录机构
	 * @return
	 */
	HashMap<String, Object> getPointDetailByTypeAndId(String type, Long pointId,String orgCode);

    /**
     * 今日安全指数
     * @param orgCode 登陆机构
     * @param date 日期
     * @return TodaySafetyIndexVo
     */
    TodaySafetyIndexVo getSafetyIndexInfoByDate(String orgCode, String date);

    /**
     * 今日安全指数详情
     * @param type 详情类型
     * @return list
     */
    List<SafetyIndexDetailVo> getSafetyIndexDetail(String type,String orgCode);

    /**
     * 一周安全指数趋势查询
     * @param orgCode
     * @return
     */
	List<HashMap<String, Object>> getSafetyIndexWeek(String orgCode);

	/**
	 * 查询上线日期时间
	 * @return  eg:10年3月2天
	 */
	/**
	 * 查询上线日期时间
	 * @param orgCode :登录机构
	 * @return eg:10年3月2天
	 */
	Map<String, Object> getSystemOnlineDate(String orgCode);


	List<ExceptionRegionVo> getExceptionRegion(String orgCode);
	
	/**
	 * 今日巡检统计接口
	 * @param orgCode
	 * @return
	 */
	List<Map<String, Object>> getStatisticsCheck(String orgCode);

	/**
	 * 最新五条异常
	 * @param type
	 * @param orgCode
	 * @return
	 */
	List<SafetyExecuteBo> getSafetyExecuteListTop5(String type, String orgCode);

	/**
	 * 今日值班统计
	 * @return
	 */
	CommonResponse getStatisticsDuty(String appKey, String product, String orgCode);

	/**
	 * 设备状态消息最新5条
	 * @param orgCode
	 * @return
	 */
	List<SafetyExecuteBo> getEquipStatusList(String orgCode);
	
	/**
	 * 左侧菜单(异常点)
	 * @param type
	 * @param orgCode
	 * @param riskSourceId 风险区域
	 * @return
	 */
	List<View3dNodeVo> initViewErrorNode(String type,Long riskSourceId, String orgCode);
	/**
	 * 查询类型的点
	 * @param orgCode 机构
	 * @param model 模式类型
	 * @return list
	 */
	CommonResponse get3dPointsByModel(String orgCode,String model);

	/**
	 * 安全指数流水生成
	 * @param runData 日切日期
	 */
	void safetyIndexLogGenJob(String runData);
	
	/**
	 * 3维异常点查询
	 * @param type
	 * @param orgCode
	 * @param riskSourceId区域id
	 * @return
	 */
	List<Node3DVoResponse> find3dViewDataByType(String type,Long riskSourceId,String orgCode);

	/**
	 * 检索
	 * @param type类型
	 * @param inputText关键字
	 * @param dataLevel风险等级
	 * @param protectObjName设备名称
	 * @param current
	 * @param pageSize
	 * @param orgCode
	 * @return
	 */
	CommonResponse retrieveAll(String type, String inputText, int current, int pageSize,String orgCode,String dataLevel,String protectObjName,String token,String appKey,String product);

	/**
	 * 等级查询
	 * @param type
	 * @return
	 */
	List<Map<String,String>> pointLevelList(String type);
	
}
