package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.param.ImgParam;
import com.yeejoin.amos.fas.business.vo.EquipCommunicationData;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.response.EquipDetailsResponse;
import com.yeejoin.amos.fas.core.util.DaoCriteria;
import com.yeejoin.amos.fas.dao.entity.Equipment;
import com.yeejoin.amos.fas.dao.entity.EquipmentFireEquipment;
import com.yeejoin.amos.fas.dao.entity.PreplanPicture;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

public interface IEquipmentService {


    Equipment save(Equipment equipment);

    Equipment saveImg(MultipartFile file, Equipment equipment, int type, Long userId);

    Equipment saveEquipmentAndImg(ImgParam[] imgs, Equipment equipment);

    Equipment queryOne(Long id);


    /**
     * 删除单个风险点
     *
     * @return
     * @throws Exception
     */
    String[] delete(String[] idArray) throws Exception;


    /**
     * 重点设备分页查询
     *
     * @return
     */
    Page<Equipment> queryImpEquip(List<DaoCriteria> criterias, CommonPageable commonPageable);

    /**
     * 设备现场图查询
     *
     * @return
     */
    List<PreplanPicture> queryImgByIdAndType(List<DaoCriteria> criteriase);

    /**
     * 重点设备查询,下拉使用
     *
     * @return
     */
    List<Equipment> queryEquipNoPage();


    /**
     * 绑定消防设备
     *
     * @param list
     * @return
     * @throws Exception
     */
    List<Map<String, Object>> bindFireEqumt(Long equipmentId, List<EquipmentFireEquipment> list) throws Exception;


    /**
     * 解除绑定
     *
     * @param equipmentId
     */
    List<Long> removeFireEqmtBind(Long equipmentId, String[] fireEquipmentIds);


    /**
     * @param equipmentId
     * @return
     */
    Page queryBindFirEqumtList(CommonPageable commonPageable, Long equipmentId);

    /**
     * 获取重点装备监控设备
     *
     * @return
     */
    List<Map<String, Object>> findEquipVideoList();

    EquipDetailsResponse findEquipDetailsById(String toke,String product,String appKey,Long id);

    /**
     * 获取所有重点装备
     *
     * @return
     */
    List<Equipment> findAll();

    EquipCommunicationData findFireEquipmentByPointCode(String code);

    EquipCommunicationData findFireEquipDataByPointCode(String code);
	int countImpEquipByIds(String[] idArray);

	int countFemaRelation(String[] idArray);

}
