SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for f_accident_type
-- ----------------------------
DROP TABLE IF EXISTS `f_accident_type`;
CREATE TABLE `f_accident_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(100) DEFAULT NULL COMMENT '事故类型',
  `evaluation_sid` bigint(32) DEFAULT NULL COMMENT 'evaluation_model 中 type 为s 的id',
  `influence` varchar(255) DEFAULT NULL COMMENT '失效/事故影响',
  `severity` varchar(255) DEFAULT NULL COMMENT '严重度',
  `dept_id` varchar(255) DEFAULT '0' COMMENT '维护部门',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='事故类型表';

-- ----------------------------
-- Table structure for f_alarm
-- ----------------------------
DROP TABLE IF EXISTS `f_alarm`;
CREATE TABLE `f_alarm` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `fire_equipment_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '消防设备id',
  `metric` text COMMENT '指标',
  `alarm_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '报警时间',
  `alarm_type` varchar(100) DEFAULT NULL COMMENT '报警类别:真实；误报',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='报警信息表';

-- ----------------------------
-- Table structure for f_dict
-- ----------------------------
DROP TABLE IF EXISTS `f_dict`;
CREATE TABLE `f_dict` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `dict_name` varchar(255) DEFAULT NULL COMMENT '名称',
  `dict_code` varchar(255) DEFAULT NULL COMMENT '编码',
  `parent_id` bigint(11) DEFAULT NULL COMMENT '父ID',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否已经删除',
  `dict_value` varchar(255) DEFAULT NULL COMMENT '值',
  `dict_order` bigint(11) DEFAULT NULL COMMENT '序号',
  `remark` longtext COMMENT '说明',
  `dict_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for f_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment`;
CREATE TABLE `f_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `name` varchar(255) DEFAULT NULL COMMENT '设备名称',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3位坐标',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `building` varchar(255) DEFAULT NULL COMMENT '建筑物',
  `room` varchar(255) DEFAULT NULL COMMENT '房间号',
  `address` varchar(255) DEFAULT NULL COMMENT '位置',
  `charge_dept_id` varchar(255) DEFAULT '0' COMMENT '责任部门',
  `charge_user_id` varchar(255) DEFAULT '0' COMMENT '责任人',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `fire_station_id` bigint(20) DEFAULT NULL COMMENT '消防小室id',
  `reserve_plan` varchar(100) DEFAULT NULL COMMENT '预案配置',
  `sort_num` int(11) DEFAULT NULL,
  `fire_truck_route` varchar(255) DEFAULT NULL COMMENT '消防车到重点设备行车路线',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备表';

-- ----------------------------
-- Table structure for f_equipment_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment_fire_equipment`;
CREATE TABLE `f_equipment_fire_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `equipment_id` bigint(20) NOT NULL COMMENT '设备id',
  `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防装备id',
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=970 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备与消防设备关联中间表';

-- ----------------------------
-- Table structure for f_evaluation_model
-- ----------------------------
DROP TABLE IF EXISTS `f_evaluation_model`;
CREATE TABLE `f_evaluation_model` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(100) DEFAULT NULL COMMENT '模型名称',
  `standard` text COMMENT '模型内容',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `coefficient` varchar(50) DEFAULT NULL COMMENT '系数',
  `influence` varchar(500) DEFAULT NULL COMMENT '影响',
  `describe` varchar(500) DEFAULT NULL COMMENT '描述',
  `type` varchar(50) DEFAULT NULL COMMENT '类型：S，D，O',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='评价模型表';

-- ----------------------------
-- Table structure for f_fire_car
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_car`;
CREATE TABLE `f_fire_car` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `dept_id` varchar(255) DEFAULT '0' COMMENT '部门id',
  `type` varchar(255) DEFAULT NULL COMMENT '车辆类别',
  `name` varchar(255) DEFAULT NULL COMMENT '车辆名称',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '楼层',
  `car_num` varchar(255) DEFAULT NULL COMMENT '车牌号',
  `engine_num` varchar(255) DEFAULT NULL COMMENT '发动机号',
  `model` varchar(255) DEFAULT NULL COMMENT '厂牌型号',
  `country` varchar(255) DEFAULT NULL COMMENT '国别',
  `state` varchar(255) DEFAULT NULL COMMENT '车辆状态',
  `performance_index` longtext COMMENT '性能指标',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `photo_path` varchar(1000) DEFAULT NULL COMMENT '消防车图片路径',
  `is_indoor` bit(1) DEFAULT b'1' COMMENT '是否室内点：默认是',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防车表';

-- ----------------------------
-- Table structure for f_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_equipment`;
CREATE TABLE `f_fire_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `equip_classify` int(11) DEFAULT '0' COMMENT '装备分类：0-设备类；1-耗材类;2-视频监控;3-灭火器材',
  `equip_type` varchar(255) DEFAULT NULL COMMENT '装备类型',
  `equip_code` varchar(255) DEFAULT NULL COMMENT '装备编码',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `model` varchar(255) DEFAULT NULL COMMENT '规格型号',
  `maintenance_cycle` int(11) DEFAULT '0' COMMENT '保养周期',
  `manufacturer` varchar(255) DEFAULT NULL COMMENT '厂商',
  `brand` varchar(255) DEFAULT NULL COMMENT '品牌',
  `production_date` date DEFAULT NULL COMMENT '生产日期',
  `effective_date` date DEFAULT NULL COMMENT '有效时间',
  `number` int(11) DEFAULT '0' COMMENT '数量',
  `unit` varchar(255) DEFAULT NULL COMMENT '单位',
  `production_area` varchar(255) DEFAULT NULL COMMENT '区域',
  `room` varchar(255) DEFAULT NULL COMMENT '房间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `equip_status` int(11) DEFAULT '0' COMMENT '设备状态（1，告警； 0，正常; ）',
  `video_url` varchar(255) DEFAULT NULL COMMENT '视频路径',
  `weight` decimal(10,2) DEFAULT '0.00' COMMENT '重量',
  `action_state` varchar(50) DEFAULT '' COMMENT '动作状态',
  `eruption_state` varchar(50) DEFAULT '' COMMENT '喷发状态',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2833 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备表';

-- ----------------------------
-- Table structure for f_fire_equipment_data
-- ----------------------------
-- DROP TABLE IF EXISTS `f_fire_equipment_data`;
-- CREATE TABLE `f_fire_equipment_data` (
--   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
--   `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防监测设备id',
--   `fire_equipment_point_id` bigint(20) NOT NULL COMMENT '消防监测设备信息地址id',
--   `eq_point_name` varchar(255) DEFAULT NULL COMMENT '指标名称',
--   `eq_point_unit` varchar(255) DEFAULT NULL COMMENT '指标单位',
--   `type` varchar(50) DEFAULT NULL COMMENT '数据类型：alarm（报警）,monitor(监测)',
--   `common_address` int(11) DEFAULT NULL COMMENT '公共地址',
--   `information_address` bigint(11) DEFAULT NULL COMMENT '信息地址',
--   `e_value` varchar(255) DEFAULT NULL COMMENT '值',
--   `data_type` int(11) DEFAULT NULL COMMENT '数据类型：浮点型，整数，布尔类型',
--   `create_date` datetime DEFAULT NULL COMMENT '创建时间',
--   `occur_time` datetime DEFAULT NULL COMMENT '品质描述',
--   `quality` longtext,
--   `is_blocked` bit(1) DEFAULT b'0' COMMENT '是否被锁',
--   `isSubstituted` bit(1) DEFAULT b'0' COMMENT '是否被取代',
--   `isNotTopical` bit(1) DEFAULT b'0' COMMENT '是否非当前值',
--   `isInvalid` int(11) DEFAULT '0' COMMENT '是否有效',
--   `isOverflow` bit(1) DEFAULT b'0' COMMENT '是否越界',
--   `soe` int(11) DEFAULT '0',
--   `org_code` varchar(50) DEFAULT NULL COMMENT '组织',
--   `alarm_type` varchar(255) DEFAULT NULL,
--   `eq_point_code` varchar(225) DEFAULT '' COMMENT '点位编码',
--   `is_invalid` int(11) DEFAULT '0' COMMENT '是否有效',
--   PRIMARY KEY (`id`) USING BTREE
-- ) ENGINE=InnoDB AUTO_INCREMENT=14912 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防站点资源表';

-- ----------------------------
-- Table structure for f_fire_equipment_point
-- ----------------------------
-- DROP TABLE IF EXISTS `f_fire_equipment_point`;
-- CREATE TABLE `f_fire_equipment_point` (
--   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
--   `name` varchar(255) DEFAULT NULL COMMENT '名称',
--   `code` varchar(255) DEFAULT NULL COMMENT '编号',
--   `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防装备id',
--   `create_by` varchar(225) DEFAULT '0' COMMENT '创建者',
--   `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
--   `remark` varchar(255) DEFAULT NULL,
--   `type` varchar(32) NOT NULL COMMENT '类型：模拟量ANALOGUE，开关量SWITCH',
--   `value` varchar(50) DEFAULT NULL COMMENT '当前值保存时若为开关量（1,0）默认为1',
--   `unit` varchar(50) DEFAULT NULL COMMENT '指标项名称',
--   `org_code` varchar(50) DEFAULT NULL COMMENT '组织',
--   `alarm_type` bigint(20) DEFAULT NULL,
--   PRIMARY KEY (`id`) USING BTREE
-- ) ENGINE=InnoDB AUTO_INCREMENT=5734 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备点表';

-- ----------------------------
-- Table structure for f_fire_station
-- ----------------------------
-- DROP TABLE IF EXISTS `f_fire_station`;
-- CREATE TABLE `f_fire_station` (
--   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
--   `name` varchar(100) NOT NULL COMMENT '名称',
--   `code` varchar(50) DEFAULT NULL COMMENT '编码',
--   `type` varchar(10) DEFAULT NULL COMMENT '类型 1：消防小室，2：消防泡沫间',
--   `address` varchar(255) DEFAULT NULL COMMENT '位置',
--   `floor3d` varchar(100) DEFAULT NULL COMMENT '楼层',
--   `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
--   `is_indoor` bit(1) DEFAULT b'1' COMMENT '是否室内点：默认是',
--   `org_code` varchar(50) DEFAULT NULL COMMENT '组织',
--   `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
--   `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
--   `picture` varchar(1000) DEFAULT NULL COMMENT '图片',
--   `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
--   PRIMARY KEY (`id`) USING BTREE
-- ) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防站点';

-- ----------------------------
-- Table structure for f_fire_station_equipment
-- ----------------------------
-- DROP TABLE IF EXISTS `f_fire_station_equipment`;
-- CREATE TABLE `f_fire_station_equipment` (
--   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
--   `fire_station_id` bigint(20) NOT NULL COMMENT '消防站id',
--   `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防物资id',
--   `number` double DEFAULT NULL COMMENT '个数',
--   `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
--   `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
--   `unit` varchar(32) DEFAULT NULL,
--   PRIMARY KEY (`id`) USING BTREE
-- ) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防站点资源表';

-- ----------------------------
-- Table structure for f_fire_strength
-- ----------------------------
-- DROP TABLE IF EXISTS `f_fire_strength`;
-- CREATE TABLE `f_fire_strength` (
--   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
--   `username` varchar(50) NOT NULL COMMENT '名称',
--   `code` varchar(50) DEFAULT NULL COMMENT '编码',
--   `position` varchar(50) DEFAULT NULL COMMENT '职位',
--   `tel` varchar(20) DEFAULT NULL COMMENT '固话',
--   `phone_num` varchar(20) DEFAULT NULL COMMENT '移动号码',
--   `job_des` varchar(500) DEFAULT NULL COMMENT '工作描述',
--   `remark` varchar(500) DEFAULT NULL COMMENT '备注',
--   `org_code` varchar(255) DEFAULT NULL COMMENT '组织',
--   `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
--   `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
--   `day_end` time DEFAULT NULL COMMENT '结束时间',
--   `day_begin` time DEFAULT NULL COMMENT '开始时间',
--   PRIMARY KEY (`id`) USING BTREE
-- ) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防力量';

-- ----------------------------
-- Table structure for f_fmea
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea`;
CREATE TABLE `f_fmea` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `risk_factors_id` bigint(20) DEFAULT '0' COMMENT '危险因素id',
  `evaluation_sid` bigint(20) DEFAULT '0' COMMENT '危险程度',
  `evaluation_oid` bigint(20) DEFAULT '0' COMMENT '故障频数',
  `evaluation_did` bigint(20) DEFAULT '0' COMMENT '探测度',
  `rpni` decimal(10,2) DEFAULT '0.00' COMMENT '固有rpn',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `new_evaluation_oid` bigint(20) DEFAULT NULL COMMENT '最新故障频数',
  `engineering` text COMMENT '工程措施',
  `management` text COMMENT '管理措施',
  `train` text COMMENT '培训教育',
  `protection` text COMMENT '个体防护',
  `disposal` text COMMENT '应急处置',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `company_leader` varchar(255) DEFAULT NULL COMMENT '公司负责人',
  `department_leader` varchar(255) DEFAULT NULL COMMENT '部门负责人',
  `group_leader` varchar(255) DEFAULT NULL COMMENT '班组负责人',
  `person_leader` varchar(255) DEFAULT NULL COMMENT '个人负责人',
  `identify_user` varchar(255) DEFAULT NULL COMMENT '辨识人',
  `identify_method` varchar(255) DEFAULT NULL COMMENT '辨识方法',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `risk_level_id` bigint(20) DEFAULT NULL COMMENT '风险等级id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=406 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='FEMA表';

-- ----------------------------
-- Table structure for f_fmea_equipment_point
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea_equipment_point`;
CREATE TABLE `f_fmea_equipment_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmea编号',
  `equipment_point_id` bigint(20) NOT NULL COMMENT '装备指标编号',
  `state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '装备指标状态（0：正常；1：告警）',
  `important_equipment_id` bigint(20) NOT NULL COMMENT '所属重点设备id',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='fmea和装备指标的关系';

-- ----------------------------
-- Table structure for f_fmea_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea_point_inputitem`;
CREATE TABLE `f_fmea_point_inputitem` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmea编号',
  `point_inputitem_id` bigint(20) NOT NULL COMMENT '检查点和项关系编号',
  `state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '检查项状态（0：正常；1：不合格）',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='fmea和检查项的关系';

-- ----------------------------
-- Table structure for f_preplan_picture
-- ----------------------------
DROP TABLE IF EXISTS `f_preplan_picture`;
CREATE TABLE `f_preplan_picture` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `equipment_id` bigint(20) NOT NULL COMMENT '设备编号',
  `type` int(11) NOT NULL COMMENT '类型',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `picture` text COMMENT '图片路径地址',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备预案图';

-- ----------------------------
-- Table structure for f_risk_factor
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_factor`;
CREATE TABLE `f_risk_factor` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `accident_type_id` bigint(20) NOT NULL COMMENT '失效/事故影响',
  `type` varchar(255) DEFAULT NULL COMMENT '分类',
  `dept_id` varchar(255) DEFAULT '0' COMMENT '维护部门',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='危险因素表';

-- ----------------------------
-- Table structure for f_risk_level
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_level`;
CREATE TABLE `f_risk_level` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `level` varchar(100) DEFAULT NULL COMMENT '等级',
  `evaluation_model_id` bigint(20) DEFAULT '1' COMMENT '评价模型id',
  `severity` varchar(255) DEFAULT NULL COMMENT '严重度',
  `name` varchar(255) DEFAULT NULL COMMENT '结果描述',
  `color` varchar(255) DEFAULT NULL COMMENT '图标颜色',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `top_limit` decimal(10,2) DEFAULT NULL COMMENT '上限',
  `down_limit` decimal(10,2) DEFAULT NULL COMMENT '下限',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险等级表';

-- ----------------------------
-- Table structure for f_risk_source
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_source`;
CREATE TABLE `f_risk_source` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '上级编号id',
  `risk_level_id` bigint(20) DEFAULT '0' COMMENT '风险等级id',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_region` varchar(16) DEFAULT NULL,
  `status` varchar(16) DEFAULT NULL COMMENT '状态(正常NORMAL，异常ANOMALY)',
  `increment` decimal(10,2) DEFAULT '0.00' COMMENT 'rpn增量',
  `rpni` decimal(10,2) DEFAULT '0.00' COMMENT 'rpni属性',
  `sort_num` int(10) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险点表';

-- ----------------------------
-- Table structure for f_risk_source_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_source_equipment`;
CREATE TABLE `f_risk_source_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `equipment_id` bigint(20) DEFAULT '0' COMMENT '设备指标id',
  `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防装备id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `status` int(11) DEFAULT '0' COMMENT '设备状态（1，告警； 0，正常; ）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险点关联重点设备表';

-- ----------------------------
-- Table structure for f_risk_source_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_source_point_inputitem`;
CREATE TABLE `f_risk_source_point_inputitem` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `point_id` bigint(20) DEFAULT '0' COMMENT '巡检点id',
  `point_inputitem_id` bigint(20) DEFAULT '0' COMMENT '巡检点检查项id',
  `status` varchar(32) DEFAULT '1' COMMENT '检查项状态;合格/不合格/漏检',
  `check_inputitem_id` bigint(32) DEFAULT NULL COMMENT '检查项检查记录id(p_check_input 表id)',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=491 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险点关联检查项表';

-- ----------------------------
-- Table structure for f_rpn_change_log
-- ----------------------------
DROP TABLE IF EXISTS `f_rpn_change_log`;
CREATE TABLE `f_rpn_change_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmeaId',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT '固有rpn',
  `type` int(11) DEFAULT '0' COMMENT '变化类型：0-上升；1-下降',
  `trigger_by` bigint(20) DEFAULT '0' COMMENT '触发风险id',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=330 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='rpn变化流水表';

-- ----------------------------
-- Table structure for f_text_plan
-- ----------------------------
DROP TABLE IF EXISTS `f_text_plan`;
CREATE TABLE `f_text_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id` varchar(255) NOT NULL COMMENT '预案id',
  `text_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文本预案名称',
  `file_path` varchar(255) NOT NULL COMMENT '预案路径',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文本预案';

-- ----------------------------
-- Table structure for f_topography_line
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_line`;
CREATE TABLE `f_topography_line` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `app_id` varchar(32) DEFAULT NULL COMMENT 'appid',
  `clickable` bit(1) DEFAULT NULL COMMENT '可点击',
  `from` varchar(32) DEFAULT NULL COMMENT '起点',
  `has_arrow` bit(1) DEFAULT NULL COMMENT '有箭头',
  `is_dash` bit(1) DEFAULT NULL COMMENT '是虚线',
  `line_color` int(11) DEFAULT NULL COMMENT '线颜色',
  `to` varchar(32) DEFAULT NULL COMMENT '终点',
  `from_port` varchar(32) DEFAULT NULL,
  `to_port` varchar(32) DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL COMMENT '1 领导架构 | 2 任务流程',
  `category` varchar(32) DEFAULT '' COMMENT '类别',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for f_topography_node
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_node`;
CREATE TABLE `f_topography_node` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `category` varchar(32) DEFAULT NULL COMMENT '类别',
  `group` varchar(32) DEFAULT '' COMMENT '分组',
  `is_group` bit(1) DEFAULT NULL COMMENT '是否是组',
  `key` varchar(32) DEFAULT NULL COMMENT 'key',
  `loc` varchar(255) DEFAULT NULL COMMENT '位置',
  `picture` varchar(32) DEFAULT NULL COMMENT '图片',
  `size` varchar(32) DEFAULT NULL COMMENT '大小',
  `source_id` varchar(32) DEFAULT NULL COMMENT '资源id',
  `text` varchar(32) DEFAULT NULL COMMENT '文本',
  `app_id` varchar(32) DEFAULT NULL COMMENT 'appid',
  `type` varchar(32) DEFAULT NULL COMMENT '1 领导架构 | 2 任务流程',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for f_topography_node_detail
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_node_detail`;
CREATE TABLE `f_topography_node_detail` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `node_detail` text COMMENT '详情',
  `nodeid` varchar(36) DEFAULT NULL,
  `nodekey` varchar(32) DEFAULT NULL COMMENT '节点key',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for f_water_resource
-- ----------------------------
-- DROP TABLE IF EXISTS `f_water_resource`;
-- CREATE TABLE `f_water_resource` (
--   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
--   `name` varchar(100) NOT NULL COMMENT '名称',
--   `code` varchar(50) DEFAULT NULL COMMENT '编码',
--   `type` varchar(10) DEFAULT NULL COMMENT '类型： 1：消火栓，2：消防水池，3：喷淋',
--   `production_area` varchar(255) DEFAULT NULL COMMENT '区域',
--   `floor3d` varchar(100) DEFAULT NULL COMMENT '楼层',
--   `room` varchar(255) DEFAULT NULL COMMENT '房间',
--   `address` varchar(255) DEFAULT NULL COMMENT '位置',
--   `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
--   `org_code` varchar(50) DEFAULT NULL COMMENT '组织',
--   `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
--   `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
--   `is_indoor` bit(1) DEFAULT b'1' COMMENT '是否室内点：默认是',
--   `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
--   `max_level` varchar(255) DEFAULT '0' COMMENT '最大液位',
--   `alarm_level` varchar(255) DEFAULT '0' COMMENT '告警液位',
--   `area` varchar(255) DEFAULT '0' COMMENT '水池面積',
--   PRIMARY KEY (`id`) USING BTREE
-- ) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='水资源表';

-- ----------------------------
-- Table structure for f_water_resource_equipment
-- ----------------------------
-- DROP TABLE IF EXISTS `f_water_resource_equipment`;
-- CREATE TABLE `f_water_resource_equipment` (
--   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
--   `water_resource_id` bigint(20) NOT NULL,
--   `fire_equipment_id` bigint(20) NOT NULL,
--   `number` double DEFAULT NULL COMMENT '个数',
--   `unit` varchar(16) DEFAULT NULL COMMENT '单位',
--   `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
--   PRIMARY KEY (`id`) USING BTREE
-- ) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='水资源设备表';
-- ----------------------------
-- Table structure for contingency_original_data
-- ----------------------------
DROP TABLE IF EXISTS contingency_original_data;
CREATE TABLE `contingency_original_data` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `fire_Equipment_Name` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `fire_Equipment_Id` varchar(500) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `layer` int(11) NOT NULL COMMENT '一级分类',
  `fire_Equipment_Layer` int(11) NOT NULL COMMENT '二级分类',
  `fire_Equipment_Position` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `equipment_Id` int(11) NOT NULL COMMENT '排序',
  `equipment_Name` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `admin_Name` varchar(255) DEFAULT NULL,
  `camera_Codes` varchar(255) DEFAULT NULL,
  `camera_Ids` varchar(255) DEFAULT NULL,
  `fire_Count` int(11) DEFAULT NULL,
  `confirm` varchar(255) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `batch_No` varchar(36) NOT NULL,
  `picture1` varchar(255) DEFAULT NULL,
  `picture2` varchar(255) DEFAULT NULL,
  `picture4` varchar(255) DEFAULT NULL,
  `picture3` varchar(255) DEFAULT NULL,
  `fire_Truck_Route` varchar(2000) DEFAULT NULL,
  `runstep` bit(1) DEFAULT NULL,
  `step_state` varchar(255) DEFAULT NULL,
  `step` varchar(255) DEFAULT NULL,
  `equipment_position3d` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `INDEX_BATCH_NO` (`batch_No`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='应急预案信息节点定义';
-- ----------------------------
-- Table structure for contingency_plan
-- ----------------------------
DROP TABLE IF EXISTS contingency_plan;
CREATE TABLE `contingency_plan` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `record_type` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `content` varchar(500) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `category` varchar(36) NOT NULL COMMENT '一级分类',
  `sub_category` varchar(36) NOT NULL COMMENT '二级分类',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `sort` int(11) NOT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='应急预案信息节点定义';
-- ----------------------------
-- Table structure for contingency_plan_instance
-- ----------------------------
DROP TABLE IF EXISTS contingency_plan_instance;
CREATE TABLE `contingency_plan_instance` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `record_type` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `category` varchar(36) DEFAULT NULL COMMENT '一级分类',
  `content` varchar(2000) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `sort` int(11) DEFAULT NULL COMMENT '所有节点一起的排序号',
  `sequence_num` int(11) DEFAULT NULL COMMENT '用于显示的序号',
  `batch_no` varchar(36) NOT NULL COMMENT '预案实例编号,暂时无法区分多个火灾，暂时存储报警设备id',
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `tips` varchar(255) DEFAULT NULL,
  `runstate` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='应急预案执行记录实例';
SET FOREIGN_KEY_CHECKS=1;
