package com.yeejoin.amos.fas.dao.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * c_plan_operation_record
 * @author 
 */
@Data
@Entity
@Table(name="c_plan_operation_record")
@NamedQuery(name="PlanOperationRecord.findAll", query="SELECT e FROM PlanOperationRecord e")
public class PlanOperationRecord extends BasicEntity {

    /**
     * 预案ID
     */
    @Column(name="plan_id")
    private Long planId;

    /**
     * 运行模式（0、模拟，1、自动）
     */
    @Column(name="plan_pattern")
    private Integer planPattern;

    /**
     * 开始时间
     */
    @Column(name="start_time")
    private Date startTime;

    /**
     * 结束时间
     */
    @Column(name="end_time")
    private Date endTime;

    /**
     * 批次号
     */
    @Column(name="batch_no")
    private String batchNo;

    /**
     * 是否删除
     */
    @Column(name="is_delete")
    private Boolean isDelete;

    /**
     * 运行状态（0、运行中，1、完毕，3、中断）
     */
    private Integer status;

    private static final long serialVersionUID = 1L;
}