package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.ContingencyPlanService;
import com.yeejoin.amos.fas.business.vo.PlanDetailVo;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/api/contingencyPlan")
@Api("预案api")
public class ContingencyPlanController extends BaseController {

    @Autowired
    private ContingencyPlanService contingencyPlanService;

    /**
     * 创建数字预案
     */
    @Permission
    @ApiOperation(value = "创建数字预案", notes = "创建数字预案")
    @PostMapping(value = "", produces = "application/json;charset=UTF-8")
    public CommonResponse createPlan(@RequestBody PlanDetailVo planDetail) {
        if (null == planDetail) {
            return CommonResponseUtil.failure("参数有误");
        }
        AgencyUserModel curUser = getUserInfo();
        planDetail.setCreator(curUser.getUserId());
        planDetail.setOrgCode(getOrgCode(getSelectedOrgInfo()));
        return CommonResponseUtil.success(contingencyPlanService.createPlan(planDetail));
    }

    /**
     * 修改数字预案
     */
    @Permission
    @ApiOperation(value = "修改数字预案", notes = "修改数字预案")
    @PutMapping(value = "", produces = "application/json;charset=UTF-8")
    public CommonResponse editPlan(@RequestBody PlanDetailVo planDetail) {
        if (null == planDetail) {
            return CommonResponseUtil.failure("参数有误");
        }
        AgencyUserModel curUser = getUserInfo();
        planDetail.setReviser(curUser.getUserId());
        planDetail.setUpdateTime(new Date());
        return CommonResponseUtil.success(contingencyPlanService.editPlan(planDetail));
    }

    /**
     * 查看数字预案详情
     */
    @Permission
    @ApiOperation(value = "查看数字预案详情", notes = "查看数字预案详情")
    @GetMapping(value = "/{id}", produces = "application/json;charset=UTF-8")
    public CommonResponse createPlan(@PathVariable(value = "id") Long id) {
        if (null == id) {
            return CommonResponseUtil.failure("参数有误");
        }
        return CommonResponseUtil.success(contingencyPlanService.detail(id));
    }

    /**
     * 启用预案
     */
    @Permission
    @ApiOperation(value = "启用预案", notes = "启用预案")
    @PutMapping(value = "/activate", produces = "application/json;charset=UTF-8")
    public CommonResponse activatePlan(@RequestBody List<Long> idList) {
        if (null == idList || idList.isEmpty()) {
            return CommonResponseUtil.failure("参数有误");
        }
        return CommonResponseUtil.success(contingencyPlanService.activatePlan(idList));
    }

    /**
     * 停用预案
     */
    @Permission
    @ApiOperation(value = "停用预案", notes = "停用预案")
    @PutMapping(value = "/deactivate", produces = "application/json;charset=UTF-8")
    public CommonResponse deactivatePlan(@RequestBody List<Long> idList) {
        if (null == idList || idList.isEmpty()) {
            return CommonResponseUtil.failure("参数有误");
        }
        return CommonResponseUtil.success(contingencyPlanService.deactivatePlan(idList));
    }


    /**
     * 删除预案
     */
    @Permission
    @ApiOperation(value = "停用预案", notes = "停用预案")
    @DeleteMapping(value = "/{ids}", produces = "application/json;charset=UTF-8")
    public CommonResponse deactivatePlan(@PathVariable(value = "ids") String idStr) {
        if (StringUtils.isBlank(idStr)) {
            return CommonResponseUtil.failure("参数有误");
        }
        String[] idArr = idStr.split(",");
        List<Long> idList = new ArrayList();
        for (String id : idArr) {
            if (id.trim().length() > 0 && StringUtils.isNumeric(id.trim())) {
                idList.add(Long.valueOf(id.trim()));
            }
        }
        return CommonResponseUtil.success(contingencyPlanService.delete(idList));
    }
}
