package com.yeejoin.amos.fas.business.dao.mapper;

import com.yeejoin.amos.fas.dao.entity.FmeaEquipmentPoint;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface FmeaEquipmentPointMapper extends BaseMapper {

    void deleteByFmeaIdAndEquipmentPointIds(@Param("fmeaId") Long fmeaId, @Param("importantEquipId") Long importantEquipId, @Param("equipmentPointIds") List<Long> equipmentPointIds);

    void deleteByFmeaIds(Long[] fmeaIds);

    Long saveBatch(List<FmeaEquipmentPoint> list);

    Long countByFmeaId(Long fmeaId);

    List<Map<String, Object>> listByFmeaId(@Param("fmeaId") Long fmeaId, @Param("offset") Integer offset, @Param("limit") Integer limit);

    Long countEquipmentPoint(Long equipmentId);

    List<Long> listEquipmentPointIdsByEquipmentId(Long equipmentId);

    List<Map<String, Object>> listEquipmentPoint(@Param("fmeaId") Long fmeaId, @Param("importantEquipId") Long importantEquipId, @Param("equipmentId") Long equipmentId, @Param("equipmentPointName") String equipmentPointName);

    List<FmeaEquipmentPoint> listByEquipmentPointId(Long equipmentPointId);

    List<FmeaEquipmentPoint> listFmeaByFmeaId(Long fmeaId);

    void updateStateByIds(@Param("state") Integer state,
                          @Param("ids") List<Long> ids);

    List<FmeaEquipmentPoint> listFmeaByEquipIndexIdAndEquipId(@Param("specificIndexId") long specificIndexId, @Param("equipId") long equipId);
}
