package com.yeejoin.amos.fas.business.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.fas.business.bo.FireEquipmentBo;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.ImpEquipMapper;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipService;
import com.yeejoin.amos.fas.business.util.FireEquipmentType;
import com.yeejoin.amos.fas.common.enums.EquipClassifyEnum;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.response.CommonPage;

@Service("fireEquipService")
public class FireEquipServiceImpl implements IFireEquipService {

    @Autowired
    FireEquipMapper fireEquipMapper;

    @Autowired
    ImpEquipMapper impEquipMapper;

//    @Autowired
//    IWaterResourceDao iWaterResourceDao;

//    @Autowired
//    IFireStationDao iFireStationDao;

//    public FireEquipment save(FireEquipment fireEquipment) {
//    	Long id = fireEquipment.getId();
//    	iFireEquipmentDao.save(fireEquipment);
//		return fireEquipment;
//    }
//
//
//    public FireEquipment queryOne(Long id) {
//    	Optional<FireEquipment> fireEquipment1=iFireEquipmentDao.findById(id);
//    	if(fireEquipment1.isPresent()){
//    		return fireEquipment1.get();
//    	}
//    	return null;
//    }

    public String[] delete(String[] idArray) throws Exception {
//        for (String id : idArray) {
//            Optional<FireEquipment> fireEquipment1 = iFireEquipmentDao.findById(Long.parseLong(id));
//            FireEquipment fireEquipment=null;
//            if(fireEquipment1.isPresent()){
//            	fireEquipment= fireEquipment1.get();
//        	}
//
//            if (fireEquipment != null) {
//                this.iFireEquipmentDao.deleteById(Long.parseLong(id));
//            } else {
//                throw new Exception("找不到指定的对象:" + id);
//            }
//        }

        return idArray;
    }


    @Override
    public Page<HashMap<String, Object>> queryFireEquip(CommonPageInfoParam param) {
        long total = fireEquipMapper.countPageData(param);
        List<HashMap<String, Object>> content = fireEquipMapper.getFireEquipPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, param, total);
        return result;
    }

    @Override
    public Page<HashMap<String, Object>> queryFireEquipByProId(CommonPageInfoParam param) {
        long total = fireEquipMapper.countFireEquipByEquipIdPageData(param);
        List<HashMap<String, Object>> content = fireEquipMapper.getFFireEquipByEquipIdPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, param, total);
        return result;
    }

    @Override
    public List<String> findFireEquipArea() {
    	return null;
//        return iFireEquipmentDao.findFireEquipArea();
    }


    //查询 消防设备历史数据
    public Page queryForFireEquipmentHistory(String fireEquipmentName,
                                                  String equipmentName,
                                                  String startTime,
                                                  String endTime,
                                                                      CommonPageable commonPageable) {

        long total = fireEquipMapper.queryForFireEquipmentHistoryCount( fireEquipmentName,equipmentName,
                startTime,
                endTime);

        List<Map> content  =  fireEquipMapper.queryForFireEquipmentHistory(fireEquipmentName,
                equipmentName,
                startTime,
                endTime,
                commonPageable.getOffset(),
                commonPageable.getPageSize());
        Page result = new CommonPage(content,  commonPageable, total);
        return result;
    }


   public  Page queryForEquipmentList(String name, String code,String equipClassify,CommonPageable commonPageable,String bindStation) {
       long total = fireEquipMapper.queryForEquipmentPageCount( name, code,equipClassify,bindStation);
       List<Map> content  =  this.fireEquipMapper.queryForEquipmentPage(name, code,equipClassify,commonPageable.getOffset(),commonPageable.getPageSize(),bindStation);
       Page result = new CommonPage(content, commonPageable, total);
       return result;
    }


    /**
     * 查询设备信息明细
     * @param type
     * @param id
     * @return
     * @throws Exception
     */
    public Object queryForDetail(String type, Long id) throws Exception
    {

        Object returnEntity = null;

        FireEquipmentType fireEquipmentType = FireEquipmentType.valueOf(type);

        switch (fireEquipmentType)
        {
//            case pool:
//            	 FireStation fireStation = fireEquipMapper.findFireStationById(id);
//            	 fireStation.setType("2");
//                 fireStation.setFireEquipmentInfo(this.fireEquipMapper.queryStorageEquips(id));
//                 returnEntity = fireStation;
//                 break;
//            case fireFoamRoom:
//            	 FireStation fireStation1 = fireEquipMapper.findFireStationById(id);
//            	 fireStation1.setType("2");
//                 fireStation1.setFireEquipmentInfo(this.fireEquipMapper.queryStorageEquips(id));
//                 returnEntity = fireStation1;
//                 break;
//            case fireChamber:
//            	 FireStation fireStation11 = fireEquipMapper.findFireStationById(id);
//            	 fireStation11.setType("1");
//                fireStation11.setFireEquipmentInfo(this.fireEquipMapper.queryStorageEquips(id));
//                returnEntity = fireStation11;
//                break;
            case extinguisher:
            case hydrant:
            case monitorEquipment:
            	FireEquipmentBo fireEquipment=fireEquipMapper.findFireEquipById(id);
                fireEquipment.setEquipClassify(Integer.parseInt(EquipClassifyEnum.EQUIPMENT.getCode()));
                returnEntity = fireEquipment;
                break;
            case video:
            	FireEquipmentBo fireVideo = fireEquipMapper.findVideoById(id);
                fireVideo.setEquipClassify(Integer.parseInt(EquipClassifyEnum.VIDEO.getCode()));
                returnEntity = fireVideo;
                break;

            case fireDetection:
            	FireEquipmentBo fireDetection=fireEquipMapper.findFireEquipById(id);
                
            	fireDetection.setProtectObjNames(this.impEquipMapper.queryProtectObjNames(fireDetection.getId()));
                returnEntity = fireDetection;
                break;
            default:
                throw new Exception("类型有误.");

        }
        return returnEntity;
    }

//    @Override
//    public int countAssociatedEquipStationByIds(String[] ids) {
//        return iFireEquipmentDao.countAssociatedEquipStationByIds(ids);
//    }


//	@Override
//	public Boolean isExistByCode(String code) {
//		Optional<FireEquipment> optional = iFireEquipmentDao.findByCode(code);
//		return optional.isPresent();
//	}
}
