package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.repository.IPlanClassifyTreeDao;
import com.yeejoin.amos.fas.business.service.intfc.PlanClassifyTreeService;
import com.yeejoin.amos.fas.business.vo.PlanClassifyTreeVo;
import com.yeejoin.amos.fas.dao.entity.PlanClassifyTree;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.TreeBuilder;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.*;

/**
 *@program: YeeAmosFireAutoSysRoot
 *@description: 预案分类树实现类
 *@author: wujunkai
 *@create: 2021-01-14 14:59
 */
@Service("PlanClassifyTreeService")
public class PlanClassifyTreeServiceImpl  implements PlanClassifyTreeService {
    public static final Long ROOT = 0L;

    @Autowired
    private IPlanClassifyTreeDao planClassifyTreeDao;

    @Override
    public PlanClassifyTree save(PlanClassifyTree model) {
        return planClassifyTreeDao.save(model);
    }

    @Override
    public void delete(String ids) {
        List<Long> seqs = StringUtil.String2LongList(ids);
        for (Long seq : seqs) {
            Optional<PlanClassifyTree>  PlanClassifyTreeOpt =  planClassifyTreeDao.findById(seq);
            //所有子分类
            List<PlanClassifyTree> childGroupSequenceList = getChildSequenceList(PlanClassifyTreeOpt.get());
            planClassifyTreeDao.deleteAll(childGroupSequenceList);
        }
    }

    @Override
    public Collection<PlanClassifyTreeVo> getTree() {
        List<PlanClassifyTree> list =planClassifyTreeDao.findAll();
        List<PlanClassifyTreeVo> voList = new ArrayList<>();
        for (PlanClassifyTree planClassifyTree:list) {
            PlanClassifyTreeVo  planClassifyTreeVo = new PlanClassifyTreeVo();
            BeanUtils.copyProperties(planClassifyTree,planClassifyTreeVo);
            voList.add(planClassifyTreeVo);
        }
        Map<Object, PlanClassifyTreeVo> map = Bean.listToMap(voList, "id", PlanClassifyTree.class);

        SortedSet<PlanClassifyTreeVo> completeList = new TreeSet<>();
        for (PlanClassifyTreeVo model : voList) {
            completeList.addAll(buildWithParent(model, map));
        }
        return TreeBuilder.buildByRecursive(completeList, ROOT);
    }

    private List<PlanClassifyTreeVo> buildWithParent(PlanClassifyTreeVo groupModel, Map<Object, PlanClassifyTreeVo> map) {

        List<PlanClassifyTreeVo> completeList = new ArrayList<>();
        completeList.add(groupModel);

        if (groupModel.getParentId().equals(ROOT)) {
            completeList.add(groupModel);
            return completeList;
        }

        PlanClassifyTreeVo parent = map.get(groupModel.getParentId());
        if (ValidationUtil.isEmpty(parent)) {
            parent = (PlanClassifyTreeVo) this.planClassifyTreeDao.findById(groupModel.getParentId()).get();

            if (ValidationUtil.isEmpty(parent)) {
                return completeList;
            }
        }
        completeList.add(parent);
        completeList.addAll(this.buildWithParent(parent, map));
        return completeList;
    }


    /**
     * 预案分类的子id
     *
     * @param planClassifyTree
     * @return
     */
    public List<PlanClassifyTree> getChildSequenceList(PlanClassifyTree planClassifyTree) {
        List<Long> sequenceList = new ArrayList<>();
        List<PlanClassifyTree> childList = new ArrayList<>();
        this.getAllChildList(planClassifyTree, childList);

//        for (KnowledgeDocCategoryModel tagGroupModel : childList) {
//            sequenceList.add(tagGroupModel.getSequenceNbr());
//        }
        return childList;
    }


    private void getAllChildList(PlanClassifyTree currentPlanClassifyTree, List<PlanClassifyTree> resList) {
        if (null == currentPlanClassifyTree) {
            return;
        }
        Long parentId = currentPlanClassifyTree.getId();
        List<PlanClassifyTree> childList = planClassifyTreeDao.findByParentId(parentId);
        if (!childList.isEmpty()) {
            for (PlanClassifyTree tagPlanClassifyTree : childList) {
                this.getAllChildList(tagPlanClassifyTree, resList);
            }
        }
        resList.add(currentPlanClassifyTree);
    }

}